/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.grouping;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.esql.LicenseAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.ml.MachineLearning;

public class Categorize
extends GroupingFunction.NonEvaluatableGroupingFunction
implements LicenseAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Categorize", Categorize::new);
    private final Expression field;

    @FunctionInfo(returnType={"keyword"}, description="Groups text messages into categories of similarly formatted text values.", detailedDescription="`CATEGORIZE` has the following limitations:\n\n* can\u2019t be used within other expressions\n* can\u2019t be used more than once in the groupings\n* can\u2019t be used or referenced within aggregate functions and it has to be the first grouping", examples={@Example(file="docs", tag="docsCategorize", description="This example categorizes server logs messages into categories and aggregates their counts. ")}, preview=false)
    public Categorize(Source source, @Param(name="field", type={"text", "keyword"}, description="Expression to categorize") Expression field) {
        super(source, List.of(field));
        this.field = field;
    }

    private Categorize(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
    }

    public String getWriteableName() {
        return Categorize.ENTRY.name;
    }

    public boolean foldable() {
        return false;
    }

    public Nullability nullable() {
        return Nullability.TRUE;
    }

    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isString((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    public Categorize replaceChildren(List<Expression> newChildren) {
        return new Categorize(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Categorize::new, (Object)this.field);
    }

    public Expression field() {
        return this.field;
    }

    public String toString() {
        return "Categorize{field=" + String.valueOf(this.field) + "}";
    }

    @Override
    public boolean licenseCheck(XPackLicenseState state) {
        return MachineLearning.CATEGORIZE_TEXT_AGG_FEATURE.check(state);
    }
}

