/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AsyncOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.IsBlockedResult;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.lookup.RightChunkedLeftJoin;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexService;

public final class LookupFromIndexOperator
extends AsyncOperator<OngoingJoin> {
    private final LookupFromIndexService lookupService;
    private final String sessionId;
    private final CancellableTask parentTask;
    private final int inputChannel;
    private final DataType inputDataType;
    private final String lookupIndexPattern;
    private final String lookupIndex;
    private final String matchField;
    private final List<NamedExpression> loadFields;
    private final Source source;
    private long totalTerms = 0L;
    private long emittedPages = 0L;
    private OngoingJoin ongoing = null;

    public LookupFromIndexOperator(String sessionId, DriverContext driverContext, CancellableTask parentTask, int maxOutstandingRequests, int inputChannel, LookupFromIndexService lookupService, DataType inputDataType, String lookupIndexPattern, String lookupIndex, String matchField, List<NamedExpression> loadFields, Source source) {
        super(driverContext, maxOutstandingRequests);
        this.sessionId = sessionId;
        this.parentTask = parentTask;
        this.inputChannel = inputChannel;
        this.lookupService = lookupService;
        this.inputDataType = inputDataType;
        this.lookupIndexPattern = lookupIndexPattern;
        this.lookupIndex = lookupIndex;
        this.matchField = matchField;
        this.loadFields = loadFields;
        this.source = source;
    }

    protected void performAsync(Page inputPage, ActionListener<OngoingJoin> listener) {
        Block inputBlock = inputPage.getBlock(this.inputChannel);
        this.totalTerms += (long)inputBlock.getTotalValueCount();
        LookupFromIndexService.Request request = new LookupFromIndexService.Request(this.sessionId, this.lookupIndex, this.lookupIndexPattern, this.inputDataType, this.matchField, new Page(new Block[]{inputBlock}), this.loadFields, this.source);
        this.lookupService.lookupAsync(request, this.parentTask, (ActionListener<List<Page>>)listener.map(pages -> new OngoingJoin(new RightChunkedLeftJoin(inputPage, this.loadFields.size()), pages.iterator())));
    }

    public Page getOutput() {
        if (this.ongoing == null) {
            this.ongoing = (OngoingJoin)this.fetchFromBuffer();
            if (this.ongoing == null) {
                return null;
            }
        }
        if (this.ongoing.itr.hasNext()) {
            Page right = this.ongoing.itr.next();
            ++this.emittedPages;
            try {
                Page page = this.ongoing.join.join(right);
                return page;
            }
            finally {
                right.releaseBlocks();
            }
        }
        Optional remaining = this.ongoing.join.noMoreRightHandPages();
        this.ongoing.close();
        this.ongoing = null;
        if (remaining.isEmpty()) {
            return null;
        }
        ++this.emittedPages;
        return (Page)remaining.get();
    }

    protected void releaseFetchedOnAnyThread(OngoingJoin ongoingJoin) {
        ongoingJoin.releaseOnAnyThread();
    }

    public String toString() {
        return "LookupOperator[index=" + this.lookupIndex + " input_type=" + String.valueOf(this.inputDataType) + " match_field=" + this.matchField + " load_fields=" + String.valueOf(this.loadFields) + " inputChannel=" + this.inputChannel + "]";
    }

    public boolean isFinished() {
        return this.ongoing == null && super.isFinished();
    }

    public IsBlockedResult isBlocked() {
        if (this.ongoing != null) {
            return NOT_BLOCKED;
        }
        return super.isBlocked();
    }

    protected void doClose() {
        Releasables.close((Releasable)this.ongoing);
    }

    protected Operator.Status status(long receivedPages, long completedPages, long totalTimeInMillis) {
        return new Status(receivedPages, completedPages, totalTimeInMillis, this.totalTerms, this.emittedPages);
    }

    protected record OngoingJoin(RightChunkedLeftJoin join, Iterator<Page> itr) implements Releasable
    {
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.join, Releasables.wrap(() -> Iterators.map(this.itr, page -> () -> ((Page)page).releaseBlocks()))});
        }

        public void releaseOnAnyThread() {
            Releasable[] releasableArray = new Releasable[2];
            releasableArray[0] = () -> ((RightChunkedLeftJoin)this.join).releaseOnAnyThread();
            releasableArray[1] = Releasables.wrap(() -> Iterators.map(this.itr, page -> () -> LookupFromIndexOperator.releasePageOnAnyThread((Page)page)));
            Releasables.close((Releasable[])releasableArray);
        }
    }

    public static class Status
    extends AsyncOperator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "lookup", Status::new);
        private final long totalTerms;
        private final long emittedPages;

        Status(long receivedPages, long completedPages, long totalTimeInMillis, long totalTerms, long emittedPages) {
            super(receivedPages, completedPages, totalTimeInMillis);
            this.totalTerms = totalTerms;
            this.emittedPages = emittedPages;
        }

        Status(StreamInput in) throws IOException {
            super(in);
            this.totalTerms = in.readVLong();
            this.emittedPages = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.totalTerms);
            out.writeVLong(this.emittedPages);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public long emittedPages() {
            return this.emittedPages;
        }

        public long totalTerms() {
            return this.totalTerms;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            super.innerToXContent(builder);
            builder.field("emitted_pages", this.emittedPages());
            builder.field("total_terms", this.totalTerms());
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
                return false;
            }
            Status status = (Status)((Object)o);
            return this.totalTerms == status.totalTerms && this.emittedPages == status.emittedPages;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.totalTerms, this.emittedPages);
        }
    }

    public record Factory(String sessionId, CancellableTask parentTask, int maxOutstandingRequests, int inputChannel, Function<DriverContext, LookupFromIndexService> lookupService, DataType inputDataType, String lookupIndexPattern, String lookupIndex, FieldAttribute.FieldName matchField, List<NamedExpression> loadFields, Source source) implements Operator.OperatorFactory
    {
        public String describe() {
            return "LookupOperator[index=" + this.lookupIndex + " input_type=" + String.valueOf(this.inputDataType) + " match_field=" + this.matchField.string() + " load_fields=" + String.valueOf(this.loadFields) + " inputChannel=" + this.inputChannel + "]";
        }

        public Operator get(DriverContext driverContext) {
            return new LookupFromIndexOperator(this.sessionId, driverContext, this.parentTask, this.maxOutstandingRequests, this.inputChannel, this.lookupService.apply(driverContext), this.inputDataType, this.lookupIndexPattern, this.lookupIndex, this.matchField.string(), this.loadFields, this.source);
        }
    }
}

