/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.HandlingTimeTracker;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.BytesRefRecycler;
import org.elasticsearch.transport.CloseableConnection;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.Header;
import org.elasticsearch.transport.HeaderValidationException;
import org.elasticsearch.transport.InboundHandler;
import org.elasticsearch.transport.InboundMessage;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.OutboundHandler;
import org.elasticsearch.transport.RawIndexingDataTransportRequest;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.ResponseStatsConsumer;
import org.elasticsearch.transport.StatsTracker;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpServerChannel;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportHandshaker;
import org.elasticsearch.transport.TransportKeepAlive;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportNotReadyException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.TransportStats;
import org.elasticsearch.transport.Transports;

public abstract class TcpTransport
extends AbstractLifecycleComponent
implements Transport {
    private static final Logger logger = LogManager.getLogger(TcpTransport.class);
    public static final String TRANSPORT_WORKER_THREAD_NAME_PREFIX = "transport_worker";
    private static final int BYTES_NEEDED_FOR_MESSAGE_SIZE = 6;
    private static final long THIRTY_PER_HEAP_SIZE = (long)((double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() * 0.3);
    final StatsTracker statsTracker = new StatsTracker();
    private static final int LIMIT_LOCAL_PORTS_COUNT = 6;
    static final Setting<Boolean> IGNORE_DESERIALIZATION_ERRORS_SETTING = Setting.boolSetting("transport.ignore_deserialization_errors", false, Setting.Property.NodeScope);
    private final boolean ignoreDeserializationErrors;
    protected final Settings settings;
    protected final ThreadPool threadPool;
    protected final Recycler<BytesRef> recycler;
    protected final NetworkService networkService;
    protected final Set<ProfileSettings> profileSettingsSet;
    protected final boolean rstOnClose;
    private final CircuitBreakerService circuitBreakerService;
    private final ConcurrentMap<String, BoundTransportAddress> profileBoundAddresses = ConcurrentCollections.newConcurrentMap();
    private final Map<String, List<TcpServerChannel>> serverChannels = ConcurrentCollections.newConcurrentMap();
    private final Set<TcpChannel> acceptedChannels = ConcurrentCollections.newConcurrentSet();
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    private volatile BoundTransportAddress boundAddress;
    private final TransportHandshaker handshaker;
    private final TransportKeepAlive keepAlive;
    private final HandlingTimeTracker outboundHandlingTimeTracker = new HandlingTimeTracker();
    private final OutboundHandler outboundHandler;
    private final InboundHandler inboundHandler;
    private final Transport.ResponseHandlers responseHandlers = new Transport.ResponseHandlers();
    private final Transport.RequestHandlers requestHandlers = new Transport.RequestHandlers();
    private final AtomicLong outboundConnectionCount = new AtomicLong();
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::([\\d\\-]*))?$");

    public TcpTransport(Settings settings, TransportVersion version, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        this.settings = settings;
        this.profileSettingsSet = TcpTransport.getProfileSettings(settings);
        this.threadPool = threadPool;
        this.circuitBreakerService = circuitBreakerService;
        this.networkService = networkService;
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        this.rstOnClose = TransportSettings.RST_ON_CLOSE.get(settings);
        this.recycler = this.createRecycler(settings, pageCacheRecycler);
        this.outboundHandler = new OutboundHandler(nodeName, version, this.statsTracker, threadPool, this.recycler, this.outboundHandlingTimeTracker, this.rstOnClose);
        this.ignoreDeserializationErrors = IGNORE_DESERIALIZATION_ERRORS_SETTING.get(settings);
        this.handshaker = new TransportHandshaker(version, threadPool, (node, channel, requestId, v) -> this.outboundHandler.sendRequest(node, channel, requestId, "internal:tcp/handshake", new TransportHandshaker.HandshakeRequest(version, Build.current().version()), TransportRequestOptions.EMPTY, v, null, true), this.ignoreDeserializationErrors);
        this.keepAlive = new TransportKeepAlive(threadPool, this.outboundHandler::sendBytes);
        this.inboundHandler = new InboundHandler(threadPool, this.outboundHandler, namedWriteableRegistry, this.handshaker, this.keepAlive, this.requestHandlers, this.responseHandlers, networkService.getHandlingTimeTracker(), this.ignoreDeserializationErrors);
    }

    public StatsTracker getStatsTracker() {
        return this.statsTracker;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Supplier<CircuitBreaker> getInflightBreaker() {
        return () -> this.circuitBreakerService.getBreaker("inflight_requests");
    }

    @Override
    public synchronized void setMessageListener(TransportMessageListener listener) {
        this.outboundHandler.setMessageListener(listener);
        this.inboundHandler.setMessageListener(listener);
    }

    @Override
    public void setSlowLogThreshold(TimeValue slowLogThreshold) {
        this.inboundHandler.setSlowLogThreshold(slowLogThreshold);
        this.outboundHandler.setSlowLogThreshold(slowLogThreshold);
    }

    public boolean ignoreDeserializationErrors() {
        return this.ignoreDeserializationErrors;
    }

    protected static ConnectionProfile maybeOverrideConnectionProfile(ConnectionProfile connectionProfile) {
        return connectionProfile;
    }

    protected Recycler<BytesRef> createRecycler(Settings settings, PageCacheRecycler pageCacheRecycler) {
        return new BytesRefRecycler(pageCacheRecycler);
    }

    @Override
    public void openConnection(DiscoveryNode node, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        ActionListener.run(listener, l -> {
            Objects.requireNonNull(profile, "connection profile cannot be null");
            if (node == null) {
                throw new ConnectTransportException(null, "can't open connection to a null node");
            }
            ConnectionProfile finalProfile = TcpTransport.maybeOverrideConnectionProfile(profile);
            if (!this.closeLock.readLock().tryLock()) {
                this.ensureOpen();
                assert (false) : "should not get here ever because close-write-lock should only be held on shutdown";
                throw new ConnectTransportException(node, "failed to acquire close-read-lock");
            }
            try {
                this.ensureOpen();
                this.initiateConnection(node, finalProfile, (ActionListener<Transport.Connection>)l);
            }
            finally {
                this.closeLock.readLock().unlock();
            }
        });
    }

    private void initiateConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        int numConnections = connectionProfile.getNumConnections();
        assert (numConnections > 0) : "A connection profile must be configured with at least one connection";
        ArrayList<TcpChannel> channels = new ArrayList<TcpChannel>(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            try {
                TcpChannel channel = this.initiateChannel(node, connectionProfile);
                if (logger.isTraceEnabled()) {
                    channel.addConnectListener(new ChannelOpenTraceLogger(channel));
                }
                channels.add(channel);
                continue;
            }
            catch (ConnectTransportException e) {
                CloseableChannel.closeChannels(channels, false);
                listener.onFailure(e);
                return;
            }
            catch (Exception e) {
                CloseableChannel.closeChannels(channels, false);
                listener.onFailure(new ConnectTransportException(node, "general node connection failure", e));
                return;
            }
        }
        ChannelsConnectedListener channelsConnectedListener = new ChannelsConnectedListener(node, connectionProfile, channels, new ThreadedActionListener<Transport.Connection>(this.threadPool.generic(), listener));
        for (TcpChannel channel : channels) {
            channel.addConnectListener(channelsConnectedListener);
        }
        TimeValue connectTimeout = connectionProfile.getConnectTimeout();
        this.threadPool.schedule(channelsConnectedListener::onTimeout, connectTimeout, this.threadPool.generic());
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public BoundTransportAddress boundRemoteIngressAddress() {
        return this.profileBoundAddresses().get("_remote_cluster");
    }

    @Override
    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return Collections.unmodifiableMap(new HashMap<String, BoundTransportAddress>(this.profileBoundAddresses));
    }

    @Override
    public List<String> getDefaultSeedAddresses() {
        ArrayList<String> local = new ArrayList<String>();
        local.add("127.0.0.1");
        if (NetworkUtils.SUPPORTS_V6) {
            local.add("[::1]");
        }
        return local.stream().flatMap(address -> Arrays.stream(this.defaultPortRange()).limit(6L).mapToObj(port -> address + ":" + port)).toList();
    }

    protected void bindServer(ProfileSettings profileSettings) {
        InetAddress[] hostAddresses;
        List<String> profileBindHosts = profileSettings.bindHosts;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(profileBindHosts.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY));
        }
        catch (IOException e) {
            throw new BindTransportException("Failed to resolve host " + String.valueOf(profileBindHosts), e);
        }
        if (logger.isDebugEnabled()) {
            String[] addresses = new String[hostAddresses.length];
            for (int i = 0; i < hostAddresses.length; ++i) {
                addresses[i] = NetworkAddress.format(hostAddresses[i]);
            }
            logger.debug("binding server bootstrap to: {}", (Object)addresses);
        }
        assert (hostAddresses.length > 0);
        ArrayList<InetSocketAddress> boundAddresses = new ArrayList<InetSocketAddress>();
        for (InetAddress hostAddress : hostAddresses) {
            boundAddresses.add(this.bindToPort(profileSettings.profileName, hostAddress, profileSettings.portOrRange));
        }
        BoundTransportAddress boundTransportAddress = this.createBoundTransportAddress(profileSettings, boundAddresses);
        if (profileSettings.isDefaultProfile) {
            this.boundAddress = boundTransportAddress;
        } else {
            this.profileBoundAddresses.put(profileSettings.profileName, boundTransportAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress bindToPort(String name, InetAddress hostAddress, String port) {
        PortsRange portsRange = new PortsRange(port);
        AtomicReference lastException = new AtomicReference();
        AtomicReference boundSocket = new AtomicReference();
        if (!this.closeLock.writeLock().tryLock()) {
            assert (false);
            throw new IllegalStateException("failed to acquire close-write-lock");
        }
        try {
            if (!this.lifecycle.initialized() && !this.lifecycle.started()) {
                throw new IllegalStateException("transport has been stopped");
            }
            boolean success = portsRange.iterate(portNumber -> {
                try {
                    TcpServerChannel channel = this.bind(name, new InetSocketAddress(hostAddress, portNumber));
                    this.serverChannels.computeIfAbsent(name, k -> new ArrayList()).add(channel);
                    boundSocket.set(channel.getLocalAddress());
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            });
            if (!success) {
                throw new BindTransportException("Failed to bind to " + NetworkAddress.format(hostAddress, portsRange), (Throwable)lastException.get());
            }
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bound profile [{}] to address {{}}", (Object)name, (Object)NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return (InetSocketAddress)boundSocket.get();
    }

    private BoundTransportAddress createBoundTransportAddress(ProfileSettings profileSettings, List<InetSocketAddress> boundAddresses) {
        InetAddress publishInetAddress;
        String[] boundAddressesHostStrings = new String[boundAddresses.size()];
        TransportAddress[] transportBoundAddresses = new TransportAddress[boundAddresses.size()];
        for (int i = 0; i < boundAddresses.size(); ++i) {
            InetSocketAddress nextAddress = boundAddresses.get(i);
            boundAddressesHostStrings[i] = nextAddress.getHostString();
            transportBoundAddresses[i] = new TransportAddress(nextAddress);
        }
        List<String> publishHosts = profileSettings.publishHosts;
        if (!profileSettings.isDefaultProfile && publishHosts.isEmpty()) {
            publishHosts = Arrays.asList(boundAddressesHostStrings);
        }
        if (publishHosts.isEmpty()) {
            publishHosts = NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(this.settings);
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(publishHosts.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY));
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = TcpTransport.resolvePublishPort(profileSettings, boundAddresses, publishInetAddress);
        TransportAddress publishAddress = new TransportAddress(new InetSocketAddress(publishInetAddress, publishPort));
        return new BoundTransportAddress(transportBoundAddresses, publishAddress);
    }

    static int resolvePublishPort(ProfileSettings profileSettings, List<InetSocketAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = profileSettings.publishPort;
        if (publishPort < 0) {
            for (InetSocketAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            HashSet<Integer> ports = new HashSet<Integer>();
            for (InetSocketAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = (Integer)ports.iterator().next();
            }
        }
        if (publishPort < 0) {
            String profileExplanation = profileSettings.isDefaultProfile ? "" : " for profile " + profileSettings.profileName;
            throw new BindTransportException("Failed to auto-resolve publish port" + profileExplanation + ", multiple bound addresses " + String.valueOf(boundAddresses) + " with distinct ports and none of them matched the publish address (" + String.valueOf(publishInetAddress) + "). Please specify a unique port by setting " + TransportSettings.PORT.getKey() + " or " + TransportSettings.PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    @Override
    public TransportAddress[] addressesFromString(String address) throws UnknownHostException {
        return TcpTransport.parse(address, this.defaultPortRange()[0]);
    }

    private int[] defaultPortRange() {
        return new PortsRange(this.settings.get(TransportSettings.PORT_PROFILE.getConcreteSettingForNamespace("default").getKey(), TransportSettings.PORT.get(this.settings))).ports();
    }

    static TransportAddress[] parse(String hostPortString, int defaultPort) throws UnknownHostException {
        String host;
        Objects.requireNonNull(hostPortString);
        String portString = null;
        if (hostPortString.startsWith("[")) {
            Matcher matcher = BRACKET_PATTERN.matcher(hostPortString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid bracketed host/port range: " + hostPortString);
            }
            host = matcher.group(1);
            portString = matcher.group(2);
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
                if (colonPos >= 0) {
                    throw new IllegalArgumentException("IPv6 addresses must be bracketed: " + hostPortString);
                }
            }
        }
        int port = portString == null || portString.isEmpty() ? defaultPort : Integer.parseInt(portString);
        return (TransportAddress[])Arrays.stream(InetAddress.getAllByName(host)).distinct().map(address -> new TransportAddress((InetAddress)address, port)).toArray(TransportAddress[]::new);
    }

    @Override
    protected final void doClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doStop() {
        assert (Transports.assertNotTransportThread("Must not block transport thread that might be needed for closing channels below"));
        assert (!this.threadPool.generic().isShutdown()) : "Must stop transport before terminating underlying threadpool";
        this.closeLock.writeLock().lock();
        try {
            this.keepAlive.close();
            for (Map.Entry<String, List<TcpServerChannel>> entry : this.serverChannels.entrySet()) {
                String profile = entry.getKey();
                List<TcpServerChannel> channels = entry.getValue();
                ActionListener closeFailLogger = ActionListener.wrap(c -> {}, e -> logger.warn(() -> "Error closing serverChannel for profile [" + profile + "]", (Throwable)e));
                channels.forEach(c -> c.addCloseListener(closeFailLogger));
                CloseableChannel.closeChannels(channels, true);
            }
            this.serverChannels.clear();
            CloseableChannel.closeChannels(new ArrayList<TcpChannel>(this.acceptedChannels), true);
            this.acceptedChannels.clear();
            this.stopInternal();
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
    }

    public void onException(TcpChannel channel, Exception e) {
        TcpTransport.handleException(channel, e, this.lifecycle, this.outboundHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleException(TcpChannel channel, Exception e, Lifecycle lifecycle, OutboundHandler outboundHandler) {
        boolean closeChannel = true;
        try {
            if (!lifecycle.started()) {
                return;
            }
            Level closeConnectionExceptionLevel = NetworkExceptionHelper.getCloseConnectionExceptionLevel(e, outboundHandler.rstOnClose());
            if (closeConnectionExceptionLevel != Level.OFF) {
                if (closeConnectionExceptionLevel == Level.INFO && !logger.isDebugEnabled()) {
                    logger.info("close connection exception caught on transport layer [{}], disconnecting from relevant node: {}", (Object)channel, (Object)e.getMessage());
                } else {
                    logger.log(closeConnectionExceptionLevel, () -> Strings.format((String)"close connection exception caught on transport layer [%s], disconnecting from relevant node", (Object[])new Object[]{channel}), (Throwable)e);
                }
            } else if (NetworkExceptionHelper.isConnectException(e)) {
                logger.debug(() -> "connect exception caught on transport layer [" + String.valueOf(channel) + "]", (Throwable)e);
            } else if (e instanceof BindException) {
                logger.debug(() -> "bind exception caught on transport layer [" + String.valueOf(channel) + "]", (Throwable)e);
            } else if (e instanceof CancelledKeyException) {
                logger.debug(() -> Strings.format((String)"cancelled key exception caught on transport layer [%s], disconnecting from relevant node", (Object[])new Object[]{channel}), (Throwable)e);
            } else if (e instanceof HttpRequestOnTransportException) {
                if (channel.isOpen()) {
                    outboundHandler.sendBytes(channel, new BytesArray(e.getMessage().getBytes(StandardCharsets.UTF_8)), ActionListener.running(() -> CloseableChannel.closeChannel(channel)));
                    closeChannel = false;
                }
            } else if (e instanceof StreamCorruptedException) {
                logger.warn(() -> Strings.format((String)"%s, [%s], closing connection", (Object[])new Object[]{e.getMessage(), channel}));
            } else if (e instanceof TransportNotReadyException) {
                logger.debug(() -> Strings.format((String)"%s on [%s], closing connection", (Object[])new Object[]{e.getMessage(), channel}));
            } else if (e instanceof HeaderValidationException) {
                HeaderValidationException headerValidationException = (HeaderValidationException)e;
                Header header = headerValidationException.header;
                if (channel.isOpen()) {
                    outboundHandler.sendErrorResponse(header.getVersion(), channel, header.getRequestId(), header.getActionName(), ResponseStatsConsumer.NONE, headerValidationException.validationException);
                }
            } else {
                logger.warn(() -> "exception caught on transport layer [" + String.valueOf(channel) + "], closing connection", (Throwable)e);
            }
        }
        finally {
            if (closeChannel) {
                channel.setCloseException(e);
                CloseableChannel.closeChannel(channel);
            }
        }
    }

    protected static void onServerException(TcpServerChannel channel, Exception e) {
        if (e instanceof BindException) {
            logger.debug(() -> "bind exception from server channel caught on transport layer [" + String.valueOf(channel) + "]", (Throwable)e);
        } else {
            logger.error(() -> "exception from server channel caught on transport layer [" + String.valueOf(channel) + "]", (Throwable)e);
        }
    }

    protected void serverAcceptedChannel(TcpChannel channel) {
        boolean addedOnThisCall = this.acceptedChannels.add(channel);
        assert (addedOnThisCall) : "Channel should only be added to accepted channel set once";
        channel.getChannelStats().markAccessed(this.threadPool.relativeTimeInMillis());
        channel.addCloseListener(ActionListener.running(() -> this.acceptedChannels.remove(channel)));
        logger.trace(() -> Strings.format((String)"Tcp transport channel accepted: %s", (Object[])new Object[]{channel}));
    }

    protected abstract TcpServerChannel bind(String var1, InetSocketAddress var2) throws IOException;

    protected abstract TcpChannel initiateChannel(DiscoveryNode var1, ConnectionProfile var2) throws IOException;

    protected abstract void stopInternal();

    public void inboundMessage(TcpChannel channel, InboundMessage message) {
        try {
            this.inboundHandler.inboundMessage(channel, message);
        }
        catch (Exception e) {
            this.onException(channel, e);
        }
    }

    public static int readMessageLength(BytesReference networkBytes) throws IOException {
        if (networkBytes.length() < 6) {
            return -1;
        }
        return TcpTransport.readHeaderBuffer(networkBytes);
    }

    private static int readHeaderBuffer(BytesReference headerBuffer) throws IOException {
        if (headerBuffer.get(0) != 69 || headerBuffer.get(1) != 83) {
            if (TcpTransport.appearsToBeHTTPRequest(headerBuffer)) {
                throw new HttpRequestOnTransportException("This is not an HTTP port");
            }
            if (TcpTransport.appearsToBeHTTPResponse(headerBuffer)) {
                throw new StreamCorruptedException("received HTTP response on transport port, ensure that transport port (not HTTP port) of a remote node is specified in the configuration");
            }
            String firstBytes = "(" + Integer.toHexString(headerBuffer.get(0) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(1) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(2) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(3) & 0xFF) + ")";
            if (TcpTransport.appearsToBeTLS(headerBuffer)) {
                throw new StreamCorruptedException("SSL/TLS request received but SSL/TLS is not enabled on this node, got " + firstBytes);
            }
            throw new StreamCorruptedException("invalid internal transport message format, got " + firstBytes);
        }
        int messageLength = headerBuffer.getInt(2);
        if (messageLength == -1) {
            return 0;
        }
        if (messageLength <= 0) {
            throw new StreamCorruptedException("invalid data length: " + messageLength);
        }
        if ((long)messageLength > THIRTY_PER_HEAP_SIZE) {
            throw new IllegalArgumentException("illegal transport message of size [" + String.valueOf(ByteSizeValue.ofBytes(messageLength)) + "] which exceeds 30% of this node's heap size [" + String.valueOf(ByteSizeValue.ofBytes(THIRTY_PER_HEAP_SIZE)) + "], closing connection");
        }
        return messageLength;
    }

    private static boolean appearsToBeHTTPRequest(BytesReference headerBuffer) {
        return TcpTransport.bufferStartsWith(headerBuffer, "GET") || TcpTransport.bufferStartsWith(headerBuffer, "POST") || TcpTransport.bufferStartsWith(headerBuffer, "PUT") || TcpTransport.bufferStartsWith(headerBuffer, "HEAD") || TcpTransport.bufferStartsWith(headerBuffer, "DELETE") || TcpTransport.bufferStartsWith(headerBuffer, "OPTION") || TcpTransport.bufferStartsWith(headerBuffer, "PATCH") || TcpTransport.bufferStartsWith(headerBuffer, "TRACE");
    }

    private static boolean appearsToBeHTTPResponse(BytesReference headerBuffer) {
        return TcpTransport.bufferStartsWith(headerBuffer, "HTTP");
    }

    private static boolean appearsToBeTLS(BytesReference headerBuffer) {
        return headerBuffer.get(0) == 22 && headerBuffer.get(1) == 3;
    }

    private static boolean bufferStartsWith(BytesReference buffer, String method) {
        char[] chars = method.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (buffer.get(i) == chars[i]) continue;
            return false;
        }
        return true;
    }

    public void executeHandshake(DiscoveryNode node, TcpChannel channel, ConnectionProfile profile, ActionListener<TransportVersion> listener) {
        long requestId = this.responseHandlers.newRequestId();
        this.handshaker.sendHandshake(requestId, node, channel, profile.getHandshakeTimeout(), listener);
    }

    final TransportKeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    final int getNumPendingHandshakes() {
        return this.handshaker.getNumPendingHandshakes();
    }

    final long getNumHandshakes() {
        return this.handshaker.getNumHandshakes();
    }

    final Set<TcpChannel> getAcceptedChannels() {
        return Collections.unmodifiableSet(this.acceptedChannels);
    }

    @Override
    public RecyclerBytesStreamOutput newNetworkBytesStream() {
        return new RecyclerBytesStreamOutput(this.recycler);
    }

    private void ensureOpen() {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("transport has been stopped");
        }
    }

    @Override
    public final TransportStats getStats() {
        long bytesWritten = this.statsTracker.getBytesWritten();
        long messagesSent = this.statsTracker.getMessagesSent();
        long messagesReceived = this.statsTracker.getMessagesReceived();
        long bytesRead = this.statsTracker.getBytesRead();
        return new TransportStats(this.acceptedChannels.size(), this.outboundConnectionCount.get(), messagesReceived, bytesRead, messagesSent, bytesWritten, this.networkService.getHandlingTimeTracker().getHistogram(), this.outboundHandlingTimeTracker.getHistogram(), this.requestHandlers.getStats());
    }

    public static Set<ProfileSettings> getProfileSettings(Settings settings) {
        HashSet<ProfileSettings> profiles = new HashSet<ProfileSettings>();
        if (RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(settings).booleanValue()) {
            profiles.add(RemoteClusterPortSettings.buildRemoteAccessProfileSettings(settings));
        }
        boolean isDefaultSet = false;
        for (String profile : settings.getGroups("transport.profiles.", true).keySet()) {
            profiles.add(new ProfileSettings(settings, profile));
            if (!"default".equals(profile)) continue;
            isDefaultSet = true;
        }
        if (!isDefaultSet) {
            profiles.add(new ProfileSettings(settings, "default"));
        }
        return Collections.unmodifiableSet(profiles);
    }

    @Override
    public final Transport.ResponseHandlers getResponseHandlers() {
        return this.responseHandlers;
    }

    @Override
    public final Transport.RequestHandlers getRequestHandlers() {
        return this.requestHandlers;
    }

    private static final class ChannelOpenTraceLogger
    implements ActionListener<Void> {
        private final TcpChannel channel;

        ChannelOpenTraceLogger(TcpChannel channel) {
            this.channel = channel;
        }

        @Override
        public void onResponse(Void unused) {
            logger.trace("Tcp transport channel opened: {}", (Object)this.channel);
        }

        @Override
        public void onFailure(Exception e) {
            logger.trace(() -> Strings.format((String)"failed to open transport channel: %s", (Object[])new Object[]{this.channel}), (Throwable)e);
        }
    }

    private final class ChannelsConnectedListener
    implements ActionListener<Void> {
        private final DiscoveryNode node;
        private final ConnectionProfile connectionProfile;
        private final List<TcpChannel> channels;
        private final ActionListener<Transport.Connection> listener;
        private final CountDown countDown;

        private ChannelsConnectedListener(DiscoveryNode node, ConnectionProfile connectionProfile, List<TcpChannel> channels, ActionListener<Transport.Connection> listener) {
            this.node = node;
            this.connectionProfile = connectionProfile;
            this.channels = channels;
            this.listener = listener;
            this.countDown = new CountDown(channels.size());
        }

        @Override
        public void onResponse(Void v) {
            if (this.countDown.countDown()) {
                TcpChannel handshakeChannel = this.channels.get(0);
                try {
                    TcpTransport.this.executeHandshake(this.node, handshakeChannel, this.connectionProfile, ActionListener.wrap(responseVersion -> {
                        long connectionId = TcpTransport.this.outboundConnectionCount.incrementAndGet();
                        logger.debug("opened transport connection [{}] to [{}] using channels [{}]", (Object)connectionId, (Object)this.node, this.channels);
                        final NodeChannels nodeChannels = new NodeChannels(this.node, this.channels, this.connectionProfile, (TransportVersion)responseVersion);
                        long relativeMillisTime = TcpTransport.this.threadPool.relativeTimeInMillis();
                        nodeChannels.channels.forEach(ch -> {
                            ch.getChannelStats().markAccessed(relativeMillisTime);
                            ch.addCloseListener(new ActionListener<Void>(){

                                @Override
                                public void onResponse(Void ignored) {
                                    nodeChannels.close();
                                }

                                @Override
                                public void onFailure(Exception e) {
                                    nodeChannels.closeAndFail(new NodeDisconnectedException(ChannelsConnectedListener.this.node, "closed exceptionally: " + String.valueOf(ch), null, e));
                                }
                            });
                        });
                        TcpTransport.this.keepAlive.registerNodeConnection(nodeChannels.channels, this.connectionProfile);
                        nodeChannels.addCloseListener(new ChannelCloseLogger(this.node, connectionId, relativeMillisTime));
                        this.listener.onResponse(nodeChannels);
                    }, e -> this.closeAndFail(e instanceof ConnectTransportException ? e : new ConnectTransportException(this.node, "general node connection failure", (Throwable)e))));
                }
                catch (Exception ex) {
                    this.closeAndFail(ex);
                }
            }
        }

        @Override
        public void onFailure(Exception ex) {
            if (this.countDown.fastForward()) {
                this.closeAndFail(new ConnectTransportException(this.node, "connect_exception", ex));
            }
        }

        public void onTimeout() {
            if (this.countDown.fastForward()) {
                this.closeAndFail(new ConnectTransportException(this.node, "connect_timeout[" + String.valueOf(this.connectionProfile.getConnectTimeout()) + "]"));
            }
        }

        private void closeAndFail(Exception e) {
            try {
                CloseableChannel.closeChannels(this.channels, false);
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            finally {
                this.listener.onFailure(e);
            }
        }
    }

    public static final class ProfileSettings {
        public final String profileName;
        public final boolean tcpNoDelay;
        public final boolean tcpKeepAlive;
        public final int tcpKeepIdle;
        public final int tcpKeepInterval;
        public final int tcpKeepCount;
        public final boolean reuseAddress;
        public final ByteSizeValue sendBufferSize;
        public final ByteSizeValue receiveBufferSize;
        public final List<String> bindHosts;
        public final List<String> publishHosts;
        public final String portOrRange;
        public final int publishPort;
        public final boolean isDefaultProfile;

        public ProfileSettings(Settings settings, String profileName) {
            this.profileName = profileName;
            this.isDefaultProfile = "default".equals(profileName);
            this.tcpKeepAlive = TransportSettings.TCP_KEEP_ALIVE_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.tcpKeepIdle = TransportSettings.TCP_KEEP_IDLE_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.tcpKeepInterval = TransportSettings.TCP_KEEP_INTERVAL_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.tcpKeepCount = TransportSettings.TCP_KEEP_COUNT_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.tcpNoDelay = TransportSettings.TCP_NO_DELAY_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.reuseAddress = TransportSettings.TCP_REUSE_ADDRESS_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.sendBufferSize = TransportSettings.TCP_SEND_BUFFER_SIZE_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.receiveBufferSize = TransportSettings.TCP_RECEIVE_BUFFER_SIZE_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            List<String> profileBindHosts = TransportSettings.BIND_HOST_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.bindHosts = profileBindHosts.isEmpty() ? NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : profileBindHosts;
            this.publishHosts = TransportSettings.PUBLISH_HOST_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            Setting<String> concretePort = TransportSettings.PORT_PROFILE.getConcreteSettingForNamespace(profileName);
            if (!concretePort.exists(settings) && !this.isDefaultProfile) {
                throw new IllegalStateException("profile [" + profileName + "] has no port configured");
            }
            this.portOrRange = TransportSettings.PORT_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
            this.publishPort = this.isDefaultProfile ? TransportSettings.PUBLISH_PORT.get(settings) : TransportSettings.PUBLISH_PORT_PROFILE.getConcreteSettingForNamespace(profileName).get(settings);
        }
    }

    public static class HttpRequestOnTransportException
    extends ElasticsearchException {
        HttpRequestOnTransportException(String msg) {
            super(msg, new Object[0]);
        }

        @Override
        public RestStatus status() {
            return RestStatus.BAD_REQUEST;
        }

        public HttpRequestOnTransportException(StreamInput in) throws IOException {
            super(in);
        }
    }

    private class ChannelCloseLogger
    implements ActionListener<Void> {
        private final DiscoveryNode node;
        private final long connectionId;
        private final long openTimeMillis;

        ChannelCloseLogger(DiscoveryNode node, long connectionId, long openTimeMillis) {
            this.node = node;
            this.connectionId = connectionId;
            this.openTimeMillis = openTimeMillis;
        }

        @Override
        public void onResponse(Void ignored) {
            long closeTimeMillis = TcpTransport.this.threadPool.relativeTimeInMillis();
            logger.debug("closed transport connection [{}] to [{}] with age [{}ms]", (Object)this.connectionId, (Object)this.node, (Object)(closeTimeMillis - this.openTimeMillis));
        }

        @Override
        public void onFailure(Exception e) {
            long closeTimeMillis = TcpTransport.this.threadPool.relativeTimeInMillis();
            logger.debug(() -> Strings.format((String)"closed transport connection [%d] to [%s] with age [%dms], exception:", (Object[])new Object[]{this.connectionId, this.node, closeTimeMillis - this.openTimeMillis}), (Throwable)e);
        }
    }

    public final class NodeChannels
    extends CloseableConnection {
        private final Map<TransportRequestOptions.Type, ConnectionProfile.ConnectionTypeHandle> typeMapping;
        private final List<TcpChannel> channels;
        private final DiscoveryNode node;
        private final TransportVersion version;
        private final Compression.Enabled compress;
        private final Compression.Scheme compressionScheme;
        private final AtomicBoolean isClosing = new AtomicBoolean(false);

        NodeChannels(DiscoveryNode node, List<TcpChannel> channels, ConnectionProfile connectionProfile, TransportVersion handshakeVersion) {
            this.node = node;
            this.channels = Collections.unmodifiableList(channels);
            assert (channels.size() == connectionProfile.getNumConnections()) : "expected channels size to be == " + connectionProfile.getNumConnections() + " but was: [" + channels.size() + "]";
            this.typeMapping = new EnumMap<TransportRequestOptions.Type, ConnectionProfile.ConnectionTypeHandle>(TransportRequestOptions.Type.class);
            for (ConnectionProfile.ConnectionTypeHandle handle : connectionProfile.getHandles()) {
                for (TransportRequestOptions.Type type : handle.getTypes()) {
                    this.typeMapping.put(type, handle);
                }
            }
            this.version = handshakeVersion;
            this.compress = connectionProfile.getCompressionEnabled();
            this.compressionScheme = connectionProfile.getCompressionScheme();
        }

        @Override
        public TransportVersion getTransportVersion() {
            return this.version;
        }

        public List<TcpChannel> getChannels() {
            return this.channels;
        }

        public TcpChannel channel(TransportRequestOptions.Type type) {
            ConnectionProfile.ConnectionTypeHandle connectionTypeHandle = this.typeMapping.get((Object)type);
            if (connectionTypeHandle == null) {
                throw new IllegalArgumentException("no type channel for [" + String.valueOf((Object)type) + "]");
            }
            return connectionTypeHandle.getChannel(this.channels);
        }

        @Override
        public void close() {
            this.handleClose(null);
        }

        @Override
        public void closeAndFail(Exception e) {
            this.handleClose(e);
        }

        private void handleClose(Exception e) {
            if (this.isClosing.compareAndSet(false, true)) {
                try {
                    boolean block = TcpTransport.this.lifecycle.stopped() && !Transports.isTransportThread(Thread.currentThread());
                    CloseableChannel.closeChannels(this.channels, block);
                }
                finally {
                    if (e == null) {
                        super.close();
                    } else {
                        super.closeAndFail(e);
                    }
                }
            }
        }

        @Override
        public DiscoveryNode getNode() {
            return this.node;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            if (this.isClosing.get()) {
                throw new NodeNotConnectedException(this.node, "connection already closed");
            }
            TcpChannel channel = this.channel(options.type());
            TransportRequest wrapped = request instanceof TransportActionProxy.ProxyRequest ? ((TransportActionProxy.ProxyRequest)request).wrapped : request;
            Compression.Scheme schemeToUse = this.getCompressionScheme(wrapped);
            assert (!"cluster:internal/remote_cluster/handshake".equals(action) || "_remote_cluster".equals(channel.getProfile())) : "remote cluster handshake can only be sent through RCS remote cluster connection";
            TcpTransport.this.outboundHandler.sendRequest(this.node, channel, requestId, action, request, options, this.getTransportVersion(), schemeToUse, false);
        }

        private Compression.Scheme getCompressionScheme(TransportRequest request) {
            boolean shouldCompress = this.compress == Compression.Enabled.TRUE || this.compress == Compression.Enabled.INDEXING_DATA && request instanceof RawIndexingDataTransportRequest && ((RawIndexingDataTransportRequest)((Object)request)).isRawIndexingData();
            return shouldCompress ? this.compressionScheme : null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("NodeChannels[");
            this.node.appendDescriptionWithoutAttributes(stringBuilder);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

