/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SearchSortValues
implements ToXContentFragment,
Writeable {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    static final SearchSortValues EMPTY = new SearchSortValues(EMPTY_ARRAY);
    private final Object[] formattedSortValues;
    private final Object[] rawSortValues;

    SearchSortValues(Object[] sortValues) {
        this(Objects.requireNonNull(sortValues, "sort values must not be empty"), EMPTY_ARRAY);
    }

    public SearchSortValues(Object[] rawSortValues, DocValueFormat[] sortValueFormats) {
        Objects.requireNonNull(rawSortValues);
        Objects.requireNonNull(sortValueFormats);
        if (rawSortValues.length != sortValueFormats.length) {
            throw new IllegalArgumentException("formattedSortValues and sortValueFormats must hold the same number of items");
        }
        this.rawSortValues = rawSortValues;
        this.formattedSortValues = new Object[rawSortValues.length];
        for (int i = 0; i < rawSortValues.length; ++i) {
            Object v = sortValueFormats[i].formatSortValue(rawSortValues[i]);
            assert (v == null || v instanceof String || v instanceof Number || v instanceof Boolean || v instanceof Map) : String.valueOf(v) + " was not formatted";
            this.formattedSortValues[i] = v;
        }
    }

    public static SearchSortValues readFrom(StreamInput in) throws IOException {
        Object[] formattedSortValues = Lucene.readSortValues(in);
        Object[] rawSortValues = Lucene.readSortValues(in);
        if (formattedSortValues.length == 0 && rawSortValues.length == 0) {
            return EMPTY;
        }
        return new SearchSortValues(formattedSortValues, rawSortValues);
    }

    private SearchSortValues(Object[] formattedSortValues, Object[] rawSortValues) {
        this.formattedSortValues = formattedSortValues;
        this.rawSortValues = rawSortValues;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(Lucene::writeSortValue, this.formattedSortValues);
        out.writeArray(Lucene::writeSortValue, this.rawSortValues);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.formattedSortValues.length > 0) {
            builder.startArray("sort");
            for (Object sortValue : this.formattedSortValues) {
                builder.value(sortValue);
            }
            builder.endArray();
        }
        return builder;
    }

    public static SearchSortValues fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
        return new SearchSortValues(parser.list().toArray());
    }

    public Object[] getFormattedSortValues() {
        return this.formattedSortValues;
    }

    public Object[] getRawSortValues() {
        return this.rawSortValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchSortValues that = (SearchSortValues)o;
        return Arrays.equals(this.formattedSortValues, that.formattedSortValues) && Arrays.equals(this.rawSortValues, that.rawSortValues);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.formattedSortValues);
        result = 31 * result + Arrays.hashCode(this.rawSortValues);
        return result;
    }
}

