/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.ImmutableDirectoryException;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.snapshots.SnapshotId;

public abstract class FileRestoreContext {
    protected static final Logger logger = LogManager.getLogger(FileRestoreContext.class);
    protected final String repositoryName;
    protected final RecoveryState recoveryState;
    protected final SnapshotId snapshotId;
    protected final ShardId shardId;

    protected FileRestoreContext(String repositoryName, ShardId shardId, SnapshotId snapshotId, RecoveryState recoveryState) {
        this.repositoryName = repositoryName;
        this.recoveryState = recoveryState;
        this.snapshotId = snapshotId;
        this.shardId = shardId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(SnapshotFiles snapshotFiles, Store store, ActionListener<Void> listener) {
        store.incRef();
        try {
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
            if (store.indexSettings().getIndexMetadata().isSearchableSnapshot()) {
                for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshotFiles.indexFiles()) {
                    assert (store.directory().fileLength(fileInfo.physicalName()) == fileInfo.length());
                    this.recoveryState.getIndex().addFileDetail(fileInfo.physicalName(), fileInfo.length(), true);
                }
            } else {
                BlobStoreIndexShardSnapshot.FileInfo fileInfo;
                Store.MetadataSnapshot recoveryTargetMetadata;
                logger.debug("[{}] [{}] restoring to [{}] ...", (Object)this.snapshotId, (Object)this.repositoryName, (Object)this.shardId);
                try {
                    recoveryTargetMetadata = store.getMetadata(null, true);
                }
                catch (IndexNotFoundException e) {
                    logger.trace("[{}] [{}] restoring from to an empty shard", (Object)this.shardId, (Object)this.snapshotId);
                    recoveryTargetMetadata = Store.MetadataSnapshot.EMPTY;
                }
                catch (IOException e) {
                    logger.warn(() -> Strings.format((String)"[%s] [%s] Can't read metadata from store, will not reuse local files during restore", (Object[])new Object[]{this.shardId, this.snapshotId}), (Throwable)e);
                    recoveryTargetMetadata = Store.MetadataSnapshot.EMPTY;
                }
                HashMap<String, StoreFileMetadata> snapshotMetadata = new HashMap<String, StoreFileMetadata>();
                HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> fileInfos = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
                for (BlobStoreIndexShardSnapshot.FileInfo fileInfo2 : snapshotFiles.indexFiles()) {
                    snapshotMetadata.put(fileInfo2.metadata().name(), fileInfo2.metadata());
                    fileInfos.put(fileInfo2.metadata().name(), fileInfo2);
                }
                Store.MetadataSnapshot sourceMetadata = new Store.MetadataSnapshot(Collections.unmodifiableMap(snapshotMetadata), Collections.emptyMap(), 0L);
                StoreFileMetadata restoredSegmentsFile = sourceMetadata.getSegmentsFile();
                if (restoredSegmentsFile == null) {
                    throw new IndexShardRestoreFailedException(this.shardId, "Snapshot has no segments file");
                }
                Store.RecoveryDiff diff = sourceMetadata.recoveryDiff(recoveryTargetMetadata);
                for (StoreFileMetadata md : diff.identical) {
                    fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)fileInfos.get(md.name());
                    this.recoveryState.getIndex().addFileDetail(fileInfo.physicalName(), fileInfo.length(), true);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("[{}] [{}] not_recovering file [{}] from [{}], exists in local store and is same", (Object)this.shardId, (Object)this.snapshotId, (Object)fileInfo.physicalName(), (Object)fileInfo.name());
                }
                for (StoreFileMetadata md : FileRestoreContext.concat(diff)) {
                    fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)fileInfos.get(md.name());
                    filesToRecover.add(fileInfo);
                    this.recoveryState.getIndex().addFileDetail(fileInfo.physicalName(), fileInfo.length(), false);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("[{}] [{}] recovering [{}] from [{}]", (Object)this.shardId, (Object)this.snapshotId, (Object)fileInfo.physicalName(), (Object)fileInfo.name());
                }
            }
            this.recoveryState.getIndex().setFileDetailsComplete();
            if (filesToRecover.isEmpty()) {
                logger.trace("[{}] [{}] no files to recover, all exist within the local store", (Object)this.shardId, (Object)this.snapshotId);
            }
            try {
                List<String> deleteIfExistFiles = Arrays.asList(store.directory().listAll());
                for (BlobStoreIndexShardSnapshot.FileInfo fileToRecover : filesToRecover) {
                    String physicalName = fileToRecover.physicalName();
                    if (!deleteIfExistFiles.contains(physicalName)) continue;
                    logger.trace("[{}] [{}] deleting pre-existing file [{}]", (Object)this.shardId, (Object)this.snapshotId, (Object)physicalName);
                    store.directory().deleteFile(physicalName);
                }
                this.restoreFiles(filesToRecover, store, listener.delegateFailureAndWrap((l, v) -> {
                    store.incRef();
                    try {
                        this.afterRestore(snapshotFiles, store);
                        l.onResponse(null);
                    }
                    finally {
                        store.decRef();
                    }
                }));
            }
            catch (IOException ex) {
                throw new IndexShardRestoreFailedException(this.shardId, "Failed to recover index", ex);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
        finally {
            store.decRef();
        }
    }

    private void afterRestore(SnapshotFiles snapshotFiles, Store store) {
        try {
            for (String storeFile : store.directory().listAll()) {
                if (Store.isAutogenerated(storeFile) || snapshotFiles.containPhysicalIndexFile(storeFile)) continue;
                try {
                    store.directory().deleteFile(storeFile);
                }
                catch (ImmutableDirectoryException e) {
                    assert (snapshotFiles.indexFiles().size() <= 1) : snapshotFiles;
                }
                catch (IOException e) {
                    logger.warn("[{}] [{}] failed to delete file [{}] during snapshot cleanup", (Object)this.shardId, (Object)this.snapshotId, (Object)storeFile);
                }
            }
        }
        catch (IOException e) {
            logger.warn("[{}] [{}] failed to list directory - some of files might not be deleted", (Object)this.shardId, (Object)this.snapshotId);
        }
    }

    protected abstract void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> var1, Store var2, ActionListener<Void> var3);

    private static Iterable<StoreFileMetadata> concat(Store.RecoveryDiff diff) {
        return CollectionUtils.concatLists(diff.different, diff.missing);
    }
}

