/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class InferenceServiceConfiguration
implements Writeable,
ToXContentObject {
    private final String service;
    private final String name;
    private final EnumSet<TaskType> taskTypes;
    private final Map<String, SettingsConfiguration> configurations;
    static final ParseField SERVICE_FIELD = new ParseField("service", new String[0]);
    static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    static final ParseField TASK_TYPES_FIELD = new ParseField("task_types", new String[0]);
    static final ParseField CONFIGURATIONS_FIELD = new ParseField("configurations", new String[0]);
    private static final ConstructingObjectParser<InferenceServiceConfiguration, Void> PARSER = new ConstructingObjectParser("inference_service_configuration", true, args -> new Builder().setService((String)args[0]).setName((String)args[1]).setTaskTypes((List)args[2]).setConfigurations((Map)args[3]).build());

    private InferenceServiceConfiguration(String service, String name, EnumSet<TaskType> taskTypes, Map<String, SettingsConfiguration> configurations) {
        this.service = service;
        this.name = name;
        this.taskTypes = taskTypes;
        this.configurations = configurations;
    }

    public InferenceServiceConfiguration(StreamInput in) throws IOException {
        this.service = in.readString();
        this.name = in.readString();
        this.taskTypes = in.readEnumSet(TaskType.class);
        this.configurations = in.readMap(SettingsConfiguration::new);
    }

    public String getService() {
        return this.service;
    }

    public String getName() {
        return this.name;
    }

    public EnumSet<TaskType> getTaskTypes() {
        return this.taskTypes;
    }

    public Map<String, SettingsConfiguration> getConfigurations() {
        return this.configurations;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SERVICE_FIELD.getPreferredName(), this.service);
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.field(TASK_TYPES_FIELD.getPreferredName(), this.taskTypes);
        builder.field(CONFIGURATIONS_FIELD.getPreferredName(), this.configurations);
        builder.endObject();
        return builder;
    }

    public static InferenceServiceConfiguration fromXContent(XContentParser parser) throws IOException {
        return (InferenceServiceConfiguration)PARSER.parse(parser, null);
    }

    public static InferenceServiceConfiguration fromXContentBytes(BytesReference source, XContentType xContentType) {
        InferenceServiceConfiguration inferenceServiceConfiguration;
        block8: {
            XContentParser parser = XContentHelper.createParser(XContentParserConfiguration.EMPTY, source, xContentType);
            try {
                inferenceServiceConfiguration = InferenceServiceConfiguration.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse inference service configuration", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return inferenceServiceConfiguration;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.service);
        out.writeString(this.name);
        out.writeCollection(this.taskTypes);
        out.writeMapValues(this.configurations);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SERVICE_FIELD.getPreferredName(), this.service);
        map.put(NAME_FIELD.getPreferredName(), this.name);
        map.put(TASK_TYPES_FIELD.getPreferredName(), this.taskTypes);
        map.put(CONFIGURATIONS_FIELD.getPreferredName(), this.configurations);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceServiceConfiguration that = (InferenceServiceConfiguration)o;
        return this.service.equals(that.service) && this.name.equals(that.name) && Objects.equals(this.taskTypes, that.taskTypes) && Objects.equals(this.configurations, that.configurations);
    }

    public int hashCode() {
        return Objects.hash(this.service, this.name, this.taskTypes, this.configurations);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SERVICE_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), TASK_TYPES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), CONFIGURATIONS_FIELD);
    }

    public static class Builder {
        private String service;
        private String name;
        private EnumSet<TaskType> taskTypes;
        private Map<String, SettingsConfiguration> configurations;

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTaskTypes(EnumSet<TaskType> taskTypes) {
            this.taskTypes = TaskType.copyOf(taskTypes);
            return this;
        }

        public Builder setTaskTypes(List<String> taskTypes) {
            EnumSet<TaskType> enumTaskTypes = EnumSet.noneOf(TaskType.class);
            for (String supportedTaskTypeString : taskTypes) {
                enumTaskTypes.add(TaskType.fromStringOrStatusException(supportedTaskTypeString));
            }
            this.taskTypes = enumTaskTypes;
            return this;
        }

        public Builder setConfigurations(Map<String, SettingsConfiguration> configurations) {
            this.configurations = configurations;
            return this;
        }

        public InferenceServiceConfiguration build() {
            return new InferenceServiceConfiguration(this.service, this.name, this.taskTypes, this.configurations);
        }
    }
}

