/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.lucene.spatial.Extent;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;

public abstract class AbstractShapeGeometryFieldMapper<T>
extends AbstractGeometryFieldMapper<T> {
    private static final Explicit<Orientation> IMPLICIT_RIGHT = new Explicit<Orientation>(Orientation.RIGHT, false);
    protected Explicit<Boolean> coerce;
    protected Explicit<Orientation> orientation;

    @Override
    protected boolean supportsParsingObject() {
        return false;
    }

    public static FieldMapper.Parameter<Explicit<Boolean>> coerceParam(Function<FieldMapper, Explicit<Boolean>> initializer, boolean coerceByDefault) {
        return FieldMapper.Parameter.explicitBoolParam("coerce", true, initializer, coerceByDefault);
    }

    public static FieldMapper.Parameter<Explicit<Orientation>> orientationParam(Function<FieldMapper, Explicit<Orientation>> initializer) {
        return new FieldMapper.Parameter<Explicit<Orientation>>("orientation", true, () -> IMPLICIT_RIGHT, (n, c, o) -> new Explicit<Orientation>(Orientation.fromString(o.toString()), true), initializer, (b, f, v) -> b.field(f, (Enum)v.value()), v -> ((Orientation)((Object)((Object)v.value()))).toString());
    }

    protected AbstractShapeGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<Orientation> orientation, AbstractGeometryFieldMapper.Parser<T> parser) {
        super(simpleName, mappedFieldType, builderParams, ignoreMalformed, ignoreZValue, parser);
        this.coerce = coerce;
        this.orientation = orientation;
    }

    public boolean coerce() {
        return this.coerce.value();
    }

    public Orientation orientation() {
        return this.orientation.value();
    }

    public static abstract class AbstractShapeGeometryFieldType<T>
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType<T> {
        private final Orientation orientation;

        protected AbstractShapeGeometryFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, AbstractGeometryFieldMapper.Parser<T> parser, Orientation orientation, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, parser, null, meta);
            this.orientation = orientation;
        }

        public Orientation orientation() {
            return this.orientation;
        }

        @Override
        protected Object nullValueAsSource(T nullValue) {
            return nullValue;
        }

        protected static class BoundsBlockLoader
        extends BlockDocValuesReader.DocValuesBlockLoader {
            private final String fieldName;

            protected BoundsBlockLoader(String fieldName) {
                this.fieldName = fieldName;
            }

            protected void writeExtent(BlockLoader.IntBuilder builder, Extent extent) {
                builder.beginPositionEntry();
                builder.appendInt(extent.top);
                builder.appendInt(extent.bottom);
                builder.appendInt(extent.negLeft);
                builder.appendInt(extent.negRight);
                builder.appendInt(extent.posLeft);
                builder.appendInt(extent.posRight);
                builder.endPositionEntry();
            }

            @Override
            public BlockLoader.AllReader reader(final LeafReaderContext context) throws IOException {
                return new BlockLoader.AllReader(){

                    @Override
                    public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
                        BinaryDocValues binaryDocValues = context.reader().getBinaryDocValues(fieldName);
                        GeometryDocValueReader reader = new GeometryDocValueReader();
                        try (BlockLoader.IntBuilder builder = factory.ints(docs.count() - offset);){
                            for (int i = offset; i < docs.count(); ++i) {
                                this.read(binaryDocValues, docs.get(i), reader, builder);
                            }
                            BlockLoader.Block block = builder.build();
                            return block;
                        }
                    }

                    @Override
                    public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
                        BinaryDocValues binaryDocValues = context.reader().getBinaryDocValues(fieldName);
                        GeometryDocValueReader reader = new GeometryDocValueReader();
                        this.read(binaryDocValues, docId, reader, (BlockLoader.IntBuilder)builder);
                    }

                    private void read(BinaryDocValues binaryDocValues, int doc, GeometryDocValueReader reader, BlockLoader.IntBuilder builder) throws IOException {
                        if (!binaryDocValues.advanceExact(doc)) {
                            builder.appendNull();
                            return;
                        }
                        reader.reset(binaryDocValues.binaryValue());
                        this.writeExtent(builder, reader.getExtent());
                    }

                    @Override
                    public boolean canReuse(int startingDocID) {
                        return true;
                    }
                };
            }

            @Override
            public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                return factory.ints(expectedCount);
            }
        }
    }
}

