/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.cluster.routing.ShardRouting;

public record ShardAssignment(Set<String> nodeIds, int total, int unassigned, int ignored) {
    public ShardAssignment {
        assert (total > 0) : "Shard assignment should not be empty";
        assert (nodeIds.size() + unassigned == total) : "Shard assignment should account for all shards";
    }

    public int assigned() {
        return this.nodeIds.size();
    }

    public static ShardAssignment ofAssignedShards(List<ShardRouting> routings) {
        LinkedHashSet<String> nodeIds = new LinkedHashSet<String>();
        for (ShardRouting routing : routings) {
            nodeIds.add(routing.currentNodeId());
        }
        return new ShardAssignment(Collections.unmodifiableSet(nodeIds), routings.size(), 0, 0);
    }
}

