/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.features;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.features.NodeFeatures;
import org.elasticsearch.action.admin.cluster.node.features.NodesFeaturesRequest;
import org.elasticsearch.action.admin.cluster.node.features.NodesFeaturesResponse;
import org.elasticsearch.action.admin.cluster.node.features.TransportNodesFeaturesAction;
import org.elasticsearch.client.internal.ClusterAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterFeatures;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class NodeFeaturesFixupListener
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(NodeFeaturesFixupListener.class);
    private static final TimeValue RETRY_TIME = TimeValue.timeValueSeconds((long)30L);
    private final MasterServiceTaskQueue<NodesFeaturesTask> taskQueue;
    private final ClusterAdminClient client;
    private final Scheduler scheduler;
    private final Executor executor;
    private final Set<String> pendingNodes = Collections.synchronizedSet(new HashSet());

    public NodeFeaturesFixupListener(ClusterService service, ClusterAdminClient client, ThreadPool threadPool) {
        this(service.createTaskQueue("fix-node-features", Priority.LOW, new NodesFeaturesUpdater()), client, threadPool, threadPool.executor("cluster_coordination"));
    }

    NodeFeaturesFixupListener(MasterServiceTaskQueue<NodesFeaturesTask> taskQueue, ClusterAdminClient client, Scheduler scheduler, Executor executor) {
        this.taskQueue = taskQueue;
        this.client = client;
        this.scheduler = scheduler;
        this.executor = executor;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.nodesDelta().masterNodeChanged() && event.localNodeMaster()) {
            ClusterFeatures nodeFeatures = event.state().clusterFeatures();
            Set<String> queryNodes = event.state().nodes().stream().filter(n -> n.getVersion().onOrAfter(Version.V_8_15_0)).map(DiscoveryNode::getId).filter(n -> NodeFeaturesFixupListener.getNodeFeatures(nodeFeatures, n).isEmpty()).collect(Collectors.toSet());
            if (!queryNodes.isEmpty()) {
                logger.debug("Fetching actual node features for nodes {}", new Object[]{queryNodes});
                this.queryNodesFeatures(queryNodes, 0);
            }
        }
    }

    @SuppressForbidden(reason="Need to access a specific node's features")
    private static Set<String> getNodeFeatures(ClusterFeatures features, String nodeId) {
        return features.nodeFeatures().getOrDefault(nodeId, Set.of());
    }

    private void scheduleRetry(Set<String> nodes, int thisRetryNum) {
        logger.debug("Scheduling retry {} for nodes {}", new Object[]{thisRetryNum + 1, nodes});
        this.scheduler.schedule(() -> this.queryNodesFeatures(nodes, thisRetryNum + 1), RETRY_TIME, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryNodesFeatures(Set<String> nodes, final int retryNum) {
        final HashSet<String> outstandingNodes = Sets.newHashSetWithExpectedSize(nodes.size());
        Set<String> set = this.pendingNodes;
        synchronized (set) {
            for (String n : nodes) {
                if (!this.pendingNodes.add(n)) continue;
                outstandingNodes.add(n);
            }
        }
        if (outstandingNodes.isEmpty()) {
            return;
        }
        NodesFeaturesRequest request = new NodesFeaturesRequest((String[])outstandingNodes.toArray(String[]::new));
        this.client.execute(TransportNodesFeaturesAction.TYPE, request, new ActionListener<NodesFeaturesResponse>(){

            @Override
            public void onResponse(NodesFeaturesResponse response) {
                NodeFeaturesFixupListener.this.pendingNodes.removeAll(outstandingNodes);
                NodeFeaturesFixupListener.this.handleResponse(response, retryNum);
            }

            @Override
            public void onFailure(Exception e) {
                NodeFeaturesFixupListener.this.pendingNodes.removeAll(outstandingNodes);
                logger.warn("Could not read features for nodes {}", new Object[]{outstandingNodes, e});
                NodeFeaturesFixupListener.this.scheduleRetry(outstandingNodes, retryNum);
            }
        });
    }

    private void handleResponse(NodesFeaturesResponse response, int retryNum) {
        Map<String, Set<String>> results;
        if (response.hasFailures()) {
            HashSet<String> failedNodes = new HashSet<String>();
            for (FailedNodeException fne : response.failures()) {
                logger.warn("Failed to read features from node {}", new Object[]{fne.nodeId(), fne});
                failedNodes.add(fne.nodeId());
            }
            this.scheduleRetry(failedNodes, retryNum);
        }
        if (!(results = response.getNodes().stream().collect(Collectors.toUnmodifiableMap(n -> n.getNode().getId(), NodeFeatures::nodeFeatures))).isEmpty()) {
            this.taskQueue.submitTask("fix-node-features", new NodesFeaturesTask(results, retryNum), null);
        }
    }

    static class NodesFeaturesUpdater
    implements ClusterStateTaskExecutor<NodesFeaturesTask> {
        NodesFeaturesUpdater() {
        }

        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<NodesFeaturesTask> context) {
            ClusterState.Builder builder = ClusterState.builder(context.initialState());
            Map<String, Set<String>> existingFeatures = builder.nodeFeatures();
            boolean modified = false;
            for (ClusterStateTaskExecutor.TaskContext<NodesFeaturesTask> c : context.taskContexts()) {
                for (Map.Entry<String, Set<String>> e : c.getTask().results().entrySet()) {
                    if (!existingFeatures.getOrDefault(e.getKey(), Set.of()).isEmpty()) continue;
                    builder.putNodeFeatures(e.getKey(), e.getValue());
                    modified = true;
                }
                c.success(() -> {});
            }
            return modified ? builder.build() : context.initialState();
        }
    }

    class NodesFeaturesTask
    implements ClusterStateTaskListener {
        private final Map<String, Set<String>> results;
        private final int retryNum;

        NodesFeaturesTask(Map<String, Set<String>> results, int retryNum) {
            this.results = results;
            this.retryNum = retryNum;
        }

        @Override
        public void onFailure(Exception e) {
            logger.error("Could not apply features for nodes {} to cluster state", new Object[]{this.results.keySet(), e});
            NodeFeaturesFixupListener.this.scheduleRetry(this.results.keySet(), this.retryNum);
        }

        public Map<String, Set<String>> results() {
            return this.results;
        }
    }
}

