/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class UpdateDataStreamSettingsAction
extends ActionType<Response> {
    public static final String NAME = "indices:admin/data_stream/settings/update";
    public static final UpdateDataStreamSettingsAction INSTANCE = new UpdateDataStreamSettingsAction();
    private static final TransportVersion SETTINGS_IN_DATA_STREAMS = TransportVersion.fromName("settings_in_data_streams");

    public UpdateDataStreamSettingsAction() {
        super(NAME);
    }

    public record DataStreamSettingsResponse(String dataStreamName, boolean dataStreamSucceeded, String dataStreamErrorMessage, Settings settings, Settings effectiveSettings, IndicesSettingsResult indicesSettingsResult) implements ToXContent,
    Writeable
    {
        public DataStreamSettingsResponse(StreamInput in) throws IOException {
            this(in.readString(), in.readBoolean(), in.readOptionalString(), Settings.readSettingsFromStream(in), Settings.readSettingsFromStream(in), new IndicesSettingsResult(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.dataStreamName);
            out.writeBoolean(this.dataStreamSucceeded);
            out.writeOptionalString(this.dataStreamErrorMessage);
            this.settings.writeTo(out);
            this.effectiveSettings.writeTo(out);
            this.indicesSettingsResult.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.dataStreamName);
            builder.field("applied_to_data_stream", this.dataStreamSucceeded);
            if (this.dataStreamErrorMessage != null) {
                builder.field("error", this.dataStreamErrorMessage);
            }
            builder.startObject("settings");
            this.settings.toXContent(builder, params);
            builder.endObject();
            builder.startObject("effective_settings");
            this.effectiveSettings.toXContent(builder, params);
            builder.endObject();
            builder.startObject("index_settings_results");
            this.indicesSettingsResult.toXContent(builder, params);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public record IndicesSettingsResult(List<String> appliedToDataStreamOnly, List<String> appliedToDataStreamAndBackingIndices, List<IndexSettingError> indexSettingErrors) implements ToXContent,
        Writeable
        {
            public static final IndicesSettingsResult EMPTY = new IndicesSettingsResult(List.of(), List.of(), List.of());

            public IndicesSettingsResult(StreamInput in) throws IOException {
                this(in.readStringCollectionAsList(), in.readStringCollectionAsList(), in.readCollectionAsList(IndexSettingError::new));
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field("applied_to_data_stream_only", this.appliedToDataStreamOnly);
                builder.field("applied_to_data_stream_and_backing_indices", this.appliedToDataStreamAndBackingIndices);
                if (!this.indexSettingErrors.isEmpty()) {
                    builder.field("errors", this.indexSettingErrors);
                }
                return builder;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeStringCollection(this.appliedToDataStreamOnly);
                out.writeStringCollection(this.appliedToDataStreamAndBackingIndices);
                out.writeCollection(this.indexSettingErrors, (out1, value) -> value.writeTo(out1));
            }
        }

        public record IndexSettingError(String indexName, String errorMessage) implements ToXContent,
        Writeable
        {
            public IndexSettingError(StreamInput in) throws IOException {
                this(in.readString(), in.readString());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.indexName);
                out.writeString(this.errorMessage);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("index", this.indexName);
                builder.field("error", this.errorMessage);
                builder.endObject();
                return builder;
            }
        }
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        private final List<DataStreamSettingsResponse> dataStreamSettingsResponses;

        public Response(List<DataStreamSettingsResponse> dataStreamSettingsResponses) {
            this.dataStreamSettingsResponses = dataStreamSettingsResponses;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readCollectionAsList(DataStreamSettingsResponse::new));
        }

        public List<DataStreamSettingsResponse> getDataStreamSettingsResponses() {
            return this.dataStreamSettingsResponses;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.dataStreamSettingsResponses, (out1, value) -> value.writeTo(out1));
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat(Iterators.single((builder, params1) -> builder.startObject().startArray("data_streams")), this.dataStreamSettingsResponses.stream().map(dataStreamSettingsResponse -> dataStreamSettingsResponse).iterator(), Iterators.single((builder, params1) -> builder.endArray().endObject()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.dataStreamSettingsResponses, response.dataStreamSettingsResponses);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreamSettingsResponses);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest.Replaceable {
        private final Settings settings;
        private String[] dataStreamNames = Strings.EMPTY_ARRAY;
        private final boolean dryRun;

        public Request(Settings settings, TimeValue masterNodeTimeout, TimeValue ackTimeout) {
            this(settings, false, masterNodeTimeout, ackTimeout);
        }

        public Request(Settings settings, boolean dryRun, TimeValue masterNodeTimeout, TimeValue ackTimeout) {
            super(masterNodeTimeout, ackTimeout);
            this.settings = settings;
            this.dryRun = dryRun;
        }

        @Override
        public Request indices(String ... dataStreamNames) {
            this.dataStreamNames = dataStreamNames;
            return this;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public boolean isDryRun() {
            return this.dryRun;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.dataStreamNames = in.readStringArray();
            this.settings = Settings.readSettingsFromStream(in);
            this.dryRun = in.getTransportVersion().supports(SETTINGS_IN_DATA_STREAMS) ? in.readBoolean() : false;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.dataStreamNames);
            this.settings.writeTo(out);
            if (out.getTransportVersion().supports(SETTINGS_IN_DATA_STREAMS)) {
                out.writeBoolean(this.dryRun);
            }
        }

        @Override
        public String[] indices() {
            return this.dataStreamNames;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.dataStreamNames, request.dataStreamNames) && this.settings.equals(request.settings) && this.dryRun == request.dryRun && Objects.equals(this.masterNodeTimeout(), request.masterNodeTimeout()) && Objects.equals(this.ackTimeout(), request.ackTimeout());
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.dataStreamNames), this.settings, this.dryRun, this.masterNodeTimeout(), this.ackTimeout());
        }
    }
}

