/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.elasticsearch.core.TimeValue;

public abstract class BackoffPolicy
implements Iterable<TimeValue> {
    private static final BackoffPolicy NO_BACKOFF = new NoBackoff();

    public static BackoffPolicy noBackoff() {
        return NO_BACKOFF;
    }

    public static BackoffPolicy constantBackoff(TimeValue delay, int maxNumberOfRetries) {
        return new ConstantBackoff(BackoffPolicy.checkDelay(delay), maxNumberOfRetries);
    }

    public static BackoffPolicy exponentialBackoff() {
        return BackoffPolicy.exponentialBackoff(TimeValue.timeValueMillis((long)50L), 8);
    }

    public static BackoffPolicy exponentialBackoff(TimeValue initialDelay, int maxNumberOfRetries) {
        return new ExponentialBackoff((int)BackoffPolicy.checkDelay(initialDelay).millis(), maxNumberOfRetries);
    }

    public static BackoffPolicy wrap(BackoffPolicy delegate, Runnable onBackoff) {
        return new WrappedBackoffPolicy(delegate, onBackoff);
    }

    private static TimeValue checkDelay(TimeValue delay) {
        if (delay.millis() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("delay must be <= 2147483647 ms");
        }
        return delay;
    }

    private static final class ConstantBackoff
    extends BackoffPolicy {
        private final TimeValue delay;
        private final int numberOfElements;

        ConstantBackoff(TimeValue delay, int numberOfElements) {
            assert (numberOfElements >= 0);
            this.delay = delay;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public Iterator<TimeValue> iterator() {
            return new ConstantBackoffIterator(this.delay, this.numberOfElements);
        }
    }

    private static class ExponentialBackoff
    extends BackoffPolicy {
        private final int start;
        private final int numberOfElements;

        private ExponentialBackoff(int start, int numberOfElements) {
            assert (start >= 0);
            assert (numberOfElements >= 0);
            this.start = start;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public Iterator<TimeValue> iterator() {
            return new ExponentialBackoffIterator(this.start, this.numberOfElements);
        }
    }

    private static final class WrappedBackoffPolicy
    extends BackoffPolicy {
        private final BackoffPolicy delegate;
        private final Runnable onBackoff;

        WrappedBackoffPolicy(BackoffPolicy delegate, Runnable onBackoff) {
            this.delegate = delegate;
            this.onBackoff = onBackoff;
        }

        @Override
        public Iterator<TimeValue> iterator() {
            return new WrappedBackoffIterator(this.delegate.iterator(), this.onBackoff);
        }
    }

    private static class NoBackoff
    extends BackoffPolicy {
        private NoBackoff() {
        }

        @Override
        public Iterator<TimeValue> iterator() {
            return Collections.emptyIterator();
        }
    }

    private static final class WrappedBackoffIterator
    implements Iterator<TimeValue> {
        private final Iterator<TimeValue> delegate;
        private final Runnable onBackoff;

        WrappedBackoffIterator(Iterator<TimeValue> delegate, Runnable onBackoff) {
            this.delegate = delegate;
            this.onBackoff = onBackoff;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public TimeValue next() {
            if (!this.delegate.hasNext()) {
                throw new NoSuchElementException();
            }
            this.onBackoff.run();
            return this.delegate.next();
        }
    }

    private static final class ConstantBackoffIterator
    implements Iterator<TimeValue> {
        private final TimeValue delay;
        private final int numberOfElements;
        private int curr;

        ConstantBackoffIterator(TimeValue delay, int numberOfElements) {
            this.delay = delay;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.numberOfElements;
        }

        @Override
        public TimeValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.curr;
            return this.delay;
        }
    }

    private static class ExponentialBackoffIterator
    implements Iterator<TimeValue> {
        private final int numberOfElements;
        private final int start;
        private int currentlyConsumed;

        private ExponentialBackoffIterator(int start, int numberOfElements) {
            this.start = start;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public boolean hasNext() {
            return this.currentlyConsumed < this.numberOfElements;
        }

        @Override
        public TimeValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Only up to " + this.numberOfElements + " elements");
            }
            int result = this.start + 10 * ((int)Math.exp(0.8 * (double)this.currentlyConsumed) - 1);
            ++this.currentlyConsumed;
            return TimeValue.timeValueMillis((long)result);
        }
    }
}

