/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap.support;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;

public final class LdapMetadataResolverSettings {
    public static final Function<String, Setting.AffixSetting<List<String>>> ADDITIONAL_METADATA_SETTING = RealmSettings.affixSetting("metadata", key -> Setting.stringListSetting((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Function<String, Setting.AffixSetting<String>> FULL_NAME_SETTING = RealmSettings.affixSetting("user_full_name_attribute", key -> Setting.simpleString((String)key, (String)"cn", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Function<String, Setting.AffixSetting<String>> EMAIL_SETTING = RealmSettings.affixSetting("user_email_attribute", key -> Setting.simpleString((String)key, (String)"mail", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));

    private LdapMetadataResolverSettings() {
    }

    public static List<Setting.AffixSetting<?>> getSettings(String type) {
        return List.of(ADDITIONAL_METADATA_SETTING.apply(type), EMAIL_SETTING.apply(type), FULL_NAME_SETTING.apply(type));
    }
}

