/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;

public class CountAccumulator
implements Writeable {
    private Map<String, Long> counts;

    public CountAccumulator() {
        this.counts = new HashMap<String, Long>();
    }

    private CountAccumulator(Map<String, Long> counts) {
        this.counts = counts;
    }

    public CountAccumulator(StreamInput in) throws IOException {
        this.counts = in.readMap(StreamInput::readLong);
    }

    public void merge(CountAccumulator other) {
        this.counts = Stream.of(this.counts, other.counts).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> x + y));
    }

    public void add(String key, Long count) {
        this.counts.put(key, this.counts.getOrDefault(key, 0L) + count);
    }

    public Map<String, Long> asMap() {
        return this.counts;
    }

    public static CountAccumulator fromTermsAggregation(StringTerms termsAggregation) {
        return new CountAccumulator(termsAggregation.getBuckets().stream().collect(Collectors.toMap(bucket -> bucket.getKeyAsString(), bucket -> bucket.getDocCount())));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.counts, StreamOutput::writeLong);
    }

    public int hashCode() {
        return Objects.hash(this.counts);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CountAccumulator other = (CountAccumulator)obj;
        return Objects.equals(this.counts, other.counts);
    }
}

