/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.topn.KeyExtractor;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.TopNOperatorStatus;
import org.elasticsearch.compute.operator.topn.ValueExtractor;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class TopNOperator
implements Operator,
Accountable {
    private static final byte SMALL_NULL = 1;
    private static final byte BIG_NULL = 2;
    private final BlockFactory blockFactory;
    private final CircuitBreaker breaker;
    private final int maxPageSize;
    private final List<ElementType> elementTypes;
    private final List<TopNEncoder> encoders;
    private final List<SortOrder> sortOrders;
    private Queue inputQueue;
    private Row spare;
    private int spareValuesPreAllocSize = 0;
    private int spareKeysPreAllocSize = 0;
    private Iterator<Page> output;
    private int pagesReceived;
    private int pagesEmitted;
    private long rowsReceived;
    private long rowsEmitted;
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(TopNOperator.class) + RamUsageEstimator.shallowSizeOfInstance(List.class) * 3L;

    public TopNOperator(BlockFactory blockFactory, CircuitBreaker breaker, int topCount, List<ElementType> elementTypes, List<TopNEncoder> encoders, List<SortOrder> sortOrders, int maxPageSize) {
        this.blockFactory = blockFactory;
        this.breaker = breaker;
        this.maxPageSize = maxPageSize;
        this.elementTypes = elementTypes;
        this.encoders = encoders;
        this.sortOrders = sortOrders;
        this.inputQueue = Queue.build(breaker, topCount);
    }

    static int compareRows(Row r1, Row r2) {
        BytesRef br1 = r1.keys.bytesRefView();
        BytesRef br2 = r2.keys.bytesRefView();
        int mismatchedByteIndex = Arrays.mismatch(br1.bytes, br1.offset, br1.offset + br1.length, br2.bytes, br2.offset, br2.offset + br2.length);
        if (mismatchedByteIndex < 0) {
            return 0;
        }
        int length = Math.min(br1.length, br2.length);
        if (mismatchedByteIndex == length) {
            if (length == br1.length) {
                return r2.bytesOrder.isByteOrderAscending(length) ? 1 : -1;
            }
            return r1.bytesOrder.isByteOrderAscending(length) ? -1 : 1;
        }
        int c = Byte.compareUnsigned(br1.bytes[br1.offset + mismatchedByteIndex], br2.bytes[br2.offset + mismatchedByteIndex]);
        return r1.bytesOrder.isByteOrderAscending(mismatchedByteIndex) ? -c : c;
    }

    @Override
    public boolean needsInput() {
        return this.output == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInput(Page page) {
        try {
            RowFiller rowFiller = new RowFiller(this.elementTypes, this.encoders, this.sortOrders, page);
            for (int i = 0; i < page.getPositionCount(); ++i) {
                if (this.spare == null) {
                    this.spare = new Row(this.breaker, this.sortOrders, this.spareKeysPreAllocSize, this.spareValuesPreAllocSize);
                } else {
                    this.spare.keys.clear();
                    this.spare.values.clear();
                }
                rowFiller.row(i, this.spare);
                this.spareKeysPreAllocSize = Math.max(this.spare.keys.length(), this.spareKeysPreAllocSize / 2);
                this.spareValuesPreAllocSize = Math.max(this.spare.values.length(), this.spareValuesPreAllocSize / 2);
                this.spare = (Row)this.inputQueue.insertWithOverflow(this.spare);
            }
        }
        finally {
            page.releaseBlocks();
            ++this.pagesReceived;
            this.rowsReceived += (long)page.getPositionCount();
        }
    }

    @Override
    public void finish() {
        if (this.output == null) {
            this.output = this.toPages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<Page> toPages() {
        if (this.spare != null) {
            this.spare.close();
            this.spare = null;
        }
        if (this.inputQueue.size() == 0) {
            return Collections.emptyIterator();
        }
        ArrayList<Row> list = new ArrayList<Row>(this.inputQueue.size());
        ArrayList<Page> result = new ArrayList<Page>();
        Releasable[] builders = null;
        boolean success = false;
        try {
            while (this.inputQueue.size() > 0) {
                list.add((Row)this.inputQueue.pop());
            }
            Collections.reverse(list);
            this.inputQueue.close();
            this.inputQueue = null;
            int p = 0;
            int size = 0;
            for (int i = 0; i < list.size(); ++i) {
                if (builders == null) {
                    size = Math.min(this.maxPageSize, list.size() - i);
                    builders = new ResultBuilder[this.elementTypes.size()];
                    for (int b = 0; b < builders.length; ++b) {
                        builders[b] = ResultBuilder.resultBuilderFor(this.blockFactory, this.elementTypes.get(b), this.encoders.get(b).toUnsortable(), TopNOperator.channelInKey(this.sortOrders, b), size);
                    }
                    p = 0;
                }
                Row row = (Row)list.get(i);
                BytesRef keys = row.keys.bytesRefView();
                for (SortOrder sortOrder : this.sortOrders) {
                    if (keys.bytes[keys.offset] == sortOrder.nul()) {
                        ++keys.offset;
                        --keys.length;
                        continue;
                    }
                    ++keys.offset;
                    --keys.length;
                    builders[sortOrder.channel].decodeKey(keys);
                }
                if (keys.length != 0) {
                    throw new IllegalArgumentException("didn't read all keys");
                }
                BytesRef values = row.values.bytesRefView();
                for (ResultBuilder resultBuilder : builders) {
                    resultBuilder.decodeValue(values);
                }
                if (values.length != 0) {
                    throw new IllegalArgumentException("didn't read all values");
                }
                list.set(i, null);
                row.close();
                if (++p != size) continue;
                Releasable[] releasableArray = new Block[builders.length];
                try {
                    for (int b = 0; b < releasableArray.length; ++b) {
                        releasableArray[b] = builders[b].build();
                    }
                }
                finally {
                    if (releasableArray[releasableArray.length - 1] == null) {
                        Releasables.closeExpectNoException((Releasable[])releasableArray);
                    }
                }
                result.add(new Page((Block[])releasableArray));
                Releasables.closeExpectNoException((Releasable[])builders);
                builders = null;
            }
            assert (builders == null);
            success = true;
            Iterator<Page> iterator = result.iterator();
            return iterator;
        }
        finally {
            if (!success) {
                ArrayList<Releasable> close = new ArrayList<Releasable>(list);
                for (Page p : result) {
                    close.add(p::releaseBlocks);
                }
                Collections.addAll(close, builders);
                Releasables.closeExpectNoException((Releasable)Releasables.wrap(close));
            }
        }
    }

    private static boolean channelInKey(List<SortOrder> sortOrders, int channel) {
        for (SortOrder so : sortOrders) {
            if (so.channel != channel) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFinished() {
        return this.output != null && !this.output.hasNext();
    }

    @Override
    public Page getOutput() {
        if (this.output == null || !this.output.hasNext()) {
            return null;
        }
        Page ret = this.output.next();
        ++this.pagesEmitted;
        this.rowsEmitted += (long)ret.getPositionCount();
        return ret;
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.spare, this.inputQueue, this.output == null ? null : Releasables.wrap(() -> Iterators.map(this.output, p -> p::releaseBlocks))});
    }

    public long ramBytesUsed() {
        long arrHeader = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        long ref = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.alignObjectSize((long)(arrHeader + ref * (long)this.elementTypes.size()));
        size += RamUsageEstimator.alignObjectSize((long)(arrHeader + ref * (long)this.encoders.size()));
        size += RamUsageEstimator.alignObjectSize((long)(arrHeader + ref * (long)this.sortOrders.size()));
        size += (long)this.sortOrders.size() * SortOrder.SHALLOW_SIZE;
        if (this.inputQueue != null) {
            size += this.inputQueue.ramBytesUsed();
        }
        return size;
    }

    @Override
    public Operator.Status status() {
        return new TopNOperatorStatus(this.inputQueue != null ? this.inputQueue.size() : 0, this.ramBytesUsed(), this.pagesReceived, this.pagesEmitted, this.rowsReceived, this.rowsEmitted);
    }

    public String toString() {
        return "TopNOperator[count=" + String.valueOf((Object)this.inputQueue) + ", elementTypes=" + String.valueOf(this.elementTypes) + ", encoders=" + String.valueOf(this.encoders) + ", sortOrders=" + String.valueOf(this.sortOrders) + "]";
    }

    private static class Queue
    extends PriorityQueue<Row>
    implements Accountable,
    Releasable {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Queue.class);
        private final CircuitBreaker breaker;
        private final int topCount;

        static Queue build(CircuitBreaker breaker, int topCount) {
            breaker.addEstimateBytesAndMaybeBreak(Queue.sizeOf(topCount), "esql engine topn");
            return new Queue(breaker, topCount);
        }

        private Queue(CircuitBreaker breaker, int topCount) {
            super(topCount);
            this.breaker = breaker;
            this.topCount = topCount;
        }

        protected boolean lessThan(Row r1, Row r2) {
            return TopNOperator.compareRows(r1, r2) < 0;
        }

        public String toString() {
            return this.size() + "/" + this.topCount;
        }

        public long ramBytesUsed() {
            long total = SHALLOW_SIZE;
            total += RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * ((long)this.topCount + 1L)));
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Row r = (Row)iterator.next();
                total += r == null ? 0L : r.ramBytesUsed();
            }
            return total;
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{Releasables.wrap((Iterable)((Object)this)), () -> this.breaker.addWithoutBreaking(-Queue.sizeOf(this.topCount))});
        }

        public static long sizeOf(int topCount) {
            long total = SHALLOW_SIZE;
            return total += RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * ((long)topCount + 1L)));
        }
    }

    static final class Row
    implements Accountable,
    Releasable {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Row.class);
        final BreakingBytesRefBuilder keys;
        final BytesOrder bytesOrder;
        final BreakingBytesRefBuilder values;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Row(CircuitBreaker breaker, List<SortOrder> sortOrders, int preAllocatedKeysSize, int preAllocatedValueSize) {
            boolean success = false;
            try {
                this.keys = new BreakingBytesRefBuilder(breaker, "topn", preAllocatedKeysSize);
                this.values = new BreakingBytesRefBuilder(breaker, "topn", preAllocatedValueSize);
                this.bytesOrder = new BytesOrder(sortOrders, breaker, "topn");
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + this.keys.ramBytesUsed() + this.bytesOrder.ramBytesUsed() + this.values.ramBytesUsed();
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.keys, this.values, this.bytesOrder});
        }
    }

    static final class BytesOrder
    implements Releasable,
    Accountable {
        private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(BytesOrder.class);
        private final CircuitBreaker breaker;
        final List<SortOrder> sortOrders;
        final int[] endOffsets;

        BytesOrder(List<SortOrder> sortOrders, CircuitBreaker breaker, String label) {
            this.breaker = breaker;
            this.sortOrders = sortOrders;
            breaker.addEstimateBytesAndMaybeBreak(this.memoryUsed(sortOrders.size()), label);
            this.endOffsets = new int[sortOrders.size()];
        }

        boolean isByteOrderAscending(int bytePosition) {
            int index = Arrays.binarySearch(this.endOffsets, bytePosition);
            if (index < 0) {
                index = -1 - index;
            }
            return this.sortOrders.get(index).asc();
        }

        private long memoryUsed(int numKeys) {
            return BASE_RAM_USAGE + RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 4L * (long)numKeys));
        }

        public long ramBytesUsed() {
            return this.memoryUsed(this.sortOrders.size());
        }

        public void close() {
            this.breaker.addWithoutBreaking(-this.ramBytesUsed());
        }
    }

    static final class RowFiller {
        private final ValueExtractor[] valueExtractors;
        private final KeyFactory[] keyFactories;

        RowFiller(List<ElementType> elementTypes, List<TopNEncoder> encoders, List<SortOrder> sortOrders, Page page) {
            this.valueExtractors = new ValueExtractor[page.getBlockCount()];
            for (int b = 0; b < this.valueExtractors.length; ++b) {
                this.valueExtractors[b] = ValueExtractor.extractorFor(elementTypes.get(b), encoders.get(b).toUnsortable(), TopNOperator.channelInKey(sortOrders, b), page.getBlock(b));
            }
            this.keyFactories = new KeyFactory[sortOrders.size()];
            for (int k = 0; k < this.keyFactories.length; ++k) {
                SortOrder so = sortOrders.get(k);
                KeyExtractor extractor = KeyExtractor.extractorFor(elementTypes.get(so.channel), encoders.get(so.channel).toSortable(), so.asc, so.nul(), so.nonNul(), page.getBlock(so.channel));
                this.keyFactories[k] = new KeyFactory(extractor, so.asc);
            }
        }

        void row(int position, Row destination) {
            this.writeKey(position, destination);
            this.writeValues(position, destination.values);
        }

        private void writeKey(int position, Row row) {
            int orderByCompositeKeyCurrentPosition = 0;
            for (int i = 0; i < this.keyFactories.length; ++i) {
                int valueAsBytesSize = this.keyFactories[i].extractor.writeKey(row.keys, position);
                assert (valueAsBytesSize > 0) : valueAsBytesSize;
                row.bytesOrder.endOffsets[i] = (orderByCompositeKeyCurrentPosition += valueAsBytesSize) - 1;
            }
        }

        private void writeValues(int position, BreakingBytesRefBuilder values) {
            for (ValueExtractor e : this.valueExtractors) {
                e.writeValue(values, position);
            }
        }
    }

    public record SortOrder(int channel, boolean asc, boolean nullsFirst) {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(SortOrder.class);

        @Override
        public String toString() {
            return "SortOrder[channel=" + this.channel + ", asc=" + this.asc + ", nullsFirst=" + this.nullsFirst + "]";
        }

        byte nul() {
            if (this.nullsFirst) {
                return this.asc ? (byte)1 : 2;
            }
            return this.asc ? (byte)2 : 1;
        }

        byte nonNul() {
            if (this.nullsFirst) {
                return this.asc ? (byte)2 : 1;
            }
            return this.asc ? (byte)1 : 2;
        }
    }

    public record TopNOperatorFactory(int topCount, List<ElementType> elementTypes, List<TopNEncoder> encoders, List<SortOrder> sortOrders, int maxPageSize) implements Operator.OperatorFactory
    {
        public TopNOperatorFactory {
            for (ElementType e : elementTypes) {
                if (e != null) continue;
                throw new IllegalArgumentException("ElementType not known");
            }
        }

        @Override
        public TopNOperator get(DriverContext driverContext) {
            return new TopNOperator(driverContext.blockFactory(), driverContext.breaker(), this.topCount, this.elementTypes, this.encoders, this.sortOrders, this.maxPageSize);
        }

        @Override
        public String describe() {
            return "TopNOperator[count=" + this.topCount + ", elementTypes=" + String.valueOf(this.elementTypes) + ", encoders=" + String.valueOf(this.encoders) + ", sortOrders=" + String.valueOf(this.sortOrders) + "]";
        }
    }

    record KeyFactory(KeyExtractor extractor, boolean ascending) {
    }
}

