/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record OperatorStatus(String operator, @Nullable Operator.Status status) implements Writeable,
ToXContentObject
{
    public static OperatorStatus readFrom(StreamInput in) throws IOException {
        return new OperatorStatus(in.readString(), (Operator.Status)in.readOptionalNamedWriteable(Operator.Status.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.operator);
        out.writeOptionalNamedWriteable(this.status != null && out.getTransportVersion().onOrAfter((VersionId)this.status.getMinimalSupportedVersion()) ? this.status : null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("operator", this.operator);
        if (this.status != null) {
            builder.field("status", (ToXContent)this.status);
        }
        return builder.endObject();
    }

    @Override
    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public long documentsFound() {
        if (this.status == null) {
            return 0L;
        }
        return this.status.documentsFound();
    }

    public long valuesLoaded() {
        if (this.status == null) {
            return 0L;
        }
        return this.status.valuesLoaded();
    }
}

