/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.operator.DriverSleeps;
import org.elasticsearch.compute.operator.OperatorStatus;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class DriverStatus
implements Task.Status {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Task.Status.class, "driver", DriverStatus::new);
    private static final TransportVersion ESQL_DRIVER_TASK_DESCRIPTION = TransportVersion.fromName((String)"esql_driver_task_description");
    private final String sessionId;
    private final String taskDescription;
    private final long started;
    private final long lastUpdated;
    private final long cpuNanos;
    private final long iterations;
    private final Status status;
    private final List<OperatorStatus> completedOperators;
    private final List<OperatorStatus> activeOperators;
    private final DriverSleeps sleeps;

    DriverStatus(String sessionId, String taskDescription, long started, long lastUpdated, long cpuTime, long iterations, Status status, List<OperatorStatus> completedOperators, List<OperatorStatus> activeOperators, DriverSleeps sleeps) {
        this.sessionId = sessionId;
        this.taskDescription = taskDescription;
        this.started = started;
        this.lastUpdated = lastUpdated;
        this.cpuNanos = cpuTime;
        this.iterations = iterations;
        this.status = status;
        this.completedOperators = completedOperators;
        this.activeOperators = activeOperators;
        this.sleeps = sleeps;
    }

    public DriverStatus(StreamInput in) throws IOException {
        this.sessionId = in.readString();
        this.taskDescription = in.getTransportVersion().supports(ESQL_DRIVER_TASK_DESCRIPTION) ? in.readString() : "";
        this.started = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0) ? in.readLong() : 0L;
        this.lastUpdated = in.readLong();
        this.cpuNanos = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0) ? in.readVLong() : 0L;
        this.iterations = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0) ? in.readVLong() : 0L;
        this.status = Status.read(in);
        this.completedOperators = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0) ? in.readCollectionAsImmutableList(OperatorStatus::readFrom) : List.of();
        this.activeOperators = in.readCollectionAsImmutableList(OperatorStatus::readFrom);
        this.sleeps = DriverSleeps.read(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.sessionId);
        if (out.getTransportVersion().supports(ESQL_DRIVER_TASK_DESCRIPTION)) {
            out.writeString(this.taskDescription);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0)) {
            out.writeLong(this.started);
        }
        out.writeLong(this.lastUpdated);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0)) {
            out.writeVLong(this.cpuNanos);
            out.writeVLong(this.iterations);
        }
        this.status.writeTo(out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            out.writeCollection(this.completedOperators);
        }
        out.writeCollection(this.activeOperators);
        this.sleeps.writeTo(out);
    }

    public String getWriteableName() {
        return DriverStatus.ENTRY.name;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public String taskDescription() {
        return this.taskDescription;
    }

    public long started() {
        return this.started;
    }

    public long lastUpdated() {
        return this.lastUpdated;
    }

    public long cpuNanos() {
        return this.cpuNanos;
    }

    public long iterations() {
        return this.iterations;
    }

    public Status status() {
        return this.status;
    }

    public List<OperatorStatus> completedOperators() {
        return this.completedOperators;
    }

    public DriverSleeps sleeps() {
        return this.sleeps;
    }

    public List<OperatorStatus> activeOperators() {
        return this.activeOperators;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("session_id", this.sessionId);
        builder.field("task_description", this.taskDescription);
        builder.field("started", DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.formatMillis(this.started));
        builder.field("last_updated", DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.formatMillis(this.lastUpdated));
        builder.field("cpu_nanos", this.cpuNanos);
        if (builder.humanReadable()) {
            builder.field("cpu_time", (Object)TimeValue.timeValueNanos((long)this.cpuNanos));
        }
        builder.field("documents_found", this.documentsFound());
        builder.field("values_loaded", this.valuesLoaded());
        builder.field("iterations", this.iterations);
        builder.field("status", (ToXContent)this.status, params);
        builder.startArray("completed_operators");
        for (OperatorStatus completed : this.completedOperators) {
            builder.value((ToXContent)completed);
        }
        builder.endArray();
        builder.startArray("active_operators");
        for (OperatorStatus active : this.activeOperators) {
            builder.value((ToXContent)active);
        }
        builder.endArray();
        builder.field("sleeps", (ToXContent)this.sleeps, params);
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverStatus that = (DriverStatus)o;
        return this.sessionId.equals(that.sessionId) && this.taskDescription.equals(that.taskDescription) && this.started == that.started && this.lastUpdated == that.lastUpdated && this.cpuNanos == that.cpuNanos && this.iterations == that.iterations && this.status == that.status && this.completedOperators.equals(that.completedOperators) && this.activeOperators.equals(that.activeOperators) && this.sleeps.equals(that.sleeps);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sessionId, this.taskDescription, this.started, this.lastUpdated, this.cpuNanos, this.iterations, this.status, this.completedOperators, this.activeOperators, this.sleeps});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public long documentsFound() {
        long documentsFound = 0L;
        for (OperatorStatus s : this.completedOperators) {
            documentsFound += s.documentsFound();
        }
        for (OperatorStatus s : this.activeOperators) {
            documentsFound += s.documentsFound();
        }
        return documentsFound;
    }

    public long valuesLoaded() {
        long valuesLoaded = 0L;
        for (OperatorStatus s : this.completedOperators) {
            valuesLoaded += s.valuesLoaded();
        }
        for (OperatorStatus s : this.activeOperators) {
            valuesLoaded += s.valuesLoaded();
        }
        return valuesLoaded;
    }

    public static enum Status implements Writeable,
    ToXContentFragment
    {
        QUEUED,
        STARTING,
        RUNNING,
        ASYNC,
        WAITING,
        DONE;


        public static Status read(StreamInput in) throws IOException {
            return Status.valueOf(in.readString());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.toString());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.toString().toLowerCase(Locale.ROOT));
        }
    }
}

