/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.elasticsearch.gradle.testclusters.SslTrustResolver;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class WaitForHttpResource {
    private static final Logger logger = Logging.getLogger(WaitForHttpResource.class);
    private final SslTrustResolver trustResolver;
    private final URL url;
    private Set<Integer> validResponseCodes = Collections.singleton(200);
    private String username;
    private String password;

    public WaitForHttpResource(String protocol, String host, int numberOfNodes) throws MalformedURLException {
        this(new URL(protocol + "://" + host + "/_cluster/health?wait_for_nodes=>=" + numberOfNodes + "&wait_for_status=yellow"));
    }

    public WaitForHttpResource(URL url) {
        this.url = url;
        this.trustResolver = new SslTrustResolver();
    }

    public void setValidResponseCodes(int ... validResponseCodes) {
        this.validResponseCodes = new HashSet<Integer>(validResponseCodes.length);
        for (int rc : validResponseCodes) {
            this.validResponseCodes.add(rc);
        }
    }

    public void setCertificateAuthorities(File ... certificateAuthorities) {
        this.trustResolver.setCertificateAuthorities(certificateAuthorities);
    }

    public void setTrustStoreFile(File trustStoreFile) {
        this.trustResolver.setTrustStoreFile(trustStoreFile);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustResolver.setTrustStorePassword(trustStorePassword);
    }

    public void setServerCertificate(File serverCertificate) {
        this.trustResolver.setServerCertificate(serverCertificate);
    }

    public void setServerKeystoreFile(File keyStoreFile) {
        this.trustResolver.setServerKeystoreFile(keyStoreFile);
    }

    public void setServerKeystorePassword(String keyStorePassword) {
        this.trustResolver.setServerKeystorePassword(keyStorePassword);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean wait(int durationInMs) throws GeneralSecurityException, InterruptedException, IOException {
        long waitUntil = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(durationInMs);
        long sleep = Long.max(durationInMs / 10, 100L);
        SSLContext ssl = this.trustResolver.getSslContext();
        IOException failure = null;
        while (true) {
            try {
                this.checkResource(ssl);
                return true;
            }
            catch (IOException e) {
                logger.debug("Failed to access resource [{}]", (Object)this.url, (Object)e);
                failure = e;
                if (System.nanoTime() < waitUntil) {
                    Thread.sleep(sleep);
                    continue;
                }
                throw failure;
            }
            break;
        }
    }

    protected void checkResource(SSLContext ssl) throws IOException {
        HttpURLConnection connection = this.buildConnection(ssl);
        connection.connect();
        Integer response = connection.getResponseCode();
        if (this.validResponseCodes.contains(response)) {
            logger.info("Got successful response [{}] from URL [{}]", (Object)response, (Object)this.url);
            return;
        }
        throw new IOException(response + " " + connection.getResponseMessage());
    }

    HttpURLConnection buildConnection(SSLContext ssl) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        this.configureSslContext(connection, ssl);
        this.configureBasicAuth(connection);
        connection.setRequestMethod("GET");
        return connection;
    }

    private void configureSslContext(HttpURLConnection connection, SSLContext ssl) {
        if (ssl != null) {
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(ssl.getSocketFactory());
            } else {
                throw new IllegalStateException("SSL trust has been configured, but [" + String.valueOf(this.url) + "] is not a 'https' URL");
            }
        }
    }

    private void configureBasicAuth(HttpURLConnection connection) {
        if (this.username != null) {
            if (this.password == null) {
                throw new IllegalStateException("Basic Auth user [" + this.username + "] has been set, but no password has been configured");
            }
            connection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8)));
        }
    }
}

