/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test;

import java.util.List;
import javax.inject.Inject;
import org.elasticsearch.gradle.plugin.GenerateTestBuildInfoTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.language.jvm.tasks.ProcessResources;

public class TestBuildInfoPlugin
implements Plugin<Project> {
    protected final ProviderFactory providerFactory;

    @Inject
    public TestBuildInfoPlugin(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void apply(Project project) {
        TaskProvider testBuildInfoTask = project.getTasks().register("generateTestBuildInfo", GenerateTestBuildInfoTask.class, task -> {
            Configuration codeLocations = project.getConfigurations().getByName("runtimeClasspath");
            Configuration compileOnly = (Configuration)project.getConfigurations().findByName("resolveableCompileOnly");
            if (compileOnly != null) {
                codeLocations = codeLocations.minus((FileCollection)compileOnly);
            }
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            codeLocations = codeLocations.plus(((SourceSet)sourceSets.getByName("main")).getOutput().getClassesDirs());
            task.getCodeLocations().set((Object)codeLocations);
        });
        project.getTasks().withType(ProcessResources.class).named("processResources").configure(task -> task.into((Object)"META-INF", copy -> copy.from(new Object[]{testBuildInfoTask})));
        if (project.getRootProject().getName().equals("elasticsearch")) {
            project.getTasks().withType(Test.class).matching(test -> List.of("test", "internalClusterTest").contains(test.getName())).configureEach(test -> test.systemProperty("es.entitlement.enableForTests", (Object)"true"));
        }
    }
}

