/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.transport.TcpChannel;

public class FakeTcpChannel
implements TcpChannel {
    private final boolean isServer;
    private final InetSocketAddress localAddress;
    private final InetSocketAddress remoteAddress;
    private final String profile;
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();
    private final ListenableFuture<Void> closeContext = new ListenableFuture();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicReference<BytesReference> messageCaptor;
    private final AtomicReference<ActionListener<Void>> listenerCaptor;
    private volatile Exception closeException = null;

    public FakeTcpChannel() {
        this(false, "profile", new AtomicReference<BytesReference>());
    }

    public FakeTcpChannel(boolean isServer) {
        this(isServer, "profile", new AtomicReference<BytesReference>());
    }

    public FakeTcpChannel(boolean isServer, InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        this(isServer, localAddress, remoteAddress, "profile", new AtomicReference<BytesReference>());
    }

    public FakeTcpChannel(boolean isServer, String profile, AtomicReference<BytesReference> messageCaptor) {
        this(isServer, null, null, profile, messageCaptor);
    }

    public FakeTcpChannel(boolean isServer, InetSocketAddress localAddress, InetSocketAddress remoteAddress, String profile, AtomicReference<BytesReference> messageCaptor) {
        this.isServer = isServer;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.profile = profile;
        this.messageCaptor = messageCaptor;
        this.listenerCaptor = new AtomicReference();
    }

    public boolean isServerChannel() {
        return this.isServer;
    }

    public String getProfile() {
        return this.profile;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        this.messageCaptor.set(reference);
        this.listenerCaptor.set(listener);
    }

    public void addConnectListener(ActionListener<Void> listener) {
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.closeException != null) {
                this.closeContext.onFailure(this.closeException);
            } else {
                this.closeContext.onResponse(null);
            }
        }
    }

    public void setCloseException(Exception e) {
        this.closeException = e;
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(listener);
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }

    public AtomicReference<BytesReference> getMessageCaptor() {
        return this.messageCaptor;
    }

    public AtomicReference<ActionListener<Void>> getListenerCaptor() {
        return this.listenerCaptor;
    }
}

