/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class LambdaMatchers {
    public static <T, U> Matcher<T> transformedMatch(Function<T, U> function, Matcher<U> matcher) {
        return new TransformMatcher<T, U>("transformed value", matcher, function);
    }

    public static <T, U> Matcher<T> transformedMatch(String description, Function<T, U> function, Matcher<U> matcher) {
        return new TransformMatcher<T, U>(description, matcher, function);
    }

    public static <T, U> Matcher<Iterable<T>> transformedItemsMatch(Function<T, U> function, Matcher<Iterable<? extends U>> matcher) {
        return new ListTransformMatcher<T, U>("transformed items", matcher, function);
    }

    public static <T, U> Matcher<Iterable<T>> transformedItemsMatch(String transformDescription, Function<T, U> function, Matcher<Iterable<? extends U>> matcher) {
        return new ListTransformMatcher<T, U>(transformDescription, matcher, function);
    }

    public static <T, U> Matcher<T[]> transformedArrayItemsMatch(Function<T, U> function, Matcher<U[]> matcher) {
        return new ArrayTransformMatcher<T, U>("transformed items", matcher, function);
    }

    public static <T, U> Matcher<T[]> transformedArrayItemsMatch(String transformDescription, Function<T, U> function, Matcher<U[]> matcher) {
        return new ArrayTransformMatcher<T, U>(transformDescription, matcher, function);
    }

    public static <T> Matcher<Predicate<? super T>> trueWith(T item) {
        return new PredicateMatcher<T>(item);
    }

    public static <T> Matcher<Predicate<? super T>> falseWith(T item) {
        return new PredicateFalseMatcher<T>(item);
    }

    private static class TransformMatcher<T, U>
    extends BaseMatcher<T> {
        private final String transformDescription;
        private final Matcher<U> matcher;
        private final Function<T, U> transform;

        private TransformMatcher(String transformDescription, Matcher<U> matcher, Function<T, U> transform) {
            this.transformDescription = transformDescription;
            this.matcher = matcher;
            this.transform = transform;
        }

        public boolean matches(Object actual) {
            U u;
            try {
                u = this.transform.apply(actual);
            }
            catch (ClassCastException e) {
                throw new AssertionError((Object)e);
            }
            return this.matcher.matches(u);
        }

        public void describeMismatch(Object item, Description description) {
            U u;
            try {
                u = this.transform.apply(item);
            }
            catch (ClassCastException e) {
                description.appendValue(item).appendText(" is not of the correct type (").appendText(e.getMessage()).appendText(")");
                return;
            }
            description.appendText(this.transformDescription).appendText(" ");
            this.matcher.describeMismatch(u, description);
        }

        public void describeTo(Description description) {
            description.appendText(this.transformDescription).appendText(" matches ").appendDescriptionOf(this.matcher);
        }
    }

    private static class ListTransformMatcher<T, U>
    extends TypeSafeMatcher<Iterable<T>> {
        private final String transformDescription;
        private final Matcher<Iterable<? extends U>> matcher;
        private final Function<T, U> transform;

        private ListTransformMatcher(String transformDescription, Matcher<Iterable<? extends U>> matcher, Function<T, U> transform) {
            this.transformDescription = transformDescription;
            this.matcher = matcher;
            this.transform = transform;
        }

        protected boolean matchesSafely(Iterable<T> item) {
            ArrayList<U> us = new ArrayList<U>();
            for (T i : item) {
                try {
                    us.add(this.transform.apply(i));
                }
                catch (ClassCastException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return this.matcher.matches(us);
        }

        protected void describeMismatchSafely(Iterable<T> item, Description description) {
            ArrayList<U> us = new ArrayList<U>();
            int i = 0;
            Iterator<T> iterator = item.iterator();
            while (iterator.hasNext()) {
                try {
                    us.add(this.transform.apply(iterator.next()));
                }
                catch (ClassCastException e) {
                    description.appendValue((Object)i).appendText(" at index " + i).appendText(" is not of the correct type (").appendText(e.getMessage()).appendText(")");
                    return;
                }
                ++i;
            }
            description.appendText(this.transformDescription).appendText(" ");
            this.matcher.describeMismatch(us, description);
        }

        public void describeTo(Description description) {
            description.appendText("iterable with ").appendText(this.transformDescription).appendText(" matching ").appendDescriptionOf(this.matcher);
        }
    }

    private static class ArrayTransformMatcher<T, U>
    extends TypeSafeMatcher<T[]> {
        private final String transformDescription;
        private final Matcher<U[]> matcher;
        private final Function<T, U> transform;

        private ArrayTransformMatcher(String transformDescription, Matcher<U[]> matcher, Function<T, U> transform) {
            this.transformDescription = transformDescription;
            this.matcher = matcher;
            this.transform = transform;
        }

        protected boolean matchesSafely(T[] item) {
            Object[] us = null;
            for (int i = 0; i < item.length; ++i) {
                U u;
                try {
                    u = this.transform.apply(item[i]);
                }
                catch (ClassCastException e) {
                    throw new AssertionError((Object)e);
                }
                if (us == null) {
                    us = (Object[])Array.newInstance(u.getClass(), item.length);
                }
                us[i] = u;
            }
            return this.matcher.matches(us);
        }

        protected void describeMismatchSafely(T[] item, Description description) {
            Object[] us = null;
            for (int i = 0; i < item.length; ++i) {
                U u;
                try {
                    u = this.transform.apply(item[i]);
                }
                catch (ClassCastException e) {
                    description.appendValue((Object)i).appendText(" at index " + i).appendText(" is not of the correct type (").appendText(e.getMessage()).appendText(")");
                    return;
                }
                if (us == null) {
                    us = (Object[])Array.newInstance(u.getClass(), item.length);
                }
                us[i] = u;
            }
            description.appendText(this.transformDescription).appendText(" ");
            this.matcher.describeMismatch(us, description);
        }

        public void describeTo(Description description) {
            description.appendText("array with ").appendText(this.transformDescription).appendText(" matching ").appendDescriptionOf(this.matcher);
        }
    }

    private static class PredicateMatcher<T>
    extends BaseMatcher<Predicate<? super T>> {
        final T item;

        private PredicateMatcher(T item) {
            this.item = item;
        }

        public boolean matches(Object actual) {
            Predicate p = (Predicate)actual;
            try {
                return this.predicateMatches(p);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        protected boolean predicateMatches(Predicate predicate) {
            return predicate.test(this.item);
        }

        public void describeMismatch(Object item, Description description) {
            Predicate p = (Predicate)item;
            try {
                boolean result = p.test(this.item);
                description.appendText("predicate with argument ").appendValue(this.item).appendText(" evaluated to ").appendValue((Object)result);
            }
            catch (ClassCastException e) {
                description.appendText("predicate did not accept argument of type ").appendValue(this.item.getClass()).appendText(" (").appendText(e.getMessage()).appendText(")");
            }
        }

        public void describeTo(Description description) {
            description.appendText("predicate evaluates to <true> with argument ").appendValue(this.item);
        }
    }

    private static class PredicateFalseMatcher<T>
    extends PredicateMatcher<T> {
        private PredicateFalseMatcher(T item) {
            super(item);
        }

        @Override
        protected boolean predicateMatches(Predicate predicate) {
            return !predicate.test(this.item);
        }

        @Override
        public void describeTo(Description description) {
            description.appendText("predicate evaluates to <false> with argument ").appendValue(this.item);
        }
    }
}

