/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.tests.index.FieldFilterLeafReader;

public class FieldMaskingReader
extends FilterDirectoryReader {
    private final Set<String> fields;

    public FieldMaskingReader(String field, DirectoryReader in) throws IOException {
        this(Set.of(field), in);
    }

    public FieldMaskingReader(final Set<String> fields, DirectoryReader in) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            public LeafReader wrap(final LeafReader reader) {
                return new FilterLeafReader((LeafReader)new FieldFilterLeafReader(reader, fields, true)){

                    public IndexReader.CacheHelper getReaderCacheHelper() {
                        return reader.getReaderCacheHelper();
                    }

                    public IndexReader.CacheHelper getCoreCacheHelper() {
                        return reader.getCoreCacheHelper();
                    }
                };
            }
        });
        this.fields = fields;
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new FieldMaskingReader(this.fields, in);
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }
}

