/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpHost;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.admin.cluster.allocation.ClusterAllocationExplainRequest;
import org.elasticsearch.action.admin.cluster.allocation.ClusterAllocationExplainResponse;
import org.elasticsearch.action.admin.cluster.allocation.TransportClusterAllocationExplainAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksRequest;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.elasticsearch.action.admin.cluster.tasks.TransportPendingClusterTasksAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.flush.FlushRequestBuilder;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.datastreams.GetDataStreamAction;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.IsAcknowledgedSupplier;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.internal.AdminClient;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ClusterAdminClient;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterInfoServiceUtils;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.SettingsBasedSeedHostsProvider;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.TestEnvironment;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.health.node.selection.HealthNode;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.MergePolicyConfig;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.MockEngineFactoryPlugin;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.ThreadPoolMergeScheduler;
import org.elasticsearch.index.mapper.MockFieldFilterPlugin;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.IndicesRequestCache;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.monitor.jvm.HotThreads;
import org.elasticsearch.node.NodeMocksPlugin;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.script.MockScriptService;
import org.elasticsearch.search.ConcurrentSearchTestPlugin;
import org.elasticsearch.search.MockSearchService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchResponseUtils;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.test.BackgroundIndexer;
import org.elasticsearch.test.CloseableTestClusterWrapper;
import org.elasticsearch.test.ClusterServiceUtils;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.MockHttpTransport;
import org.elasticsearch.test.NodeConfigurationSource;
import org.elasticsearch.test.TestCluster;
import org.elasticsearch.test.XContentTestUtils;
import org.elasticsearch.test.client.RandomizingClient;
import org.elasticsearch.test.disruption.NetworkDisruption;
import org.elasticsearch.test.disruption.ServiceDisruptionScheme;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.test.store.MockFSIndexStore;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.smile.SmileXContent;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

@LuceneTestCase.SuppressFileSystems(value={"ExtrasFS"})
public abstract class ESIntegTestCase
extends ESTestCase {
    public static final String SUITE_CLUSTER_NODE_PREFIX = "node_s";
    public static final String TEST_CLUSTER_NODE_PREFIX = "node_t";
    public static final String TESTS_CLUSTER = "tests.cluster";
    public static final String TESTS_CLUSTER_NAME = "tests.clustername";
    public static final Setting<Long> INDEX_TEST_SEED_SETTING = Setting.longSetting((String)"index.tests.seed", (long)0L, (long)Long.MIN_VALUE, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
    public static final String TESTS_ENABLE_MOCK_MODULES = "tests.enable_mock_modules";
    private static final boolean MOCK_MODULES_ENABLED = "true".equals(System.getProperty("tests.enable_mock_modules", "true"));
    private static final int FREQUENT_BULK_THRESHOLD = 300;
    private static final int ALWAYS_BULK_THRESHOLD = 3000;
    private static final int MAX_IN_FLIGHT_ASYNC_INDEXES = 150;
    private static final int MAX_BULK_INDEX_REQUEST_SIZE = 1000;
    protected static final int DEFAULT_MIN_NUM_SHARDS = 1;
    protected static final int DEFAULT_MAX_NUM_SHARDS = 10;
    private static TestCluster currentCluster;
    private static RestClient restClient;
    private static final Map<Class<?>, TestCluster> clusters;
    private static ESIntegTestCase INSTANCE;
    private static Long SUITE_SEED;
    private final AtomicInteger dummmyDocIdGenerator = new AtomicInteger();

    @BeforeClass
    public static void beforeClass() throws Exception {
        SUITE_SEED = ESIntegTestCase.randomLong();
        ESIntegTestCase.initializeSuiteScope();
    }

    @Override
    protected final boolean enableWarningsCheck() {
        return false;
    }

    protected final void beforeInternal() throws Exception {
        Scope currentClusterScope = this.getCurrentClusterScope();
        Callable<Void> setup = () -> {
            ESIntegTestCase.cluster().beforeTest(ESIntegTestCase.random());
            ESIntegTestCase.cluster().wipe(this.excludeTemplates());
            this.randomIndexTemplate();
            return null;
        };
        switch (currentClusterScope) {
            case SUITE: {
                assert (SUITE_SEED != null) : "Suite seed was not initialized";
                currentCluster = this.buildAndPutCluster(currentClusterScope, SUITE_SEED);
                RandomizedContext.current().runWithPrivateRandomness(SUITE_SEED.longValue(), setup);
                break;
            }
            case TEST: {
                currentCluster = this.buildAndPutCluster(currentClusterScope, ESIntegTestCase.randomLong());
                setup.call();
            }
        }
    }

    private void printTestMessage(String message) {
        if (ESIntegTestCase.isSuiteScopedTest(((Object)((Object)this)).getClass()) && this.getTestName().equals("<unknown>")) {
            this.logger.info("[{}]: {} suite", (Object)ESIntegTestCase.getTestClass().getSimpleName(), (Object)message);
        } else {
            this.logger.info("[{}#{}]: {} test", (Object)ESIntegTestCase.getTestClass().getSimpleName(), (Object)this.getTestName(), (Object)message);
        }
    }

    private void randomIndexTemplate() {
        if (ESIntegTestCase.cluster().size() > 0) {
            Settings.Builder randomSettingsBuilder = this.setRandomIndexSettings(ESIntegTestCase.random(), Settings.builder());
            if (ESIntegTestCase.isInternalCluster()) {
                randomSettingsBuilder.put(INDEX_TEST_SEED_SETTING.getKey(), ESIntegTestCase.random().nextLong());
            }
            randomSettingsBuilder.put("index.number_of_shards", this.numberOfShards()).put("index.number_of_replicas", this.numberOfReplicas());
            LuceneTestCase.SuppressCodecs annotation = ((Object)((Object)this)).getClass().getAnnotation(LuceneTestCase.SuppressCodecs.class);
            if (annotation != null && annotation.value().length == 1 && "*".equals(annotation.value()[0])) {
                randomSettingsBuilder.put("index.codec", ESIntegTestCase.randomFrom("default", "best_compression"));
            } else {
                randomSettingsBuilder.put("index.codec", "lucene_default");
            }
            for (String setting : randomSettingsBuilder.keys()) {
                ESIntegTestCase.assertThat("non index. prefix setting set on index template, its a node setting...", setting, Matchers.startsWith((String)"index."));
            }
            randomSettingsBuilder.put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), 0);
            if (ESIntegTestCase.randomBoolean()) {
                randomSettingsBuilder.put(IndexModule.INDEX_QUERY_CACHE_ENABLED_SETTING.getKey(), ESIntegTestCase.randomBoolean());
            }
            PutIndexTemplateRequestBuilder putTemplate = ESIntegTestCase.indicesAdmin().preparePutTemplate("random_index_template").setPatterns(Collections.singletonList("*")).setOrder(0).setSettings(randomSettingsBuilder);
            ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)putTemplate.get());
        }
    }

    protected Settings.Builder setRandomIndexSettings(Random random, Settings.Builder builder) {
        ESIntegTestCase.setRandomIndexMergeSettings(random, builder);
        ESIntegTestCase.setRandomIndexTranslogSettings(random, builder);
        if (random.nextBoolean()) {
            builder.put(MergeSchedulerConfig.AUTO_THROTTLE_SETTING.getKey(), false);
        }
        if (random.nextBoolean()) {
            builder.put(IndicesRequestCache.INDEX_CACHE_REQUEST_ENABLED_SETTING.getKey(), random.nextBoolean());
        }
        if (random.nextBoolean()) {
            builder.put(IndexSettings.INDEX_CHECK_ON_STARTUP.getKey(), ESIntegTestCase.randomFrom(random, new String[]{"false", "checksum", "true"}));
        }
        if (random.nextBoolean()) {
            builder.put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)1, (int)15) + "ms");
        }
        if (ESIntegTestCase.randomBoolean()) {
            builder.put(IndexSettings.BLOOM_FILTER_ID_FIELD_ENABLED_SETTING.getKey(), ESIntegTestCase.randomBoolean());
        }
        return builder;
    }

    private static Settings.Builder setRandomIndexMergeSettings(Random random, Settings.Builder builder) {
        if (random.nextBoolean()) {
            builder.put(MergePolicyConfig.INDEX_COMPOUND_FORMAT_SETTING.getKey(), (random.nextBoolean() ? (Constable)Double.valueOf(random.nextDouble()) : (Constable)Boolean.valueOf(random.nextBoolean())).toString());
        }
        switch (random.nextInt(4)) {
            case 3: {
                int maxThreadCount = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)4);
                int maxMergeCount = RandomNumbers.randomIntBetween((Random)random, (int)maxThreadCount, (int)(maxThreadCount + 4));
                builder.put(MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING.getKey(), maxMergeCount);
                builder.put(MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING.getKey(), maxThreadCount);
            }
        }
        return builder;
    }

    private static Settings.Builder setRandomIndexTranslogSettings(Random random, Settings.Builder builder) {
        if (random.nextBoolean()) {
            builder.put(IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING.getKey(), new ByteSizeValue((long)RandomNumbers.randomIntBetween((Random)random, (int)1, (int)300), ByteSizeUnit.MB));
        }
        if (random.nextBoolean()) {
            builder.put(IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING.getKey(), new ByteSizeValue(1L, ByteSizeUnit.PB));
        }
        if (random.nextBoolean()) {
            builder.put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), (Enum)RandomPicks.randomFrom((Random)random, (Object[])Translog.Durability.values()));
        }
        if (random.nextBoolean()) {
            builder.put(IndexSettings.INDEX_TRANSLOG_SYNC_INTERVAL_SETTING.getKey(), (long)RandomNumbers.randomIntBetween((Random)random, (int)100, (int)5000), TimeUnit.MILLISECONDS);
        }
        return builder;
    }

    private TestCluster buildWithPrivateContext(Scope scope, long seed) throws Exception {
        return (TestCluster)RandomizedContext.current().runWithPrivateRandomness(seed, () -> this.buildTestCluster(scope, seed));
    }

    private TestCluster buildAndPutCluster(Scope currentClusterScope, long seed) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        TestCluster testCluster = clusters.remove(clazz);
        ESIntegTestCase.clearClusters();
        switch (currentClusterScope) {
            case SUITE: {
                if (testCluster != null) break;
                testCluster = this.buildWithPrivateContext(currentClusterScope, seed);
                break;
            }
            case TEST: {
                if (testCluster != null) {
                    IOUtils.closeWhileHandlingException(testCluster::close);
                    TEST_ENTITLEMENTS.revokeAllEntitledNodePaths();
                }
                testCluster = this.buildTestCluster(currentClusterScope, seed);
            }
        }
        clusters.put(clazz, testCluster);
        return testCluster;
    }

    private static void clearClusters() throws Exception {
        if (!clusters.isEmpty()) {
            IOUtils.close(CloseableTestClusterWrapper.wrap(clusters.values()));
            clusters.clear();
        }
        if (restClient != null) {
            restClient.close();
            restClient = null;
        }
        ESIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            int numChannels = RestCancellableNodeClient.getNumChannels();
            ESIntegTestCase.assertEquals((String)(numChannels + " channels still being tracked in " + RestCancellableNodeClient.class.getSimpleName() + " while there should be none"), (long)0L, (long)numChannels);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterInternal(boolean afterClass) throws Exception {
        boolean success = false;
        try {
            Scope currentClusterScope = this.getCurrentClusterScope();
            if (ESIntegTestCase.isInternalCluster()) {
                ESIntegTestCase.internalCluster().clearDisruptionScheme();
            }
            try {
                if (ESIntegTestCase.cluster() != null) {
                    if (currentClusterScope != Scope.TEST) {
                        Metadata metadata = ((ClusterStateResponse)ESIntegTestCase.clusterAdmin().prepareState(TEST_REQUEST_TIMEOUT).get()).getState().getMetadata();
                        HashSet persistentKeys = new HashSet(metadata.persistentSettings().keySet());
                        ESIntegTestCase.assertThat("test leaves persistent cluster metadata behind", persistentKeys, Matchers.empty());
                        HashSet transientKeys = new HashSet(metadata.transientSettings().keySet());
                        ESIntegTestCase.assertThat("test leaves transient cluster metadata behind", transientKeys, Matchers.empty());
                    }
                    this.ensureClusterSizeConsistency();
                    this.ensureClusterStateConsistency();
                    this.ensureClusterStateCanBeReadByNodeTool();
                    ESIntegTestCase.ensureClusterInfoServiceRunning();
                    this.beforeIndexDeletion();
                    ESIntegTestCase.cluster().wipe(this.excludeTemplates());
                    ESIntegTestCase.cluster().assertAfterTest();
                    if (afterClass || currentClusterScope == Scope.TEST) {
                        ESIntegTestCase.cluster().close();
                    }
                }
            }
            finally {
                if (currentClusterScope == Scope.TEST) {
                    ESIntegTestCase.clearClusters();
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                // empty if block
            }
        }
    }

    protected Set<String> excludeTemplates() {
        return Collections.emptySet();
    }

    protected void beforeIndexDeletion() throws Exception {
        ESIntegTestCase.cluster().beforeIndexDeletion();
    }

    public static TestCluster cluster() {
        return currentCluster;
    }

    public static boolean isInternalCluster() {
        return currentCluster instanceof InternalTestCluster;
    }

    public static InternalTestCluster internalCluster() {
        if (!ESIntegTestCase.isInternalCluster()) {
            throw new UnsupportedOperationException("current test cluster is immutable");
        }
        return (InternalTestCluster)currentCluster;
    }

    public ClusterService clusterService() {
        return ESIntegTestCase.internalCluster().clusterService();
    }

    public static Client client() {
        return ESIntegTestCase.client(null);
    }

    public static Client client(@Nullable String node) {
        if (node != null) {
            return ESIntegTestCase.internalCluster().client(node);
        }
        Object client = ESIntegTestCase.cluster().client();
        if (ESIntegTestCase.frequently()) {
            client = new RandomizingClient((Client)client, ESIntegTestCase.random());
        }
        return client;
    }

    public static Client dataNodeClient() {
        Object client = ESIntegTestCase.internalCluster().dataNodeClient();
        if (ESIntegTestCase.frequently()) {
            client = new RandomizingClient((Client)client, ESIntegTestCase.random());
        }
        return client;
    }

    public static <T extends ActionResponse> T safeExecute(ActionType<T> action, ActionRequest request) {
        return ESIntegTestCase.safeExecute((ElasticsearchClient)ESIntegTestCase.client(), action, request);
    }

    public static Iterable<Client> clients() {
        return ESIntegTestCase.cluster().getClients();
    }

    protected int minimumNumberOfShards() {
        return 1;
    }

    protected int maximumNumberOfShards() {
        return 10;
    }

    protected int numberOfShards() {
        return ESIntegTestCase.between(this.minimumNumberOfShards(), this.maximumNumberOfShards());
    }

    protected int minimumNumberOfReplicas() {
        return 0;
    }

    protected int maximumNumberOfReplicas() {
        int maxNumReplicas = Math.max(0, ESIntegTestCase.cluster().numDataNodes() - 1);
        return ESIntegTestCase.frequently() ? Math.min(1, maxNumReplicas) : maxNumReplicas;
    }

    protected int numberOfReplicas() {
        return ESIntegTestCase.between(this.minimumNumberOfReplicas(), this.maximumNumberOfReplicas());
    }

    public void setDisruptionScheme(ServiceDisruptionScheme scheme) {
        ESIntegTestCase.internalCluster().setDisruptionScheme(scheme);
    }

    protected static NetworkDisruption isolateMasterDisruption(NetworkDisruption.NetworkLinkDisruptionType disruptionType) {
        String masterNode = ESIntegTestCase.internalCluster().getMasterName();
        return new NetworkDisruption(new NetworkDisruption.TwoPartitions(Collections.singleton(masterNode), Arrays.stream(ESIntegTestCase.internalCluster().getNodeNames()).filter(name -> !name.equals(masterNode)).collect(Collectors.toSet())), disruptionType);
    }

    public Settings indexSettings() {
        int numberOfReplicas;
        Settings.Builder builder = Settings.builder();
        int numberOfShards = this.numberOfShards();
        if (numberOfShards > 0) {
            builder.put("index.number_of_shards", numberOfShards);
        }
        if ((numberOfReplicas = this.numberOfReplicas()) >= 0) {
            builder.put("index.number_of_replicas", numberOfReplicas);
        }
        if (ESIntegTestCase.randomInt(9) < 3) {
            String dataPath = ESIntegTestCase.randomAlphaOfLength(10);
            this.logger.info("using custom data_path for index: [{}]", (Object)dataPath);
            builder.put("index.data_path", dataPath);
        }
        builder.put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), 0);
        if (ESIntegTestCase.randomBoolean()) {
            builder.put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), ESIntegTestCase.between(0, 1000));
        }
        if (ESIntegTestCase.randomBoolean()) {
            builder.put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING.getKey(), TimeValue.timeValueMillis((long)ESIntegTestCase.randomLongBetween(0L, ESIntegTestCase.randomBoolean() ? 1000L : ((TimeValue)IndexSettings.INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING.get(Settings.EMPTY)).millis())).getStringRep());
        }
        return builder.build();
    }

    public final void createIndex(String ... names) {
        ElasticsearchAssertions.assertAcked((CreateIndexRequestBuilder[])Arrays.stream(names).map(this::prepareCreate).toArray(CreateIndexRequestBuilder[]::new));
    }

    public final void createIndex(String name, Settings indexSettings) {
        ElasticsearchAssertions.assertAcked(this.prepareCreate(name).setSettings(indexSettings));
    }

    public final void createIndex(String name, int shards, int replicas) {
        this.createIndex(name, ESIntegTestCase.indexSettings(shards, replicas).build());
    }

    public final CreateIndexRequestBuilder prepareCreate(String index) {
        return this.prepareCreate(index, -1);
    }

    public final CreateIndexRequestBuilder prepareCreate(String index, int numNodes) {
        return this.prepareCreate(index, numNodes, Settings.builder());
    }

    public CreateIndexRequestBuilder prepareCreate(String index, Settings.Builder settingsBuilder) {
        return this.prepareCreate(index, -1, settingsBuilder);
    }

    public CreateIndexRequestBuilder prepareCreate(String index, int numNodes, Settings.Builder settingsBuilder) {
        Settings.Builder builder = Settings.builder().put(this.indexSettings()).put(settingsBuilder.build());
        if (numNodes > 0) {
            ESIntegTestCase.internalCluster().ensureAtLeastNumDataNodes(numNodes);
            ESIntegTestCase.getExcludeSettings(numNodes, builder);
        }
        return ESIntegTestCase.indicesAdmin().prepareCreate(index).setSettings(builder.build());
    }

    public static void updateIndexSettings(Settings.Builder settingsBuilder, String ... index) {
        UpdateSettingsRequestBuilder settingsRequest = ESIntegTestCase.indicesAdmin().prepareUpdateSettings(index);
        settingsRequest.setSettings(settingsBuilder);
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)settingsRequest.get());
    }

    public static void setReplicaCount(int replicas, String index) {
        ESIntegTestCase.updateIndexSettings(Settings.builder().put("index.number_of_replicas", replicas), index);
    }

    private static Settings.Builder getExcludeSettings(int num, Settings.Builder builder) {
        String exclude = String.join((CharSequence)",", ESIntegTestCase.internalCluster().allDataNodesButN(num));
        builder.put("index.routing.allocation.exclude._name", exclude);
        return builder;
    }

    public static List<String> waitForDataStreamBackingIndices(String dataStreamName, int expectedSize) {
        return ESIntegTestCase.waitForDataStreamIndices(dataStreamName, expectedSize, false);
    }

    public static List<String> waitForDataStreamIndices(String dataStreamName, int expectedSize, boolean failureStore) {
        SubscribableListener<Void> listener = ClusterServiceUtils.addMasterTemporaryStateListener(clusterState -> {
            DataStream dataStream = (DataStream)clusterState.metadata().dataStreams().get(dataStreamName);
            if (dataStream == null) {
                return false;
            }
            return dataStream.getDataStreamIndices(failureStore).getIndices().size() == expectedSize;
        });
        ESIntegTestCase.safeAwait(listener);
        List<String> backingIndexNames = ESIntegTestCase.getDataStreamBackingIndexNames(dataStreamName, failureStore);
        ESIntegTestCase.assertEquals((String)Strings.format((String)"Retrieved number of data stream indices doesn't match expectation for data stream [%s]. Expected %d but got %s", (Object[])new Object[]{dataStreamName, expectedSize, backingIndexNames}), (long)expectedSize, (long)backingIndexNames.size());
        return backingIndexNames;
    }

    public static List<String> getDataStreamBackingIndexNames(String dataStreamName) {
        return ESIntegTestCase.getDataStreamBackingIndexNames(dataStreamName, false);
    }

    public static List<String> getDataStreamBackingIndexNames(String dataStreamName, boolean failureStore) {
        GetDataStreamAction.Response response = (GetDataStreamAction.Response)ESIntegTestCase.safeGet(ESIntegTestCase.client().execute((ActionType)GetDataStreamAction.INSTANCE, (ActionRequest)new GetDataStreamAction.Request(SAFE_AWAIT_TIMEOUT, new String[]{dataStreamName})));
        ESIntegTestCase.assertThat(response.getDataStreams().size(), Matchers.equalTo((Object)1));
        DataStream dataStream = ((GetDataStreamAction.Response.DataStreamInfo)response.getDataStreams().get(0)).getDataStream();
        ESIntegTestCase.assertThat(dataStream.getName(), Matchers.equalTo((Object)dataStreamName));
        return dataStream.getDataStreamIndices(failureStore).getIndices().stream().map(Index::getName).toList();
    }

    public void waitNoPendingTasksOnAll() throws Exception {
        ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)ESIntegTestCase.clusterAdmin().prepareHealth(TEST_REQUEST_TIMEOUT, new String[0]).setWaitForEvents(Priority.LANGUID).get());
        ESIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (Client client : ESIntegTestCase.clients()) {
                ClusterHealthResponse clusterHealth = (ClusterHealthResponse)((ClusterHealthRequestBuilder)client.admin().cluster().prepareHealth(TEST_REQUEST_TIMEOUT, new String[0]).setLocal(true)).get();
                ESIntegTestCase.assertThat("client " + String.valueOf(client) + " still has in flight fetch", clusterHealth.getNumberOfInFlightFetch(), Matchers.equalTo((Object)0));
                PendingClusterTasksResponse pendingTasks = (PendingClusterTasksResponse)client.execute(TransportPendingClusterTasksAction.TYPE, (ActionRequest)((PendingClusterTasksRequest)new PendingClusterTasksRequest(TEST_REQUEST_TIMEOUT).local(true))).get();
                ESIntegTestCase.assertThat("client " + String.valueOf(client) + " still has pending tasks " + String.valueOf(pendingTasks), pendingTasks.pendingTasks(), Matchers.emptyIterable());
                clusterHealth = (ClusterHealthResponse)((ClusterHealthRequestBuilder)client.admin().cluster().prepareHealth(TEST_REQUEST_TIMEOUT, new String[0]).setLocal(true)).get();
                ESIntegTestCase.assertThat("client " + String.valueOf(client) + " still has in flight fetch", clusterHealth.getNumberOfInFlightFetch(), Matchers.equalTo((Object)0));
            }
        }));
        ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)ESIntegTestCase.clusterAdmin().prepareHealth(TEST_REQUEST_TIMEOUT, new String[0]).setWaitForEvents(Priority.LANGUID).get());
    }

    public void assertResultsAndLogOnFailure(long expectedResults, SearchResponse searchResponse) {
        TotalHits totalHits = searchResponse.getHits().getTotalHits();
        if (totalHits.value != expectedResults || totalHits.relation != TotalHits.Relation.EQUAL_TO) {
            StringBuilder sb = new StringBuilder("search result contains [");
            String value = Long.toString(totalHits.value) + (totalHits.relation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO ? "+" : "");
            sb.append(value).append("] results. expected [").append(expectedResults).append("]");
            String failMsg = sb.toString();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                sb.append("\n-> _index: [").append(hit.getIndex()).append("] id [").append(hit.getId()).append("]");
            }
            this.logger.warn("{}", (Object)sb);
            ESIntegTestCase.fail((String)failMsg);
        }
    }

    public void allowNodes(String index, int n) {
        Settings build;
        assert (index != null);
        ESIntegTestCase.internalCluster().ensureAtLeastNumDataNodes(n);
        Settings.Builder builder = Settings.builder();
        if (n > 0) {
            ESIntegTestCase.getExcludeSettings(n, builder);
        }
        if (!(build = builder.build()).isEmpty()) {
            this.logger.debug("allowNodes: updating [{}]'s setting to [{}]", (Object)index, (Object)build.toDelimitedString(';'));
            ESIntegTestCase.updateIndexSettings(builder, index);
        }
    }

    public ClusterHealthStatus ensureGreen(String ... indices) {
        return this.ensureGreen(TimeValue.timeValueSeconds((long)30L), indices);
    }

    public ClusterHealthStatus ensureGreen(TimeValue timeout, String ... indices) {
        return this.ensureColor(ClusterHealthStatus.GREEN, timeout, false, indices);
    }

    public ClusterHealthStatus ensureYellow(String ... indices) {
        return this.ensureColor(ClusterHealthStatus.YELLOW, TimeValue.timeValueSeconds((long)30L), false, indices);
    }

    public ClusterHealthStatus ensureRed(String ... indices) {
        return this.ensureColor(ClusterHealthStatus.RED, TimeValue.timeValueSeconds((long)30L), false, indices);
    }

    public ClusterHealthStatus ensureYellowAndNoInitializingShards(String ... indices) {
        return this.ensureColor(ClusterHealthStatus.YELLOW, TimeValue.timeValueSeconds((long)30L), true, indices);
    }

    private ClusterHealthStatus ensureColor(ClusterHealthStatus clusterHealthStatus, TimeValue timeout, boolean waitForNoInitializingShards, String ... indices) {
        ClusterHealthResponse clusterHealthResponse;
        String color = clusterHealthStatus.name().toLowerCase(Locale.ROOT);
        String method = "ensure" + Strings.capitalize((String)color);
        ClusterHealthRequest healthRequest = ((ClusterHealthRequest)new ClusterHealthRequest(TEST_REQUEST_TIMEOUT, indices).masterNodeTimeout(timeout)).timeout(timeout).waitForStatus(clusterHealthStatus).waitForEvents(Priority.LANGUID).waitForNoRelocatingShards(true).waitForNoInitializingShards(waitForNoInitializingShards).waitForNodes(Integer.toString(ESIntegTestCase.cluster().size()));
        try {
            clusterHealthResponse = (ClusterHealthResponse)ESIntegTestCase.clusterAdmin().health(healthRequest).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("interrupted while waiting for health response", (Throwable)e);
            throw new AssertionError("interrupted while waiting for health response", e);
        }
        catch (ExecutionException e) {
            this.logger.error("failed to get health response", (Throwable)e);
            throw new AssertionError("failed to get health response", e);
        }
        if (clusterHealthResponse.isTimedOut()) {
            AtomicReference allocationExplainRef = new AtomicReference();
            AtomicReference clusterStateRef = new AtomicReference();
            AtomicReference pendingTasksRef = new AtomicReference();
            AtomicReference<Object> hotThreadsRef = new AtomicReference<Object>();
            PlainActionFuture detailsFuture = new PlainActionFuture();
            try (RefCountingListener listeners = new RefCountingListener((ActionListener)detailsFuture);){
                ESIntegTestCase.client().execute(TransportClusterAllocationExplainAction.TYPE, (ActionRequest)new ClusterAllocationExplainRequest(TEST_REQUEST_TIMEOUT), listeners.acquire(allocationExplainRef::set));
                ESIntegTestCase.clusterAdmin().prepareState(TEST_REQUEST_TIMEOUT).execute(listeners.acquire(clusterStateRef::set));
                ESIntegTestCase.client().execute(TransportPendingClusterTasksAction.TYPE, (ActionRequest)new PendingClusterTasksRequest(TEST_REQUEST_TIMEOUT), listeners.acquire(pendingTasksRef::set));
                try (StringWriter writer = new StringWriter();){
                    new HotThreads().busiestThreads(9999).ignoreIdleThreads(false).detect((Writer)writer);
                    hotThreadsRef.set(writer.toString());
                }
                catch (Exception e) {
                    this.logger.error("exception capturing hot threads", (Throwable)e);
                    hotThreadsRef.set("exception capturing hot threads: " + String.valueOf(e));
                }
            }
            try {
                detailsFuture.get(60L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.logger.error("failed to get full debug details within 60s timeout", (Throwable)e);
            }
            this.logger.info("{} timed out\nallocation explain:\n{}\ncluster state:\n{}\npending tasks:\n{}\nhot threads:\n{}\n", (Object)method, (Object)ESIntegTestCase.safeFormat((ClusterAllocationExplainResponse)allocationExplainRef.get(), r -> Strings.toString((ChunkedToXContent)r.getExplanation(), (boolean)true, (boolean)true)), (Object)ESIntegTestCase.safeFormat((ClusterStateResponse)clusterStateRef.get(), r -> r.getState().toString()), (Object)ESIntegTestCase.safeFormat((PendingClusterTasksResponse)pendingTasksRef.get(), r -> Strings.toString((ChunkedToXContent)r, (boolean)true, (boolean)true)), hotThreadsRef.get());
            ESIntegTestCase.fail((String)("timed out waiting for " + color + " state"));
        }
        ESIntegTestCase.assertThat("Expected at least " + String.valueOf(clusterHealthStatus) + " but got " + String.valueOf(clusterHealthResponse.getStatus()), clusterHealthResponse.getStatus().value(), Matchers.lessThanOrEqualTo((Comparable)Byte.valueOf(clusterHealthStatus.value())));
        this.logger.debug("indices {} are {}", (Object)(indices.length == 0 ? "[_all]" : indices), (Object)color);
        return clusterHealthResponse.getStatus();
    }

    private static <T> String safeFormat(@Nullable T value, Function<T, String> formatter) {
        return value == null ? null : formatter.apply(value);
    }

    public ClusterHealthStatus waitForRelocation() {
        return this.waitForRelocation(null);
    }

    public ClusterHealthStatus waitForRelocation(ClusterHealthStatus status) {
        ClusterHealthResponse actionGet;
        ClusterHealthRequest request = new ClusterHealthRequest(TEST_REQUEST_TIMEOUT, new String[0]).waitForNoRelocatingShards(true).waitForEvents(Priority.LANGUID);
        if (status != null) {
            request.waitForStatus(status);
        }
        if ((actionGet = (ClusterHealthResponse)ESIntegTestCase.clusterAdmin().health(request).actionGet()).isTimedOut()) {
            this.logger.info("waitForRelocation timed out (status={}), cluster state:\n{}\n{}", (Object)status, (Object)((ClusterStateResponse)ESIntegTestCase.clusterAdmin().prepareState(TEST_REQUEST_TIMEOUT).get()).getState(), (Object)ESIntegTestCase.getClusterPendingTasks());
            ESIntegTestCase.assertThat("timed out waiting for relocation", actionGet.isTimedOut(), Matchers.equalTo((Object)false));
        }
        if (status != null) {
            ESIntegTestCase.assertThat(actionGet.getStatus(), Matchers.equalTo((Object)status));
        }
        return actionGet.getStatus();
    }

    public static PendingClusterTasksResponse getClusterPendingTasks() {
        return ESIntegTestCase.getClusterPendingTasks(ESIntegTestCase.client());
    }

    public static PendingClusterTasksResponse getClusterPendingTasks(Client client) {
        try {
            return (PendingClusterTasksResponse)client.execute(TransportPendingClusterTasksAction.TYPE, (ActionRequest)new PendingClusterTasksRequest(TEST_REQUEST_TIMEOUT)).get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return (PendingClusterTasksResponse)ESIntegTestCase.fail(e);
        }
    }

    public static void awaitClusterState(Predicate<ClusterState> statePredicate) {
        ESIntegTestCase.awaitClusterState(ESIntegTestCase.internalCluster().getMasterName(), statePredicate);
    }

    public static void awaitClusterState(String viaNode, Predicate<ClusterState> statePredicate) {
        ClusterServiceUtils.awaitClusterState(statePredicate, ESIntegTestCase.internalCluster().getInstance(ClusterService.class, viaNode));
    }

    public static String getNodeId(String nodeName) {
        return ESIntegTestCase.internalCluster().getInstance(ClusterService.class, nodeName).localNode().getId();
    }

    public void waitForDocs(long numDocs, BackgroundIndexer indexer) throws Exception {
        long maxWaitTimeMs = Math.max(90000L, 200L * numDocs);
        ESIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            long lastKnownCount = indexer.totalIndexedDocs();
            if (lastKnownCount >= numDocs) {
                try {
                    long count = ESIntegTestCase.getTotalHitsAllIndices();
                    if (count < lastKnownCount) {
                        ESIntegTestCase.indicesAdmin().prepareRefresh(new String[0]).get();
                        count = ESIntegTestCase.getTotalHitsAllIndices();
                    }
                    lastKnownCount = count;
                }
                catch (Exception e) {
                    this.logger.debug("failed to executed count", (Throwable)e);
                    throw e;
                }
            }
            if (this.logger.isDebugEnabled()) {
                if (lastKnownCount < numDocs) {
                    this.logger.debug("[{}] docs indexed. waiting for [{}]", (Object)lastKnownCount, (Object)numDocs);
                } else {
                    this.logger.debug("[{}] docs visible for search (needed [{}])", (Object)lastKnownCount, (Object)numDocs);
                }
            }
            ESIntegTestCase.assertThat(lastKnownCount, Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(numDocs)));
        }), maxWaitTimeMs, TimeUnit.MILLISECONDS);
    }

    private static long getTotalHitsAllIndices() {
        return SearchResponseUtils.getTotalHitsValue(ESIntegTestCase.prepareSearch(new String[0]).setTrackTotalHits(true).setSize(0).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()));
    }

    public static SearchRequestBuilder prepareSearch(String ... indices) {
        return ESIntegTestCase.client().prepareSearch(indices);
    }

    public static List<PersistentTasksCustomMetadata.PersistentTask<?>> findTasks(ClusterState clusterState, String taskName) {
        return ESIntegTestCase.findTasks(clusterState, Set.of(taskName));
    }

    public static List<PersistentTasksCustomMetadata.PersistentTask<?>> findTasks(ClusterState clusterState, Set<String> taskNames) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)clusterState.metadata().custom("persistent_tasks");
        if (tasks == null) {
            return List.of();
        }
        return tasks.tasks().stream().filter(t -> taskNames.contains(t.getTaskName())).toList();
    }

    @Nullable
    public static DiscoveryNode waitAndGetHealthNode(InternalTestCluster internalCluster) {
        DiscoveryNode[] healthNode = new DiscoveryNode[1];
        ESIntegTestCase.waitUntil(() -> {
            ClusterState state = ((ClusterStateResponse)internalCluster.client().admin().cluster().prepareState(TEST_REQUEST_TIMEOUT).clear().setMetadata(true).setNodes(true).get()).getState();
            healthNode[0] = HealthNode.findHealthNode((ClusterState)state);
            return healthNode[0] != null;
        }, 15L, TimeUnit.SECONDS);
        return healthNode[0];
    }

    public void logClusterState() {
        this.logger.debug("cluster state:\n{}\n{}", (Object)((ClusterStateResponse)ESIntegTestCase.clusterAdmin().prepareState(TEST_REQUEST_TIMEOUT).get()).getState(), (Object)ESIntegTestCase.getClusterPendingTasks());
    }

    protected void ensureClusterSizeConsistency() {
        if (ESIntegTestCase.cluster() != null && ESIntegTestCase.cluster().size() > 0) {
            this.logger.trace("Check consistency for [{}] nodes", (Object)ESIntegTestCase.cluster().size());
            ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)ESIntegTestCase.clusterAdmin().prepareHealth(TEST_REQUEST_TIMEOUT, new String[0]).setWaitForNodes(Integer.toString(ESIntegTestCase.cluster().size())).get());
        }
    }

    protected void ensureClusterStateConsistency() throws IOException {
        if (ESIntegTestCase.cluster() != null && ESIntegTestCase.cluster().size() > 0) {
            this.doEnsureClusterStateConsistency(ESIntegTestCase.cluster().getNamedWriteableRegistry());
        }
    }

    protected final void doEnsureClusterStateConsistency(NamedWriteableRegistry namedWriteableRegistry) {
        PlainActionFuture future = new PlainActionFuture();
        ArrayList<SubscribableListener> localStates = new ArrayList<SubscribableListener>(ESIntegTestCase.cluster().size());
        for (Client client : ESIntegTestCase.cluster().getClients()) {
            localStates.add(SubscribableListener.newForked(l -> ((ClusterStateRequestBuilder)client.admin().cluster().prepareState(TEST_REQUEST_TIMEOUT).all().setLocal(true)).execute(l)));
        }
        try (RefCountingListener refCountingListener = new RefCountingListener((ActionListener)future);){
            SubscribableListener.newForked(l -> ESIntegTestCase.client().admin().cluster().prepareState(TEST_REQUEST_TIMEOUT).all().execute(l)).andThenAccept(masterStateResponse -> {
                byte[] masterClusterStateBytes = ClusterState.Builder.toBytes((ClusterState)masterStateResponse.getState());
                ClusterState masterClusterState = ClusterState.Builder.fromBytes((byte[])masterClusterStateBytes, null, (NamedWriteableRegistry)namedWriteableRegistry);
                Map<String, Object> masterStateMap = XContentTestUtils.convertToMap((ChunkedToXContent)masterClusterState);
                String masterId = masterClusterState.nodes().getMasterNodeId();
                for (SubscribableListener localStateListener : localStates) {
                    localStateListener.andThenAccept(localClusterStateResponse -> {
                        byte[] localClusterStateBytes = ClusterState.Builder.toBytes((ClusterState)localClusterStateResponse.getState());
                        ClusterState localClusterState = ClusterState.Builder.fromBytes((byte[])localClusterStateBytes, null, (NamedWriteableRegistry)namedWriteableRegistry);
                        Map<String, Object> localStateMap = XContentTestUtils.convertToMap((ChunkedToXContent)localClusterState);
                        if (masterClusterState.version() == localClusterState.version() && masterId.equals(localClusterState.nodes().getMasterNodeId())) {
                            try {
                                ESIntegTestCase.assertEquals((String)"cluster state UUID does not match", (Object)masterClusterState.stateUUID(), (Object)localClusterState.stateUUID());
                                ESIntegTestCase.assertNull((String)"cluster state JSON serialization does not match", (Object)XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder(masterStateMap, localStateMap));
                            }
                            catch (AssertionError error) {
                                this.logger.error("Cluster state from master:\n{}\nLocal cluster state:\n{}", (Object)masterClusterState.toString(), (Object)localClusterState.toString());
                                throw error;
                            }
                        }
                    }).addListener(refCountingListener.acquire());
                }
            }).addListener(refCountingListener.acquire());
        }
        ESIntegTestCase.safeGet(future);
    }

    protected void ensureClusterStateCanBeReadByNodeTool() throws IOException {
        if (ESIntegTestCase.cluster() != null && ESIntegTestCase.cluster().size() > 0) {
            Metadata loadedMetadata;
            Client masterClient = ESIntegTestCase.client();
            Metadata metadata = ((ClusterStateResponse)masterClient.admin().cluster().prepareState(TEST_REQUEST_TIMEOUT).all().get()).getState().metadata();
            Map serializationParams = Maps.newMapWithExpectedSize((int)2);
            serializationParams.put("binary", "true");
            serializationParams.put("context_mode", Metadata.CONTEXT_MODE_GATEWAY);
            ToXContent.MapParams serializationFormatParams = new ToXContent.MapParams(serializationParams);
            Map compareParams = Maps.newMapWithExpectedSize((int)2);
            compareParams.put("context_mode", Metadata.CONTEXT_MODE_GATEWAY);
            ToXContent.MapParams compareFormatParams = new ToXContent.MapParams(compareParams);
            Metadata metadataWithoutIndices = Metadata.builder((Metadata)metadata).removeAllIndices().build();
            XContentBuilder builder = SmileXContent.contentBuilder();
            builder.startObject();
            ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)metadataWithoutIndices).toXContent(builder, (ToXContent.Params)serializationFormatParams);
            builder.endObject();
            BytesReference originalBytes = BytesReference.bytes((XContentBuilder)builder);
            XContentBuilder compareBuilder = SmileXContent.contentBuilder();
            compareBuilder.startObject();
            ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)metadataWithoutIndices).toXContent(compareBuilder, (ToXContent.Params)compareFormatParams);
            compareBuilder.endObject();
            BytesReference compareOriginalBytes = BytesReference.bytes((XContentBuilder)compareBuilder);
            try (XContentParser parser = this.createParser(this.parserConfig().withRegistry(ElasticsearchNodeCommand.namedXContentRegistry), SmileXContent.smileXContent, originalBytes);){
                loadedMetadata = Metadata.fromXContent((XContentParser)parser);
            }
            builder = SmileXContent.contentBuilder();
            builder.startObject();
            ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)loadedMetadata).toXContent(builder, (ToXContent.Params)compareFormatParams);
            builder.endObject();
            BytesReference parsedBytes = BytesReference.bytes((XContentBuilder)builder);
            ESIntegTestCase.assertNull((String)("cluster state XContent serialization does not match, expected " + String.valueOf(XContentHelper.convertToMap((BytesReference)compareOriginalBytes, (boolean)false, (XContentType)XContentType.SMILE)) + " but got " + String.valueOf(XContentHelper.convertToMap((BytesReference)parsedBytes, (boolean)false, (XContentType)XContentType.SMILE))), (Object)XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder((Map)XContentHelper.convertToMap((BytesReference)compareOriginalBytes, (boolean)false, (XContentType)XContentType.SMILE).v2(), (Map)XContentHelper.convertToMap((BytesReference)parsedBytes, (boolean)false, (XContentType)XContentType.SMILE).v2()));
            for (IndexMetadata indexMetadata : metadata) {
                IndexMetadata loadedIndexMetadata;
                XContentBuilder builder2 = SmileXContent.contentBuilder();
                builder2.startObject();
                indexMetadata.toXContent(builder2, (ToXContent.Params)serializationFormatParams);
                builder2.endObject();
                BytesReference originalBytes2 = BytesReference.bytes((XContentBuilder)builder2);
                XContentBuilder compareBuilder2 = SmileXContent.contentBuilder();
                compareBuilder2.startObject();
                indexMetadata.toXContent(compareBuilder2, (ToXContent.Params)compareFormatParams);
                compareBuilder2.endObject();
                BytesReference compareOriginalBytes2 = BytesReference.bytes((XContentBuilder)compareBuilder2);
                try (XContentParser parser = this.createParser(this.parserConfig().withRegistry(ElasticsearchNodeCommand.namedXContentRegistry), SmileXContent.smileXContent, originalBytes2);){
                    loadedIndexMetadata = IndexMetadata.fromXContent((XContentParser)parser);
                }
                builder2 = SmileXContent.contentBuilder();
                builder2.startObject();
                loadedIndexMetadata.toXContent(builder2, (ToXContent.Params)compareFormatParams);
                builder2.endObject();
                BytesReference parsedBytes2 = BytesReference.bytes((XContentBuilder)builder2);
                ESIntegTestCase.assertNull((String)("cluster state XContent serialization does not match, expected " + String.valueOf(XContentHelper.convertToMap((BytesReference)compareOriginalBytes2, (boolean)false, (XContentType)XContentType.SMILE)) + " but got " + String.valueOf(XContentHelper.convertToMap((BytesReference)parsedBytes2, (boolean)false, (XContentType)XContentType.SMILE))), (Object)XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder((Map)XContentHelper.convertToMap((BytesReference)compareOriginalBytes2, (boolean)false, (XContentType)XContentType.SMILE).v2(), (Map)XContentHelper.convertToMap((BytesReference)parsedBytes2, (boolean)false, (XContentType)XContentType.SMILE).v2()));
            }
        }
    }

    private static void ensureClusterInfoServiceRunning() {
        if (ESIntegTestCase.isInternalCluster() && ESIntegTestCase.cluster().size() > 0) {
            ESIntegTestCase.refreshClusterInfo();
        }
    }

    public static void refreshClusterInfo() {
        ClusterInfoService clusterInfoService = ESIntegTestCase.internalCluster().getInstance(ClusterInfoService.class, ESIntegTestCase.internalCluster().getMasterName());
        if (clusterInfoService instanceof InternalClusterInfoService) {
            ClusterInfoServiceUtils.refresh((InternalClusterInfoService)clusterInfoService);
        }
    }

    protected ClusterHealthStatus ensureSearchable(String ... indices) {
        return this.ensureGreen(indices);
    }

    protected void ensureStableCluster(int nodeCount) {
        this.ensureStableCluster(nodeCount, TimeValue.timeValueSeconds((long)30L));
    }

    protected void ensureStableCluster(int nodeCount, TimeValue timeValue) {
        this.ensureStableCluster(nodeCount, timeValue, false, null);
    }

    protected void ensureStableCluster(int nodeCount, @Nullable String viaNode) {
        this.ensureStableCluster(nodeCount, TimeValue.timeValueSeconds((long)30L), false, viaNode);
    }

    protected void ensureStableCluster(int nodeCount, TimeValue timeValue, boolean local, @Nullable String viaNode) {
        if (viaNode == null) {
            viaNode = ESIntegTestCase.randomFrom(ESIntegTestCase.internalCluster().getNodeNames());
        }
        this.logger.debug("ensuring cluster is stable with [{}] nodes. access node: [{}]. timeout: [{}]", (Object)nodeCount, (Object)viaNode, (Object)timeValue);
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)((ClusterHealthRequestBuilder)ESIntegTestCase.client(viaNode).admin().cluster().prepareHealth(TEST_REQUEST_TIMEOUT, new String[0]).setWaitForEvents(Priority.LANGUID).setWaitForNodes(Integer.toString(nodeCount)).setTimeout(timeValue).setLocal(local)).setWaitForNoRelocatingShards(true).get();
        if (clusterHealthResponse.isTimedOut()) {
            ClusterStateResponse stateResponse = (ClusterStateResponse)ESIntegTestCase.client(viaNode).admin().cluster().prepareState(TEST_REQUEST_TIMEOUT).get();
            ESIntegTestCase.fail((String)("failed to reach a stable cluster of [" + nodeCount + "] nodes. Tried via [" + viaNode + "]. last cluster state:\n" + String.valueOf(stateResponse.getState())));
        }
        ESIntegTestCase.assertThat(clusterHealthResponse.isTimedOut(), Matchers.is((Object)false));
        this.ensureFullyConnectedCluster();
    }

    protected void ensureFullyConnectedCluster() {
        NetworkDisruption.ensureFullyConnectedCluster(ESIntegTestCase.internalCluster());
    }

    protected static IndexRequestBuilder prepareIndex(String index) {
        return ESIntegTestCase.client().prepareIndex(index);
    }

    protected final DocWriteResponse index(String index, XContentBuilder source) {
        return (DocWriteResponse)ESIntegTestCase.prepareIndex(index).setSource(source).get();
    }

    protected final DocWriteResponse index(String index, String id, Map<String, Object> source) {
        return (DocWriteResponse)ESIntegTestCase.prepareIndex(index).setId(id).setSource(source).get();
    }

    protected final DocWriteResponse index(String index, String id, XContentBuilder source) {
        return (DocWriteResponse)ESIntegTestCase.prepareIndex(index).setId(id).setSource(source).get();
    }

    protected final DocWriteResponse indexDoc(String index, String id, Object ... source) {
        return (DocWriteResponse)ESIntegTestCase.prepareIndex(index).setId(id).setSource(source).get();
    }

    protected final DocWriteResponse index(String index, String id, String source) {
        return (DocWriteResponse)ESIntegTestCase.prepareIndex(index).setId(id).setSource(source, XContentType.JSON).get();
    }

    protected final BroadcastResponse refresh(String ... indices) {
        this.waitForRelocation();
        BroadcastResponse actionGet = (BroadcastResponse)((RefreshRequestBuilder)ESIntegTestCase.indicesAdmin().prepareRefresh(indices).setIndicesOptions(IndicesOptions.STRICT_EXPAND_OPEN_HIDDEN_FORBID_CLOSED)).get();
        ElasticsearchAssertions.assertNoFailures((BaseBroadcastResponse)actionGet);
        return actionGet;
    }

    protected final void flushAndRefresh(String ... indices) {
        this.flush(indices);
        this.refresh(indices);
    }

    protected final BroadcastResponse flush(String ... indices) {
        this.waitForRelocation();
        BroadcastResponse actionGet = (BroadcastResponse)ESIntegTestCase.indicesAdmin().prepareFlush(indices).get();
        for (DefaultShardOperationFailedException failure : actionGet.getShardFailures()) {
            ESIntegTestCase.assertThat("unexpected flush failure " + failure.reason(), failure.status(), Matchers.equalTo((Object)RestStatus.SERVICE_UNAVAILABLE));
        }
        return actionGet;
    }

    protected BroadcastResponse forceMerge() {
        return this.forceMerge(ESIntegTestCase.randomBoolean());
    }

    protected BroadcastResponse forceMerge(boolean assertOneSegment) {
        this.waitForRelocation();
        BroadcastResponse actionGet = (BroadcastResponse)ESIntegTestCase.indicesAdmin().prepareForceMerge(new String[0]).setMaxNumSegments(1).get();
        ElasticsearchAssertions.assertNoFailures((BaseBroadcastResponse)actionGet);
        if (assertOneSegment) {
            List<ShardSegments> shardsWithMultipleSegments = this.getShardSegments(new String[0]).stream().filter(shardSegments -> shardSegments.getSegments().size() > 1).toList();
            ESIntegTestCase.assertTrue((String)("there are shards with multiple segments " + String.valueOf(shardsWithMultipleSegments)), (boolean)shardsWithMultipleSegments.isEmpty());
        }
        return actionGet;
    }

    protected List<ShardSegments> getShardSegments(String ... indices) {
        IndicesSegmentResponse indicesSegmentResponse = (IndicesSegmentResponse)ESIntegTestCase.indicesAdmin().prepareSegments(indices).get();
        return indicesSegmentResponse.getIndices().values().stream().flatMap(indexSegments -> indexSegments.getShards().values().stream()).flatMap(indexShardSegments -> Stream.of(indexShardSegments.shards())).toList();
    }

    protected static boolean indexExists(String index) {
        return ESIntegTestCase.indexExists(index, ESIntegTestCase.client());
    }

    public static boolean indexExists(String index, Client client) {
        GetIndexResponse getIndexResponse = (GetIndexResponse)((GetIndexRequestBuilder)((GetIndexRequestBuilder)client.admin().indices().prepareGetIndex().setIndices(new String[]{index})).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED)).get();
        return getIndexResponse.getIndices().length > 0;
    }

    protected final void enableAllocation(String ... indices) {
        ESIntegTestCase.updateIndexSettings(Settings.builder().put(EnableAllocationDecider.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.getKey(), "all"), indices);
    }

    protected final void disableAllocation(String ... indices) {
        ESIntegTestCase.updateIndexSettings(Settings.builder().put(EnableAllocationDecider.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.getKey(), "none"), indices);
    }

    protected static AdminClient admin() {
        return ESIntegTestCase.client().admin();
    }

    protected static ClusterAdminClient clusterAdmin() {
        return ESIntegTestCase.admin().cluster();
    }

    protected static IndicesAdminClient indicesAdmin() {
        return ESIntegTestCase.admin().indices();
    }

    public void indexRandom(boolean forceRefresh, String index, int numDocs) {
        IndexRequestBuilder[] builders = new IndexRequestBuilder[numDocs];
        for (int i = 0; i < builders.length; ++i) {
            builders[i] = ESIntegTestCase.prepareIndex(index).setSource(new Object[]{"field", "value"});
        }
        this.indexRandom(forceRefresh, Arrays.asList(builders));
    }

    public void indexRandom(boolean forceRefresh, IndexRequestBuilder ... builders) {
        this.indexRandom(forceRefresh, Arrays.asList(builders));
    }

    public void indexRandom(boolean forceRefresh, boolean dummyDocuments, IndexRequestBuilder ... builders) {
        this.indexRandom(forceRefresh, dummyDocuments, Arrays.asList(builders));
    }

    public void indexRandom(boolean forceRefresh, List<IndexRequestBuilder> builders) {
        this.indexRandom(forceRefresh, forceRefresh, builders);
    }

    public void indexRandom(boolean forceRefresh, boolean dummyDocuments, List<IndexRequestBuilder> builders) {
        this.indexRandom(forceRefresh, dummyDocuments, true, true, builders);
    }

    public void indexRandom(boolean forceRefresh, boolean dummyDocuments, boolean maybeFlush, List<IndexRequestBuilder> builders) {
        this.indexRandom(forceRefresh, dummyDocuments, maybeFlush, true, builders);
    }

    public void indexRandom(boolean forceRefresh, boolean dummyDocuments, boolean maybeFlush, boolean maybeForceMerge, List<IndexRequestBuilder> builders) {
        Random random = ESIntegTestCase.random();
        HashSet<String> indices = new HashSet<String>();
        builders = new ArrayList<IndexRequestBuilder>(builders);
        for (IndexRequestBuilder builder : builders) {
            indices.add(builder.getIndex());
        }
        HashSet<List<String>> bogusIds = new HashSet<List<String>>();
        if (random.nextBoolean() && !builders.isEmpty() && dummyDocuments) {
            builders = new ArrayList<IndexRequestBuilder>(builders);
            int numBogusDocs = ESIntegTestCase.scaledRandomIntBetween(1, builders.size() * 2);
            int unicodeLen = ESIntegTestCase.between(1, 10);
            for (int i = 0; i < numBogusDocs; ++i) {
                String string = "bogus_doc_" + ESIntegTestCase.randomRealisticUnicodeOfLength(unicodeLen) + this.dummmyDocIdGenerator.incrementAndGet();
                String index = (String)RandomPicks.randomFrom((Random)random, indices);
                bogusIds.add(Arrays.asList(index, string));
                builders.add(ESIntegTestCase.prepareIndex(index).setId(string).setSource("{}", XContentType.JSON).setRouting(string));
            }
        }
        Collections.shuffle(builders, ESIntegTestCase.random());
        ArrayList<CountDownLatch> inFlightAsyncOperations = new ArrayList<CountDownLatch>();
        String[] indicesArray = indices.toArray(new String[0]);
        if (builders.size() < 300 ? ESIntegTestCase.frequently() : builders.size() < 3000 && ESIntegTestCase.rarely()) {
            if (ESIntegTestCase.frequently()) {
                this.logger.info("Index [{}] docs async: [{}] bulk: [{}]", (Object)builders.size(), (Object)true, (Object)false);
                for (IndexRequestBuilder indexRequestBuilder : builders) {
                    indexRequestBuilder.execute(new LatchedActionListener(ActionListener.noop(), ESIntegTestCase.newLatch(inFlightAsyncOperations)).delegateResponse((l, e) -> ESIntegTestCase.fail(e)));
                    this.postIndexAsyncActions(indicesArray, inFlightAsyncOperations, maybeFlush, maybeForceMerge);
                }
            } else {
                this.logger.info("Index [{}] docs async: [{}] bulk: [{}]", (Object)builders.size(), (Object)false, (Object)false);
                for (IndexRequestBuilder indexRequestBuilder : builders) {
                    indexRequestBuilder.get();
                    this.postIndexAsyncActions(indicesArray, inFlightAsyncOperations, maybeFlush, maybeForceMerge);
                }
            }
        } else {
            List partition = CollectionUtils.eagerPartition(builders, (int)Math.min(1000, Math.max(1, (int)((double)builders.size() * ESIntegTestCase.randomDouble()))));
            this.logger.info("Index [{}] docs async: [{}] bulk: [{}] partitions [{}]", (Object)builders.size(), (Object)false, (Object)true, (Object)partition.size());
            for (List segmented : partition) {
                BulkRequestBuilder bulkBuilder = ESIntegTestCase.client().prepareBulk();
                for (IndexRequestBuilder indexRequestBuilder : segmented) {
                    bulkBuilder.add(indexRequestBuilder);
                }
                BulkResponse actionGet = (BulkResponse)bulkBuilder.get();
                ESIntegTestCase.assertThat(actionGet.hasFailures() ? actionGet.buildFailureMessage() : "", actionGet.hasFailures(), Matchers.equalTo((Object)false));
            }
        }
        for (CountDownLatch countDownLatch : inFlightAsyncOperations) {
            ESIntegTestCase.safeAwait(countDownLatch, TEST_REQUEST_TIMEOUT);
        }
        if (!bogusIds.isEmpty()) {
            for (List list : bogusIds) {
                ESIntegTestCase.assertEquals((String)("failed to delete a dummy doc [" + (String)list.get(0) + "][" + (String)list.get(1) + "]"), (Object)DocWriteResponse.Result.DELETED, (Object)((DeleteResponse)ESIntegTestCase.client().prepareDelete((String)list.get(0), (String)list.get(1)).setRouting((String)list.get(1)).get()).getResult());
            }
        }
        if (forceRefresh) {
            ElasticsearchAssertions.assertNoFailures((BaseBroadcastResponse)((RefreshRequestBuilder)ESIntegTestCase.indicesAdmin().prepareRefresh(indicesArray).setIndicesOptions(IndicesOptions.lenientExpandOpen())).get());
        }
    }

    public static void disableIndexBlock(String index, String block) {
        ESIntegTestCase.updateIndexSettings(Settings.builder().put(block, false), index);
    }

    public static void enableIndexBlock(String index, String block) {
        if (IndexMetadata.APIBlock.fromSetting((String)block) == IndexMetadata.APIBlock.READ_ONLY_ALLOW_DELETE || ESIntegTestCase.randomBoolean()) {
            ESIntegTestCase.updateIndexSettings(Settings.builder().put(block, true), index);
        } else {
            ESIntegTestCase.indicesAdmin().prepareAddBlock(IndexMetadata.APIBlock.fromSetting((String)block), new String[]{index}).get();
        }
    }

    public static void setClusterReadOnly(boolean value) {
        ESIntegTestCase.updateClusterSettings(value ? Settings.builder().put(Metadata.SETTING_READ_ONLY_SETTING.getKey(), value) : Settings.builder().putNull(Metadata.SETTING_READ_ONLY_SETTING.getKey()));
    }

    public static void updateClusterSettings(Settings.Builder persistentSettings) {
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)ESIntegTestCase.clusterAdmin().prepareUpdateSettings(TEST_REQUEST_TIMEOUT, TEST_REQUEST_TIMEOUT).setPersistentSettings(persistentSettings).get());
    }

    private static CountDownLatch newLatch(List<CountDownLatch> latches) {
        CountDownLatch l = new CountDownLatch(1);
        latches.add(l);
        return l;
    }

    private void postIndexAsyncActions(String[] indices, List<CountDownLatch> inFlightAsyncOperations, boolean maybeFlush, boolean maybeForceMerge) {
        if (ESIntegTestCase.rarely()) {
            if (ESIntegTestCase.rarely()) {
                ((RefreshRequestBuilder)ESIntegTestCase.indicesAdmin().prepareRefresh(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen())).execute((ActionListener)new LatchedActionListener(ActionListener.noop(), ESIntegTestCase.newLatch(inFlightAsyncOperations)));
            } else if (maybeFlush && ESIntegTestCase.rarely()) {
                ((FlushRequestBuilder)ESIntegTestCase.indicesAdmin().prepareFlush(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen())).execute((ActionListener)new LatchedActionListener(ActionListener.noop(), ESIntegTestCase.newLatch(inFlightAsyncOperations)));
            } else if (maybeForceMerge && ESIntegTestCase.rarely()) {
                ((ForceMergeRequestBuilder)ESIntegTestCase.indicesAdmin().prepareForceMerge(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen())).setMaxNumSegments(ESIntegTestCase.between(1, 10)).setFlush(maybeFlush && ESIntegTestCase.randomBoolean()).execute((ActionListener)new LatchedActionListener(ActionListener.noop(), ESIntegTestCase.newLatch(inFlightAsyncOperations)));
            }
        }
        while (inFlightAsyncOperations.size() > 150) {
            ESIntegTestCase.safeAwait(inFlightAsyncOperations.remove(ESIntegTestCase.between(0, inFlightAsyncOperations.size() - 1)), TimeValue.timeValueSeconds((long)60L));
        }
    }

    public static void clearScroll(String ... scrollIds) {
        ClearScrollResponse clearResponse = (ClearScrollResponse)ESIntegTestCase.client().prepareClearScroll().setScrollIds(Arrays.asList(scrollIds)).get();
        ESIntegTestCase.assertThat(clearResponse.isSucceeded(), Matchers.equalTo((Object)true));
    }

    private static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> annotationClass) {
        if (clazz == Object.class || clazz == ESIntegTestCase.class) {
            return null;
        }
        A annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return ESIntegTestCase.getAnnotation(clazz.getSuperclass(), annotationClass);
    }

    private Scope getCurrentClusterScope() {
        return ESIntegTestCase.getCurrentClusterScope(((Object)((Object)this)).getClass());
    }

    private static Scope getCurrentClusterScope(Class<?> clazz) {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(clazz, ClusterScope.class);
        return annotation == null ? Scope.SUITE : annotation.scope();
    }

    private boolean getSupportsDedicatedMasters() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null ? true : annotation.supportsDedicatedMasters();
    }

    private boolean getAutoManageMasterNodes() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null ? true : annotation.autoManageMasterNodes();
    }

    private int getNumDataNodes() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null ? -1 : annotation.numDataNodes();
    }

    private int getMinNumDataNodes() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null || annotation.minNumDataNodes() == -1 ? 1 : annotation.minNumDataNodes();
    }

    private int getMaxNumDataNodes() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null || annotation.maxNumDataNodes() == -1 ? InternalTestCluster.DEFAULT_MAX_NUM_DATA_NODES : annotation.maxNumDataNodes();
    }

    private int getNumClientNodes() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null ? -1 : annotation.numClientNodes();
    }

    protected Settings nodeSettings(int nodeOrdinal, Settings otherSettings) {
        Settings.Builder builder = Settings.builder().put(DestructiveOperations.REQUIRES_NAME_SETTING.getKey(), false).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), "1b").put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), "1b").put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), "1b").put(IndicesQueryCache.INDICES_QUERIES_CACHE_ALL_SEGMENTS_SETTING.getKey(), nodeOrdinal % 2 == 0).put(IndicesStore.INDICES_STORE_DELETE_SHARD_TIMEOUT.getKey(), new TimeValue(1L, TimeUnit.SECONDS)).put(SearchService.LOW_LEVEL_CANCELLATION_SETTING.getKey(), ESIntegTestCase.randomBoolean()).putList(SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.getKey(), new String[0]).putList(DiscoveryModule.DISCOVERY_SEED_PROVIDERS_SETTING.getKey(), new String[]{"file"}).put(TransportSearchAction.DEFAULT_PRE_FILTER_SHARD_SIZE.getKey(), ESIntegTestCase.randomFrom(1, 2, 128).intValue());
        if (ESIntegTestCase.randomBoolean()) {
            builder.put(IndexingPressure.SPLIT_BULK_LOW_WATERMARK.getKey(), ESIntegTestCase.randomFrom("256B", "512B"));
            builder.put(IndexingPressure.SPLIT_BULK_LOW_WATERMARK_SIZE.getKey(), "1KB");
            builder.put(IndexingPressure.SPLIT_BULK_HIGH_WATERMARK.getKey(), ESIntegTestCase.randomFrom("1KB", "16KB", "64KB"));
            builder.put(IndexingPressure.SPLIT_BULK_HIGH_WATERMARK_SIZE.getKey(), "256B");
        }
        builder.put(ThreadPoolMergeScheduler.USE_THREAD_POOL_MERGE_SCHEDULER_SETTING.getKey(), ESIntegTestCase.randomBoolean());
        return builder.build();
    }

    protected Path nodeConfigPath(int nodeOrdinal) {
        return null;
    }

    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Collections.emptyList();
    }

    protected TestCluster buildTestCluster(Scope scope, long seed) throws IOException {
        int minNumDataNodes;
        int maxNumDataNodes;
        String nodePrefix = switch (scope) {
            default -> throw new IncompatibleClassChangeError();
            case Scope.TEST -> TEST_CLUSTER_NODE_PREFIX;
            case Scope.SUITE -> SUITE_CLUSTER_NODE_PREFIX;
        };
        boolean supportsDedicatedMasters = this.getSupportsDedicatedMasters();
        int numDataNodes = this.getNumDataNodes();
        if (numDataNodes >= 0) {
            minNumDataNodes = maxNumDataNodes = numDataNodes;
        } else {
            minNumDataNodes = this.getMinNumDataNodes();
            maxNumDataNodes = this.getMaxNumDataNodes();
        }
        Collection<Class<? extends Plugin>> mockPlugins = this.getMockPlugins();
        NodeConfigurationSource nodeConfigurationSource = this.getNodeConfigSource();
        if (this.addMockTransportService()) {
            ArrayList<Class<? extends Plugin>> mocks = new ArrayList<Class<? extends Plugin>>(mockPlugins);
            if (!mockPlugins.contains(ESIntegTestCase.getTestTransportPlugin())) {
                mocks.add(ESIntegTestCase.getTestTransportPlugin());
            }
            mockPlugins = mocks;
        }
        return new InternalTestCluster(seed, ESIntegTestCase.createTempDir(), supportsDedicatedMasters, this.getAutoManageMasterNodes(), minNumDataNodes, maxNumDataNodes, InternalTestCluster.clusterName(scope.name(), seed) + "-cluster", nodeConfigurationSource, this.getNumClientNodes(), nodePrefix, mockPlugins, this.getClientWrapper(), this.forbidPrivateIndexSettings(), this.forceSingleDataPath(), this.autoManageVotingExclusions(), TEST_ENTITLEMENTS::addEntitledNodePaths);
    }

    private NodeConfigurationSource getNodeConfigSource() {
        boolean enableConcurrentSearch;
        final Settings.Builder initialNodeSettings = Settings.builder();
        if (this.addMockTransportService()) {
            initialNodeSettings.put("transport.type", ESIntegTestCase.getTestTransportType());
        }
        if (enableConcurrentSearch = this.enableConcurrentSearch()) {
            initialNodeSettings.put(SearchService.MINIMUM_DOCS_PER_SLICE.getKey(), 1);
        } else {
            initialNodeSettings.put(SearchService.QUERY_PHASE_PARALLEL_COLLECTION_ENABLED.getKey(), false);
        }
        return new NodeConfigurationSource(){

            @Override
            public Settings nodeSettings(int nodeOrdinal, Settings otherSettings) {
                return Settings.builder().put(initialNodeSettings.build()).put(ESIntegTestCase.this.nodeSettings(nodeOrdinal, otherSettings)).build();
            }

            @Override
            public Path nodeConfigPath(int nodeOrdinal) {
                return ESIntegTestCase.this.nodeConfigPath(nodeOrdinal);
            }

            @Override
            public Collection<Class<? extends Plugin>> nodePlugins() {
                if (enableConcurrentSearch) {
                    ArrayList<Class<? extends Plugin>> plugins = new ArrayList<Class<? extends Plugin>>(ESIntegTestCase.this.nodePlugins());
                    plugins.add(ConcurrentSearchTestPlugin.class);
                    return plugins;
                }
                return ESIntegTestCase.this.nodePlugins();
            }
        };
    }

    protected boolean addMockTransportService() {
        return true;
    }

    protected boolean enableConcurrentSearch() {
        return true;
    }

    protected boolean addMockHttpTransport() {
        return true;
    }

    protected boolean addMockInternalEngine() {
        return true;
    }

    protected boolean addMockFSIndexStore() {
        return true;
    }

    protected Function<Client, Client> getClientWrapper() {
        return Function.identity();
    }

    protected Collection<Class<? extends Plugin>> getMockPlugins() {
        ArrayList<Class<Object>> mocks = new ArrayList<Class<Object>>();
        if (MOCK_MODULES_ENABLED && ESIntegTestCase.randomBoolean()) {
            if (ESIntegTestCase.randomBoolean() && this.addMockTransportService()) {
                mocks.add(MockTransportService.TestPlugin.class);
            }
            if (this.addMockFSIndexStore() && ESIntegTestCase.randomBoolean()) {
                mocks.add(MockFSIndexStore.TestPlugin.class);
            }
            if (ESIntegTestCase.randomBoolean()) {
                mocks.add(NodeMocksPlugin.class);
            }
            if (this.addMockInternalEngine() && ESIntegTestCase.randomBoolean()) {
                mocks.add(MockEngineFactoryPlugin.class);
            }
            if (ESIntegTestCase.randomBoolean()) {
                mocks.add(MockSearchService.TestPlugin.class);
            }
            if (ESIntegTestCase.randomBoolean()) {
                mocks.add(MockFieldFilterPlugin.class);
            }
        }
        if (this.addMockTransportService()) {
            mocks.add(ESIntegTestCase.getTestTransportPlugin());
        }
        if (this.addMockHttpTransport()) {
            mocks.add(MockHttpTransport.TestPlugin.class);
        }
        mocks.add(TestSeedPlugin.class);
        mocks.add(AssertActionNamePlugin.class);
        mocks.add(MockScriptService.TestPlugin.class);
        return Collections.unmodifiableList(mocks);
    }

    public static Path randomRepoPath() {
        if (currentCluster instanceof InternalTestCluster) {
            return ESIntegTestCase.randomRepoPath(((InternalTestCluster)currentCluster).getDefaultSettings());
        }
        throw new UnsupportedOperationException("unsupported cluster type");
    }

    public static Path randomRepoPath(Settings settings) {
        Path path;
        Environment environment = TestEnvironment.newEnvironment(settings);
        Path[] repoFiles = environment.repoDirs();
        assert (repoFiles.length > 0);
        while (Files.exists(path = repoFiles[0].resolve(ESIntegTestCase.randomAlphaOfLength(10)), new LinkOption[0])) {
        }
        return path;
    }

    protected NumShards getNumShards(String index) {
        Metadata metadata = ((ClusterStateResponse)ESIntegTestCase.clusterAdmin().prepareState(TEST_REQUEST_TIMEOUT).get()).getState().metadata();
        ESIntegTestCase.assertThat(metadata.hasIndex(index), Matchers.equalTo((Object)true));
        int numShards = Integer.valueOf(metadata.index(index).getSettings().get("index.number_of_shards"));
        int numReplicas = Integer.valueOf(metadata.index(index).getSettings().get("index.number_of_replicas"));
        return new NumShards(numShards, numReplicas);
    }

    public Set<String> assertAllShardsOnNodes(String index, String ... pattern) {
        HashSet<String> nodes = new HashSet<String>();
        ClusterState clusterState = ((ClusterStateResponse)ESIntegTestCase.clusterAdmin().prepareState(TEST_REQUEST_TIMEOUT).get()).getState();
        for (IndexRoutingTable indexRoutingTable : clusterState.routingTable()) {
            for (int shardId = 0; shardId < indexRoutingTable.size(); ++shardId) {
                IndexShardRoutingTable indexShard = indexRoutingTable.shard(shardId);
                for (int copy = 0; copy < indexShard.size(); ++copy) {
                    ShardRouting shardRouting = indexShard.shard(copy);
                    if (shardRouting.currentNodeId() == null || !index.equals(shardRouting.getIndexName())) continue;
                    String name = clusterState.nodes().get(shardRouting.currentNodeId()).getName();
                    nodes.add(name);
                    ESIntegTestCase.assertThat("Allocated on new node: " + name, Regex.simpleMatch((String[])pattern, (String)name), Matchers.is((Object)true));
                }
            }
        }
        return nodes;
    }

    public void assertSortedSegments(String indexName, Sort expectedIndexSort) {
        IndicesSegmentResponse segmentResponse = (IndicesSegmentResponse)ESIntegTestCase.indicesAdmin().prepareSegments(new String[]{indexName}).get();
        IndexSegments indexSegments = (IndexSegments)segmentResponse.getIndices().get(indexName);
        for (IndexShardSegments indexShardSegments : indexSegments.getShards().values()) {
            for (ShardSegments shardSegments : indexShardSegments.shards()) {
                for (Segment segment : shardSegments) {
                    ESIntegTestCase.assertThat(expectedIndexSort, Matchers.equalTo((Object)segment.getSegmentSort()));
                }
            }
        }
    }

    private static boolean runTestScopeLifecycle() {
        return INSTANCE == null;
    }

    @Before
    public final void setupTestCluster() throws Exception {
        if (ESIntegTestCase.runTestScopeLifecycle()) {
            this.printTestMessage("setting up");
            this.beforeInternal();
            this.printTestMessage("all set up");
        }
    }

    @After
    public final void cleanUpCluster() throws Exception {
        if (ESIntegTestCase.isInternalCluster()) {
            ESIntegTestCase.internalCluster().setBootstrapMasterNodeIndex(-1);
        }
        super.ensureAllSearchContextsReleased();
        if (ESIntegTestCase.runTestScopeLifecycle()) {
            this.printTestMessage("cleaning up after");
            this.afterInternal(false);
            this.printTestMessage("cleaned up after");
        }
    }

    @Override
    protected boolean enableBigArraysReleasedCheck() {
        return !ESIntegTestCase.isSuiteScopedTest(ESIntegTestCase.getTestClass());
    }

    @AfterClass
    public static void afterClass() throws Exception {
        try {
            if (ESIntegTestCase.runTestScopeLifecycle()) {
                ESIntegTestCase.clearClusters();
            } else {
                INSTANCE.printTestMessage("cleaning up after");
                INSTANCE.afterInternal(true);
                MockBigArrays.ensureAllArraysAreReleased();
                ESIntegTestCase.checkStaticState();
            }
        }
        finally {
            SUITE_SEED = null;
            currentCluster = null;
            INSTANCE = null;
        }
        ESIntegTestCase.awaitGlobalNettyThreadsFinish();
    }

    static void awaitGlobalNettyThreadsFinish() throws Exception {
        ESIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> ESIntegTestCase.assertEquals((long)0L, (long)GlobalEventExecutor.INSTANCE.pendingTasks())));
        try {
            ThreadDeathWatcher.awaitInactivity((long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static void initializeSuiteScope() throws Exception {
        Class targetClass = ESIntegTestCase.getTestClass();
        assert (INSTANCE == null);
        if (ESIntegTestCase.isSuiteScopedTest(targetClass)) {
            INSTANCE = (ESIntegTestCase)((Object)targetClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            boolean success = false;
            try {
                INSTANCE.printTestMessage("setup");
                INSTANCE.beforeInternal();
                INSTANCE.setupSuiteScopeCluster();
                success = true;
            }
            finally {
                if (!success) {
                    ESIntegTestCase.afterClass();
                }
            }
        } else {
            INSTANCE = null;
        }
    }

    protected String routingKeyForShard(String index, int shard) {
        return ESIntegTestCase.internalCluster().routingKeyForShard(ESIntegTestCase.resolveIndex(index), shard, ESIntegTestCase.random());
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        if (ESIntegTestCase.isInternalCluster() && ESIntegTestCase.cluster().size() > 0) {
            return ESIntegTestCase.internalCluster().getInstance(NamedXContentRegistry.class);
        }
        return new NamedXContentRegistry(ClusterModule.getNamedXWriteables());
    }

    protected boolean forbidPrivateIndexSettings() {
        return true;
    }

    protected boolean forceSingleDataPath() {
        return false;
    }

    protected static synchronized RestClient getRestClient() {
        if (restClient == null) {
            restClient = ESIntegTestCase.createRestClient();
        }
        return restClient;
    }

    protected static RestClient createRestClient() {
        return ESIntegTestCase.createRestClient(null, "http");
    }

    protected static RestClient createRestClient(String node) {
        return ESIntegTestCase.createRestClient(((NodesInfoResponse)ESIntegTestCase.client(node).admin().cluster().prepareNodesInfo(new String[]{"_local"}).get()).getNodes(), null, "http");
    }

    protected static RestClient createRestClient(RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback, String protocol) {
        NodesInfoResponse nodesInfoResponse = (NodesInfoResponse)ESIntegTestCase.clusterAdmin().prepareNodesInfo(new String[0]).get();
        ESIntegTestCase.assertFalse((boolean)nodesInfoResponse.hasFailures());
        return ESIntegTestCase.createRestClient(nodesInfoResponse.getNodes(), httpClientConfigCallback, protocol);
    }

    protected static RestClient createRestClient(List<NodeInfo> nodes, RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback, String protocol) {
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
        for (NodeInfo node : nodes) {
            if (node.getInfo(HttpInfo.class) == null) continue;
            TransportAddress publishAddress = ((HttpInfo)node.getInfo(HttpInfo.class)).address().publishAddress();
            InetSocketAddress address = publishAddress.address();
            hosts.add(new HttpHost(NetworkAddress.format((InetAddress)address.getAddress()), address.getPort(), protocol));
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[hosts.size()]));
        if (httpClientConfigCallback != null) {
            builder.setHttpClientConfigCallback(httpClientConfigCallback);
        }
        return builder.build();
    }

    protected void setupSuiteScopeCluster() throws Exception {
    }

    protected boolean autoManageVotingExclusions() {
        return true;
    }

    private static boolean isSuiteScopedTest(Class<?> clazz) {
        return clazz.getAnnotation(SuiteScopeTestCase.class) != null;
    }

    public static Index resolveIndex(String index) {
        GetIndexResponse getIndexResponse = (GetIndexResponse)((GetIndexRequestBuilder)ESIntegTestCase.indicesAdmin().prepareGetIndex().setIndices(new String[]{index})).get();
        ESIntegTestCase.assertTrue((String)("index " + index + " not found"), (boolean)getIndexResponse.getSettings().containsKey(index));
        String uuid = ((Settings)getIndexResponse.getSettings().get(index)).get("index.uuid");
        return new Index(index, uuid);
    }

    public static String resolveCustomDataPath(String index) {
        GetIndexResponse getIndexResponse = (GetIndexResponse)((GetIndexRequestBuilder)ESIntegTestCase.indicesAdmin().prepareGetIndex().setIndices(new String[]{index})).get();
        ESIntegTestCase.assertTrue((String)("index " + index + " not found"), (boolean)getIndexResponse.getSettings().containsKey(index));
        return ((Settings)getIndexResponse.getSettings().get(index)).get("index.data_path");
    }

    public static boolean inFipsJvm() {
        return Boolean.parseBoolean(System.getProperty("tests.fips.enabled"));
    }

    protected void restartNodesOnBrokenClusterState(ClusterState.Builder clusterStateBuilder) throws Exception {
        final Map lucenePersistedStateFactories = Stream.of(ESIntegTestCase.internalCluster().getNodeNames()).collect(Collectors.toMap(Function.identity(), nodeName -> ESIntegTestCase.internalCluster().getInstance(PersistedClusterStateService.class, (String)nodeName)));
        final ClusterState clusterState = clusterStateBuilder.build();
        ESIntegTestCase.internalCluster().fullRestart(new InternalTestCluster.RestartCallback(){

            @Override
            public Settings onNodeStopped(String nodeName) throws Exception {
                PersistedClusterStateService lucenePersistedStateFactory = (PersistedClusterStateService)lucenePersistedStateFactories.get(nodeName);
                try (PersistedClusterStateService.Writer writer = lucenePersistedStateFactory.createWriter();){
                    writer.writeFullStateAndCommit(clusterState.term(), clusterState);
                }
                return super.onNodeStopped(nodeName);
            }
        });
    }

    protected static Releasable fullyAllocateCircuitBreakerOnNode(String targetNode, String breakerName) {
        CircuitBreaker circuitBreaker = ESIntegTestCase.internalCluster().getInstance(CircuitBreakerService.class, targetNode).getBreaker(breakerName);
        long totalAllocated = ESIntegTestCase.fullyAllocate(circuitBreaker);
        return () -> circuitBreaker.addWithoutBreaking(-totalAllocated);
    }

    private static long fullyAllocate(CircuitBreaker circuitBreaker) {
        long allocationSize;
        block3: {
            allocationSize = 1L;
            long totalAllocated = 0L;
            while (true) {
                try {
                    circuitBreaker.addEstimateBytesAndMaybeBreak(allocationSize, "test");
                    totalAllocated += allocationSize;
                }
                catch (CircuitBreakingException e) {
                    circuitBreaker.addWithoutBreaking(allocationSize);
                    break block3;
                }
                assert (0L <= (allocationSize <<= 1));
            }
        }
        return totalAllocated += allocationSize;
    }

    static {
        restClient = null;
        clusters = new IdentityHashMap();
        INSTANCE = null;
        SUITE_SEED = null;
    }

    public static enum Scope {
        SUITE,
        TEST;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ClusterScope {
        public Scope scope() default Scope.SUITE;

        public int numDataNodes() default -1;

        public int minNumDataNodes() default -1;

        public int maxNumDataNodes() default -1;

        public boolean supportsDedicatedMasters() default true;

        public boolean autoManageMasterNodes() default true;

        public int numClientNodes() default -1;
    }

    public static final class TestSeedPlugin
    extends Plugin {
        public List<Setting<?>> getSettings() {
            return Collections.singletonList(INDEX_TEST_SEED_SETTING);
        }
    }

    public static final class AssertActionNamePlugin
    extends Plugin
    implements NetworkPlugin {
        public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
            return Arrays.asList(new TransportInterceptor(){

                public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, Executor executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
                    if (!TransportService.isValidActionName((String)action)) {
                        throw new IllegalArgumentException("invalid action name [" + action + "] must start with one of: " + String.valueOf(TransportService.VALID_ACTION_PREFIXES));
                    }
                    return actualHandler;
                }
            });
        }
    }

    protected static class NumShards {
        public final int numPrimaries;
        public final int numReplicas;
        public final int totalNumShards;
        public final int dataCopies;

        private NumShards(int numPrimaries, int numReplicas) {
            this.numPrimaries = numPrimaries;
            this.numReplicas = numReplicas;
            this.dataCopies = numReplicas + 1;
            this.totalNumShards = numPrimaries * this.dataCopies;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Target(value={ElementType.TYPE})
    public static @interface SuiteScopeTestCase {
    }
}

