/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class CorruptionUtils {
    private static final Logger logger = LogManager.getLogger(CorruptionUtils.class);

    private CorruptionUtils() {
    }

    public static void corruptIndex(Random random, Path indexPath, boolean corruptSegments) throws IOException {
        Path[] filesToCorrupt = (Path[])Files.walk(indexPath, new FileVisitOption[0]).filter(p -> {
            boolean segmentFile;
            String name = p.getFileName().toString();
            boolean bl = segmentFile = name.startsWith("segments_") || name.endsWith(".si");
            return Files.isRegularFile(p, new LinkOption[0]) && !name.startsWith("extra") && !"write.lock".equals(name) && (corruptSegments ? segmentFile : !segmentFile);
        }).toArray(Path[]::new);
        CorruptionUtils.corruptFile(random, filesToCorrupt);
    }

    public static void corruptFile(Random random, Path ... files) throws IOException {
        Assert.assertTrue((String)"files must be non-empty", (files.length > 0 ? 1 : 0) != 0);
        Path fileToCorrupt = (Path)RandomPicks.randomFrom((Random)random, (Object[])files);
        Assert.assertTrue((String)(String.valueOf(fileToCorrupt) + " is not a file"), (boolean)Files.isRegularFile(fileToCorrupt, new LinkOption[0]));
        try (FSDirectory dir = FSDirectory.open((Path)fileToCorrupt.toAbsolutePath().getParent());){
            long actualChecksumAfterCorruption;
            long checksumAfterCorruption;
            long checksumBeforeCorruption;
            try (IndexInput input = dir.openInput(fileToCorrupt.getFileName().toString(), IOContext.DEFAULT);){
                checksumBeforeCorruption = CodecUtil.retrieveChecksum((IndexInput)input);
            }
            try (FileChannel raf = FileChannel.open(fileToCorrupt, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                long maxPosition = raf.size();
                int position = random.nextInt((int)Math.min(Integer.MAX_VALUE, maxPosition));
                CorruptionUtils.corruptAt(fileToCorrupt, raf, position);
            }
            try (ChecksumIndexInput input = dir.openChecksumInput(fileToCorrupt.getFileName().toString(), IOContext.DEFAULT);){
                Assert.assertThat((Object)input.getFilePointer(), (Matcher)Matchers.is((Object)0L));
                input.seek(input.length() - (long)CodecUtil.footerLength());
                checksumAfterCorruption = input.getChecksum();
                input.seek(input.length() - 8L);
                actualChecksumAfterCorruption = CodecUtil.readBELong((DataInput)input);
            }
            StringBuilder msg = new StringBuilder();
            msg.append("before: [").append(checksumBeforeCorruption).append("] ");
            msg.append("after: [").append(checksumAfterCorruption).append("] ");
            msg.append("checksum value after corruption: ").append(actualChecksumAfterCorruption).append("] ");
            msg.append("file: ").append(fileToCorrupt.getFileName()).append(" length: ");
            msg.append(dir.fileLength(fileToCorrupt.getFileName().toString()));
            logger.info("Checksum {}", (Object)msg);
            LuceneTestCase.assumeTrue((String)("Checksum collision - " + msg.toString()), (checksumAfterCorruption != checksumBeforeCorruption || actualChecksumAfterCorruption != checksumBeforeCorruption ? 1 : 0) != 0);
            Assert.assertThat((String)"no file corrupted", (Object)fileToCorrupt, (Matcher)Matchers.notNullValue());
        }
    }

    static void corruptAt(Path path, FileChannel channel, int position) throws IOException {
        channel.position(position);
        long filePointer = channel.position();
        ByteBuffer bb = ByteBuffer.wrap(new byte[1]);
        channel.read(bb);
        bb.flip();
        byte oldValue = bb.get(0);
        byte newValue = (byte)(oldValue + 1);
        bb.put(0, newValue);
        channel.position(filePointer);
        channel.write(bb);
        logger.info("Corrupting file --  flipping at position {} from {} to {} file: {}", (Object)filePointer, (Object)Integer.toHexString(oldValue), (Object)Integer.toHexString(newValue), (Object)path.getFileName());
    }
}

