/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.lucene.tests.mockfile.ExtrasFS;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.IsAcknowledgedSupplier;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Streams;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.BlobStoreTestUtil;
import org.elasticsearch.search.SearchResponseUtils;
import org.elasticsearch.snapshots.AbstractSnapshotIntegTestCase;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class ESBlobStoreRepositoryIntegTestCase
extends ESIntegTestCase {
    public static RepositoryData getRepositoryData(Repository repository) {
        return AbstractSnapshotIntegTestCase.getRepositoryData(repository);
    }

    protected abstract String repositoryType();

    protected Settings repositorySettings(String repoName) {
        return Settings.builder().put("compress", ESBlobStoreRepositoryIntegTestCase.randomBoolean()).build();
    }

    protected final String createRepository(String name) {
        return this.createRepository(name, true);
    }

    protected final String createRepository(String name, boolean verify) {
        return this.createRepository(name, this.repositorySettings(name), verify);
    }

    protected final String createRepository(String name, Settings settings, boolean verify) {
        this.logger.info("-->  creating repository [name: {}, verify: {}, settings: {}]", (Object)name, (Object)verify, (Object)settings);
        ElasticsearchAssertions.assertAcked(ESBlobStoreRepositoryIntegTestCase.clusterAdmin().preparePutRepository(TEST_REQUEST_TIMEOUT, TEST_REQUEST_TIMEOUT, name).setType(this.repositoryType()).setVerify(verify).setSettings(settings));
        ESBlobStoreRepositoryIntegTestCase.internalCluster().getDataOrMasterNodeInstances(RepositoriesService.class).forEach(repositories -> {
            ESBlobStoreRepositoryIntegTestCase.assertThat(repositories.repository(name), Matchers.notNullValue());
            ESBlobStoreRepositoryIntegTestCase.assertThat(repositories.repository(name), Matchers.instanceOf(BlobStoreRepository.class));
            ESBlobStoreRepositoryIntegTestCase.assertThat(repositories.repository(name).isReadOnly(), Matchers.is((Object)settings.getAsBoolean("readonly", Boolean.valueOf(false))));
            BlobStore blobStore = ((BlobStoreRepository)repositories.repository(name)).getBlobStore();
            ESBlobStoreRepositoryIntegTestCase.assertThat("blob store has to be lazy initialized", blobStore, verify ? Matchers.is((Matcher)Matchers.notNullValue()) : Matchers.is((Matcher)Matchers.nullValue()));
        });
        return name;
    }

    protected final void deleteRepository(String name) {
        this.logger.debug("-->  deleting repository [name: {}]", (Object)name);
        ElasticsearchAssertions.assertAcked(ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareDeleteRepository(TEST_REQUEST_TIMEOUT, TEST_REQUEST_TIMEOUT, name));
        ESBlobStoreRepositoryIntegTestCase.internalCluster().getDataOrMasterNodeInstances(RepositoriesService.class).forEach(repositories -> {
            RepositoryMissingException e = (RepositoryMissingException)ESBlobStoreRepositoryIntegTestCase.expectThrows(RepositoryMissingException.class, () -> repositories.repository(name));
            ESBlobStoreRepositoryIntegTestCase.assertThat(e.repository(), Matchers.equalTo((Object)name));
        });
    }

    public void testReadNonExistingPath() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            BlobContainer container = store.blobContainer(BlobPath.EMPTY);
            ESBlobStoreRepositoryIntegTestCase.expectThrows(NoSuchFileException.class, () -> {
                try (InputStream is = container.readBlob(BlobStoreTestUtil.randomPurpose(), "non-existing");){
                    is.read();
                }
            });
        }
    }

    public void testWriteRead() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            BlobContainer container = store.blobContainer(BlobPath.EMPTY);
            byte[] data = ESBlobStoreRepositoryIntegTestCase.randomBytes(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, ESBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
            ESBlobStoreRepositoryIntegTestCase.writeBlob(container, "foobar", new BytesArray(data), ESBlobStoreRepositoryIntegTestCase.randomBoolean());
            if (ESBlobStoreRepositoryIntegTestCase.randomBoolean()) {
                data = ESBlobStoreRepositoryIntegTestCase.randomBytes(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, ESBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
                ESBlobStoreRepositoryIntegTestCase.writeBlob(container, "foobar", new BytesArray(data), false);
            }
            try (InputStream stream = container.readBlob(BlobStoreTestUtil.randomPurpose(), "foobar");){
                BytesRefBuilder target = new BytesRefBuilder();
                while (target.length() < data.length) {
                    int offset;
                    byte[] buffer = new byte[ESBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1, data.length - target.length())];
                    int read = stream.read(buffer, offset = ESBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(0, buffer.length - 1), buffer.length - offset);
                    if (read >= 0) {
                        target.append(new BytesRef(buffer, offset, read));
                        continue;
                    }
                    ESBlobStoreRepositoryIntegTestCase.fail((String)("Expected [" + (data.length - target.length()) + "] more bytes to be readable but reached EOF"));
                }
                ESBlobStoreRepositoryIntegTestCase.assertEquals((long)data.length, (long)target.length());
                ESBlobStoreRepositoryIntegTestCase.assertArrayEquals((byte[])data, (byte[])Arrays.copyOfRange(target.bytes(), 0, target.length()));
            }
            container.delete(BlobStoreTestUtil.randomPurpose());
        }
    }

    public void testList() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            String name;
            int length;
            int i;
            BlobContainer container = store.blobContainer(BlobPath.EMPTY);
            ESBlobStoreRepositoryIntegTestCase.assertThat(container.listBlobs(BlobStoreTestUtil.randomPurpose()).size(), CoreMatchers.equalTo((Object)0));
            int numberOfFooBlobs = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(0, 10);
            int numberOfBarBlobs = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(3, 20);
            HashMap<Object, Long> generatedBlobs = new HashMap<Object, Long>();
            for (i = 0; i < numberOfFooBlobs; ++i) {
                length = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 100);
                name = "foo-" + i + "-";
                generatedBlobs.put(name, Long.valueOf(length));
                ESBlobStoreRepositoryIntegTestCase.writeRandomBlob(container, name, length);
            }
            for (i = 1; i < numberOfBarBlobs; ++i) {
                length = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 100);
                name = "bar-" + i + "-";
                generatedBlobs.put(name, Long.valueOf(length));
                ESBlobStoreRepositoryIntegTestCase.writeRandomBlob(container, name, length);
            }
            int length2 = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 100);
            String name2 = "bar-0-";
            generatedBlobs.put(name2, Long.valueOf(length2));
            ESBlobStoreRepositoryIntegTestCase.writeRandomBlob(container, name2, length2);
            Map blobs = container.listBlobs(BlobStoreTestUtil.randomPurpose());
            ESBlobStoreRepositoryIntegTestCase.assertThat(blobs.size(), CoreMatchers.equalTo((Object)(numberOfFooBlobs + numberOfBarBlobs)));
            for (Map.Entry generated : generatedBlobs.entrySet()) {
                BlobMetadata blobMetadata = (BlobMetadata)blobs.get(generated.getKey());
                ESBlobStoreRepositoryIntegTestCase.assertThat((String)generated.getKey(), blobMetadata, CoreMatchers.notNullValue());
                ESBlobStoreRepositoryIntegTestCase.assertThat(blobMetadata.name(), CoreMatchers.equalTo((Object)((String)generated.getKey())));
                ESBlobStoreRepositoryIntegTestCase.assertThat(blobMetadata.length(), CoreMatchers.equalTo((Object)this.blobLengthFromContentLength((Long)generated.getValue())));
            }
            ESBlobStoreRepositoryIntegTestCase.assertThat(container.listBlobsByPrefix(BlobStoreTestUtil.randomPurpose(), "foo-").size(), CoreMatchers.equalTo((Object)numberOfFooBlobs));
            ESBlobStoreRepositoryIntegTestCase.assertThat(container.listBlobsByPrefix(BlobStoreTestUtil.randomPurpose(), "bar-").size(), CoreMatchers.equalTo((Object)numberOfBarBlobs));
            ESBlobStoreRepositoryIntegTestCase.assertThat(container.listBlobsByPrefix(BlobStoreTestUtil.randomPurpose(), "baz-").size(), CoreMatchers.equalTo((Object)0));
            container.delete(BlobStoreTestUtil.randomPurpose());
        }
    }

    public void testDeleteBlobs() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            List<String> blobNames = Arrays.asList("foobar", "barfoo");
            BlobContainer container = store.blobContainer(BlobPath.EMPTY);
            container.deleteBlobsIgnoringIfNotExists(BlobStoreTestUtil.randomPurpose(), blobNames.iterator());
            byte[] data = ESBlobStoreRepositoryIntegTestCase.randomBytes(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, ESBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
            BytesArray bytesArray = new BytesArray(data);
            for (String blobName : blobNames) {
                ESBlobStoreRepositoryIntegTestCase.writeBlob(container, blobName, bytesArray, ESBlobStoreRepositoryIntegTestCase.randomBoolean());
            }
            ESBlobStoreRepositoryIntegTestCase.assertEquals((long)container.listBlobs(BlobStoreTestUtil.randomPurpose()).size(), (long)2L);
            container.deleteBlobsIgnoringIfNotExists(BlobStoreTestUtil.randomPurpose(), blobNames.iterator());
            ESBlobStoreRepositoryIntegTestCase.assertTrue((boolean)container.listBlobs(BlobStoreTestUtil.randomPurpose()).isEmpty());
            container.deleteBlobsIgnoringIfNotExists(BlobStoreTestUtil.randomPurpose(), blobNames.iterator());
        }
    }

    public static void writeBlob(BlobContainer container, String blobName, BytesArray bytesArray, boolean failIfAlreadyExists) throws IOException {
        if (ESBlobStoreRepositoryIntegTestCase.randomBoolean()) {
            container.writeBlob(BlobStoreTestUtil.randomPurpose(), blobName, (BytesReference)bytesArray, failIfAlreadyExists);
        } else {
            container.writeBlobAtomic(BlobStoreTestUtil.randomNonDataPurpose(), blobName, (BytesReference)bytesArray, failIfAlreadyExists);
        }
    }

    public void testContainerCreationAndDeletion() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            BlobContainer containerFoo = store.blobContainer(BlobPath.EMPTY.add("foo"));
            BlobContainer containerBar = store.blobContainer(BlobPath.EMPTY.add("bar"));
            byte[] data1 = ESBlobStoreRepositoryIntegTestCase.randomBytes(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, ESBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
            byte[] data2 = ESBlobStoreRepositoryIntegTestCase.randomBytes(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, ESBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
            ESBlobStoreRepositoryIntegTestCase.writeBlob(containerFoo, "test", new BytesArray(data1));
            ESBlobStoreRepositoryIntegTestCase.writeBlob(containerBar, "test", new BytesArray(data2));
            ESBlobStoreRepositoryIntegTestCase.assertArrayEquals((byte[])ESBlobStoreRepositoryIntegTestCase.readBlobFully(containerFoo, "test", data1.length), (byte[])data1);
            ESBlobStoreRepositoryIntegTestCase.assertArrayEquals((byte[])ESBlobStoreRepositoryIntegTestCase.readBlobFully(containerBar, "test", data2.length), (byte[])data2);
            ESBlobStoreRepositoryIntegTestCase.assertTrue((boolean)containerFoo.blobExists(BlobStoreTestUtil.randomPurpose(), "test"));
            ESBlobStoreRepositoryIntegTestCase.assertTrue((boolean)containerBar.blobExists(BlobStoreTestUtil.randomPurpose(), "test"));
            containerBar.delete(BlobStoreTestUtil.randomPurpose());
            containerFoo.delete(BlobStoreTestUtil.randomPurpose());
        }
    }

    public static byte[] writeRandomBlob(BlobContainer container, String name, int length) throws IOException {
        byte[] data = ESBlobStoreRepositoryIntegTestCase.randomBytes(length);
        ESBlobStoreRepositoryIntegTestCase.writeBlob(container, name, new BytesArray(data));
        return data;
    }

    public static byte[] readBlobFully(BlobContainer container, String name, int length) throws IOException {
        byte[] data = new byte[length];
        try (InputStream inputStream = container.readBlob(BlobStoreTestUtil.randomPurpose(), name);){
            ESBlobStoreRepositoryIntegTestCase.assertThat(Streams.readFully((InputStream)inputStream, (byte[])data), CoreMatchers.equalTo((Object)length));
            ESBlobStoreRepositoryIntegTestCase.assertThat(inputStream.read(), CoreMatchers.equalTo((Object)-1));
        }
        return data;
    }

    public static byte[] randomBytes(int length) {
        byte[] data = new byte[length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)ESBlobStoreRepositoryIntegTestCase.randomInt();
        }
        return data;
    }

    protected static void writeBlob(BlobContainer container, String blobName, BytesArray bytesArray) throws IOException {
        container.writeBlob(BlobStoreTestUtil.randomPurpose(), blobName, (BytesReference)bytesArray, true);
    }

    protected BlobStore newBlobStore() {
        String repository = this.createRepository(this.randomRepositoryName());
        return this.newBlobStore(repository);
    }

    protected BlobStore newBlobStore(String repository) {
        return ESBlobStoreRepositoryIntegTestCase.asInstanceOf(BlobStoreRepository.class, ESBlobStoreRepositoryIntegTestCase.internalCluster().getAnyMasterNodeInstance(RepositoriesService.class).repository(repository)).blobStore();
    }

    public void testSnapshotAndRestore() throws Exception {
        this.testSnapshotAndRestore(ESBlobStoreRepositoryIntegTestCase.randomBoolean());
    }

    protected void testSnapshotAndRestore(boolean recreateRepositoryBeforeRestore) throws Exception {
        String repoName = this.randomRepositoryName();
        Settings repoSettings = this.repositorySettings(repoName);
        this.createRepository(repoName, repoSettings, ESBlobStoreRepositoryIntegTestCase.randomBoolean());
        int indexCount = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 5);
        int[] docCounts = new int[indexCount];
        String[] indexNames = this.generateRandomNames(indexCount);
        for (int i = 0; i < indexCount; ++i) {
            docCounts[i] = ESBlobStoreRepositoryIntegTestCase.iterations(10, 1000);
            this.logger.info("-->  create random index {} with {} records", (Object)indexNames[i], (Object)docCounts[i]);
            this.addRandomDocuments(indexNames[i], docCounts[i]);
            ElasticsearchAssertions.assertHitCount(ESBlobStoreRepositoryIntegTestCase.prepareSearch(indexNames[i]).setSize(0), (long)docCounts[i]);
        }
        String snapshotName = this.randomName();
        this.logger.info("-->  create snapshot {}:{}", (Object)repoName, (Object)snapshotName);
        ESBlobStoreRepositoryIntegTestCase.assertSuccessfulSnapshot(ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, repoName, snapshotName).setWaitForCompletion(true).setIndices(indexNames));
        List<String> deleteIndices = ESBlobStoreRepositoryIntegTestCase.randomSubsetOf(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(0, indexCount), indexNames);
        if (deleteIndices.size() > 0) {
            this.logger.info("-->  delete indices {}", deleteIndices);
            ElasticsearchAssertions.assertAcked(ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareDelete(deleteIndices.toArray(new String[deleteIndices.size()])));
        }
        HashSet<String> closeIndices = new HashSet<String>(Arrays.asList(indexNames));
        closeIndices.removeAll(deleteIndices);
        if (closeIndices.size() > 0) {
            for (String index : closeIndices) {
                if (ESBlobStoreRepositoryIntegTestCase.randomBoolean()) {
                    this.logger.info("--> add random documents to {}", (Object)index);
                    this.addRandomDocuments(index, ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 1000));
                    continue;
                }
                int docCount = (int)SearchResponseUtils.getTotalHitsValue(ESBlobStoreRepositoryIntegTestCase.prepareSearch(index).setSize(0));
                this.deleteRandomDocs(index, docCount);
            }
            this.ensureGreen(new String[0]);
            this.logger.info("-->  close indices {}", closeIndices);
            ElasticsearchAssertions.assertAcked(ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareClose(closeIndices.toArray(new String[closeIndices.size()])));
        }
        if (recreateRepositoryBeforeRestore) {
            this.deleteRepository(repoName);
            this.createRepository(repoName, repoSettings, ESBlobStoreRepositoryIntegTestCase.randomBoolean());
        }
        this.logger.info("--> restore all indices from the snapshot");
        ESBlobStoreRepositoryIntegTestCase.assertSuccessfulRestore(ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareRestoreSnapshot(TEST_REQUEST_TIMEOUT, repoName, snapshotName).setWaitForCompletion(true));
        this.ensureGreen(TimeValue.timeValueSeconds((long)120L), new String[0]);
        for (int i = 0; i < indexCount; ++i) {
            ElasticsearchAssertions.assertHitCount(ESBlobStoreRepositoryIntegTestCase.prepareSearch(indexNames[i]).setSize(0), (long)docCounts[i]);
        }
        this.logger.info("-->  delete snapshot {}:{}", (Object)repoName, (Object)snapshotName);
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, repoName, new String[]{snapshotName}).get());
        ESBlobStoreRepositoryIntegTestCase.expectThrows(SnapshotMissingException.class, () -> ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareGetSnapshots(TEST_REQUEST_TIMEOUT, new String[]{repoName}).setSnapshots(new String[]{snapshotName}).get());
        ESBlobStoreRepositoryIntegTestCase.expectThrows(SnapshotMissingException.class, () -> ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, repoName, new String[]{snapshotName}).get());
        ESBlobStoreRepositoryIntegTestCase.expectThrows(SnapshotRestoreException.class, () -> ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareRestoreSnapshot(TEST_REQUEST_TIMEOUT, repoName, snapshotName).setWaitForCompletion(ESBlobStoreRepositoryIntegTestCase.randomBoolean()).get());
    }

    public void testMultipleSnapshotAndRollback() throws Exception {
        int i;
        String repoName = this.createRepository(this.randomRepositoryName());
        int iterationCount = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(2, 5);
        int[] docCounts = new int[iterationCount];
        String indexName = this.randomName();
        String snapshotName = this.randomName();
        ElasticsearchAssertions.assertAcked((CreateIndexResponse)ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareCreate(indexName).get());
        for (int i2 = 0; i2 < iterationCount; ++i2) {
            if (ESBlobStoreRepositoryIntegTestCase.randomBoolean() && i2 > 0) {
                docCount = docCounts[i2 - 1];
                if (docCount > 0) {
                    this.deleteRandomDocs(indexName, docCount);
                }
            } else {
                docCount = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 1000);
                this.logger.info("--> add {} random documents to {}", (Object)docCount, (Object)indexName);
                this.addRandomDocuments(indexName, docCount);
            }
            docCounts[i2] = (int)SearchResponseUtils.getTotalHitsValue(ESBlobStoreRepositoryIntegTestCase.prepareSearch(indexName).setSize(0));
            this.logger.info("-->  create snapshot {}:{} with {} documents", (Object)repoName, (Object)(snapshotName + "-" + i2), (Object)docCounts[i2]);
            ESBlobStoreRepositoryIntegTestCase.assertSuccessfulSnapshot(ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, repoName, snapshotName + "-" + i2).setWaitForCompletion(true).setIndices(new String[]{indexName}));
        }
        int restoreOperations = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 3);
        for (i = 0; i < restoreOperations; ++i) {
            int iterationToRestore = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(0, iterationCount - 1);
            this.logger.info("-->  performing restore of the iteration {}", (Object)iterationToRestore);
            this.ensureGreen(new String[0]);
            this.logger.info("-->  close index");
            ElasticsearchAssertions.assertAcked(ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareClose(new String[]{indexName}));
            this.logger.info("--> restore index from the snapshot");
            ESBlobStoreRepositoryIntegTestCase.assertSuccessfulRestore(ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareRestoreSnapshot(TEST_REQUEST_TIMEOUT, repoName, snapshotName + "-" + iterationToRestore).setWaitForCompletion(true));
            this.ensureGreen(new String[0]);
            ElasticsearchAssertions.assertHitCount(ESBlobStoreRepositoryIntegTestCase.prepareSearch(indexName).setSize(0), (long)docCounts[iterationToRestore]);
        }
        for (i = 0; i < iterationCount; ++i) {
            this.logger.info("-->  delete snapshot {}:{}", (Object)repoName, (Object)(snapshotName + "-" + i));
            ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, repoName, new String[]{snapshotName + "-" + i}).get());
        }
    }

    private void deleteRandomDocs(String indexName, int existingDocCount) {
        int deleteCount = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, existingDocCount);
        this.logger.info("--> delete {} random documents from {}", (Object)deleteCount, (Object)indexName);
        for (int j = 0; j < deleteCount; ++j) {
            int doc = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(0, existingDocCount - 1);
            ESBlobStoreRepositoryIntegTestCase.client().prepareDelete(indexName, Integer.toString(doc)).get();
        }
        ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareRefresh(new String[]{indexName}).get();
    }

    public void testIndicesDeletedFromRepository() throws Exception {
        String repoName = this.createRepository(this.randomRepositoryName());
        Client client = ESBlobStoreRepositoryIntegTestCase.client();
        this.createIndex("test-idx-1", "test-idx-2", "test-idx-3");
        this.ensureGreen(new String[0]);
        this.logger.info("--> indexing some data");
        for (int i = 0; i < 20; ++i) {
            this.indexDoc("test-idx-1", Integer.toString(i), "foo", "bar" + i);
            this.indexDoc("test-idx-2", Integer.toString(i), "foo", "baz" + i);
            this.indexDoc("test-idx-3", Integer.toString(i), "foo", "baz" + i);
        }
        this.refresh(new String[0]);
        this.logger.info("--> take a snapshot");
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)client.admin().cluster().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, repoName, "test-snap").setWaitForCompletion(true).get();
        ESBlobStoreRepositoryIntegTestCase.assertEquals((long)createSnapshotResponse.getSnapshotInfo().successfulShards(), (long)createSnapshotResponse.getSnapshotInfo().totalShards());
        this.logger.info("--> indexing more data");
        for (int i = 20; i < 40; ++i) {
            this.indexDoc("test-idx-1", Integer.toString(i), "foo", "bar" + i);
            this.indexDoc("test-idx-2", Integer.toString(i), "foo", "baz" + i);
            this.indexDoc("test-idx-3", Integer.toString(i), "foo", "baz" + i);
        }
        this.logger.info("--> take another snapshot with only 2 of the 3 indices");
        createSnapshotResponse = (CreateSnapshotResponse)client.admin().cluster().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, repoName, "test-snap2").setWaitForCompletion(true).setIndices(new String[]{"test-idx-1", "test-idx-2"}).get();
        ESBlobStoreRepositoryIntegTestCase.assertEquals((long)createSnapshotResponse.getSnapshotInfo().successfulShards(), (long)createSnapshotResponse.getSnapshotInfo().totalShards());
        this.logger.info("--> delete a snapshot");
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, repoName, new String[]{"test-snap"}).get());
        this.logger.info("--> verify index folder deleted from blob container");
        RepositoriesService repositoriesSvc = ESBlobStoreRepositoryIntegTestCase.internalCluster().getInstance(RepositoriesService.class, ESBlobStoreRepositoryIntegTestCase.internalCluster().getMasterName());
        ThreadPool threadPool = ESBlobStoreRepositoryIntegTestCase.internalCluster().getInstance(ThreadPool.class, ESBlobStoreRepositoryIntegTestCase.internalCluster().getMasterName());
        BlobStoreRepository repository = (BlobStoreRepository)repositoriesSvc.repository(repoName);
        SetOnce indicesBlobContainer = new SetOnce();
        PlainActionFuture repositoryData = new PlainActionFuture();
        threadPool.executor("snapshot").execute(() -> {
            indicesBlobContainer.set((Object)repository.blobStore().blobContainer(repository.basePath().add("indices")));
            repository.getRepositoryData((Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, (ActionListener)repositoryData);
        });
        for (IndexId indexId : ((RepositoryData)repositoryData.actionGet()).getIndices().values()) {
            if (!indexId.getName().equals("test-idx-3")) continue;
            ESBlobStoreRepositoryIntegTestCase.assertFalse((boolean)((BlobContainer)indicesBlobContainer.get()).blobExists(BlobStoreTestUtil.randomPurpose(), indexId.getId()));
        }
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)ESBlobStoreRepositoryIntegTestCase.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, repoName, new String[]{"test-snap2"}).get());
    }

    public void testDanglingShardLevelBlobCleanup() throws Exception {
        String repoName = this.createRepository(this.randomRepositoryName());
        Client client = ESBlobStoreRepositoryIntegTestCase.client();
        String indexName = ESBlobStoreRepositoryIntegTestCase.randomIdentifier();
        this.createIndex(indexName, 1, 0);
        this.addRandomDocuments(indexName, ESBlobStoreRepositoryIntegTestCase.between(1, 10));
        ESBlobStoreRepositoryIntegTestCase.assertEquals((Object)SnapshotState.SUCCESS, (Object)((CreateSnapshotResponse)client.admin().cluster().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, repoName, "snapshot-1").setWaitForCompletion(true).get()).getSnapshotInfo().state());
        BlobStoreRepository repo = ESBlobStoreRepositoryIntegTestCase.asInstanceOf(BlobStoreRepository.class, ESBlobStoreRepositoryIntegTestCase.internalCluster().getCurrentMasterNodeInstance(RepositoriesService.class).repository(repoName));
        IndexId indexId = ESBlobStoreRepositoryIntegTestCase.getRepositoryData((Repository)repo).resolveIndexId(indexName);
        BlobContainer shardContainer = repo.shardContainer(indexId, 0);
        shardContainer.writeBlob(OperationPurpose.SNAPSHOT_DATA, "__" + UUIDs.randomBase64UUID((Random)ESBlobStoreRepositoryIntegTestCase.random()), (BytesReference)BytesArray.EMPTY, true);
        this.addRandomDocuments(indexName, ESBlobStoreRepositoryIntegTestCase.between(1, 10));
        ESBlobStoreRepositoryIntegTestCase.assertEquals((long)1L, (long)((BroadcastResponse)client.admin().indices().prepareForceMerge(new String[]{indexName}).setFlush(true).setMaxNumSegments(1).get()).getSuccessfulShards());
        SnapshotInfo snapshot2Info = ((CreateSnapshotResponse)client.admin().cluster().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, repoName, "snapshot-2").setWaitForCompletion(true).get()).getSnapshotInfo();
        ESBlobStoreRepositoryIntegTestCase.assertEquals((Object)SnapshotState.SUCCESS, (Object)snapshot2Info.state());
        ElasticsearchAssertions.assertAcked(client.admin().cluster().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, repoName, new String[]{"snapshot-1"}));
        Set actualBlobs = shardContainer.listBlobs(BlobStoreTestUtil.randomPurpose()).keySet().stream().filter(f -> !ExtrasFS.isExtra((String)f)).collect(Collectors.toSet());
        ShardGeneration shardGeneration = Objects.requireNonNull(ESBlobStoreRepositoryIntegTestCase.getRepositoryData((Repository)repo).shardGenerations().getShardGen(indexId, 0));
        String snapBlob = Strings.format((String)"snap-%s.dat", (Object[])new Object[]{snapshot2Info.snapshotId().getUUID()});
        String indexBlob = Strings.format((String)"index-%s", (Object[])new Object[]{shardGeneration.getGenerationUUID()});
        for (List fileInfos : List.of(repo.loadShardSnapshot(shardContainer, snapshot2Info.snapshotId()).indexFiles(), repo.getBlobStoreIndexShardSnapshots(indexId, 0, shardGeneration).snapshots().stream().flatMap(s -> s.indexFiles().stream()).toList())) {
            ESBlobStoreRepositoryIntegTestCase.assertEquals(Stream.concat(Stream.of(snapBlob, indexBlob), fileInfos.stream().flatMap(f -> f.metadata().hashEqualsContents() ? Stream.empty() : IntStream.range(0, f.numberOfParts()).mapToObj(arg_0 -> ((BlobStoreIndexShardSnapshot.FileInfo)f).partName(arg_0)))).collect(Collectors.toSet()), actualBlobs);
        }
        ElasticsearchAssertions.assertAcked(client.admin().cluster().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, repoName, new String[]{"snapshot-2"}));
    }

    protected void addRandomDocuments(String name, int numDocs) throws InterruptedException {
        IndexRequestBuilder[] indexRequestBuilders = new IndexRequestBuilder[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            indexRequestBuilders[i] = ESBlobStoreRepositoryIntegTestCase.prepareIndex(name).setId(Integer.toString(i)).setRouting(ESBlobStoreRepositoryIntegTestCase.randomAlphaOfLength(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 10))).setSource(new Object[]{"field", "value"});
        }
        this.indexRandom(true, indexRequestBuilders);
    }

    private String[] generateRandomNames(int num) {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < num; ++i) {
            String name;
            while (names.contains(name = this.randomName())) {
            }
            names.add(name);
        }
        return names.toArray(new String[num]);
    }

    protected static void assertSuccessfulSnapshot(CreateSnapshotRequestBuilder requestBuilder) {
        CreateSnapshotResponse response = (CreateSnapshotResponse)requestBuilder.get();
        ESBlobStoreRepositoryIntegTestCase.assertSuccessfulSnapshot(response);
    }

    private static void assertSuccessfulSnapshot(CreateSnapshotResponse response) {
        ESBlobStoreRepositoryIntegTestCase.assertThat(response.getSnapshotInfo().successfulShards(), Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        ESBlobStoreRepositoryIntegTestCase.assertThat(response.getSnapshotInfo().successfulShards(), Matchers.equalTo((Object)response.getSnapshotInfo().totalShards()));
    }

    protected static void assertSuccessfulRestore(RestoreSnapshotRequestBuilder requestBuilder) {
        RestoreSnapshotResponse response = (RestoreSnapshotResponse)requestBuilder.get();
        ESBlobStoreRepositoryIntegTestCase.assertSuccessfulRestore(response);
    }

    private static void assertSuccessfulRestore(RestoreSnapshotResponse response) {
        ESBlobStoreRepositoryIntegTestCase.assertThat(response.getRestoreInfo().successfulShards(), Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        ESBlobStoreRepositoryIntegTestCase.assertThat(response.getRestoreInfo().successfulShards(), Matchers.equalTo((Object)response.getRestoreInfo().totalShards()));
    }

    protected String randomName() {
        return ESBlobStoreRepositoryIntegTestCase.randomAlphaOfLength(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 10)).toLowerCase(Locale.ROOT);
    }

    protected String randomRepositoryName() {
        return this.randomName();
    }

    protected long blobLengthFromContentLength(long contentLength) {
        return contentLength;
    }
}

