/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.shard.GlobalCheckpointSyncer;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.indices.cluster.IndexRemovalReason;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractIndicesClusterStateServiceTestCase
extends ESTestCase {
    private boolean enableRandomFailures;

    @Before
    public void injectRandomFailures() {
        this.enableRandomFailures = AbstractIndicesClusterStateServiceTestCase.randomBoolean();
    }

    protected void disableRandomFailures() {
        this.enableRandomFailures = false;
    }

    protected void failRandomly() {
        if (this.enableRandomFailures && AbstractIndicesClusterStateServiceTestCase.rarely()) {
            throw new RuntimeException("dummy test failure");
        }
    }

    public void assertClusterStateMatchesNodeState(ClusterState state, IndicesClusterStateService indicesClusterStateService) {
        Index index;
        MockIndicesService indicesService = (MockIndicesService)indicesClusterStateService.indicesService;
        ConcurrentMap failedShardsCache = indicesClusterStateService.failedShardsCache;
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.getNodes().getLocalNodeId());
        if (localRoutingNode != null) {
            if (!this.enableRandomFailures && failedShardsCache.values().stream().anyMatch(ShardRouting::initializing)) {
                AbstractIndicesClusterStateServiceTestCase.fail((String)("failed shard cache should not contain initializing shard routing: " + String.valueOf(failedShardsCache.values())));
            }
            for (ShardRouting shardRouting : localRoutingNode) {
                index = shardRouting.index();
                IndexMetadata indexMetadata = state.metadata().getIndexSafe(index);
                MockIndexShard shard = (MockIndexShard)indicesService.getShardOrNull(shardRouting.shardId());
                ShardRouting failedShard = (ShardRouting)failedShardsCache.get(shardRouting.shardId());
                if (state.blocks().disableStatePersistence()) {
                    if (shard == null) continue;
                    AbstractIndicesClusterStateServiceTestCase.fail((String)("Shard with id " + String.valueOf(shardRouting) + " should be removed from indicesService due to disabled state persistence"));
                    continue;
                }
                if (failedShard != null && !failedShard.isSameAllocation(shardRouting)) {
                    AbstractIndicesClusterStateServiceTestCase.fail((String)("Shard cache has not been properly cleaned for " + String.valueOf(failedShard)));
                }
                if (shard == null && failedShard == null) {
                    AbstractIndicesClusterStateServiceTestCase.fail((String)("Shard with id " + String.valueOf(shardRouting) + " expected but missing in indicesService and failedShardsCache"));
                }
                if (!this.enableRandomFailures && shard == null && shardRouting.initializing() && failedShard == shardRouting) {
                    AbstractIndicesClusterStateServiceTestCase.fail((String)("Shard with id " + String.valueOf(shardRouting) + " expected but missing in indicesService " + String.valueOf(failedShard)));
                }
                if (shard == null) continue;
                MockIndexService indexService = indicesService.indexService(index);
                AbstractIndicesClusterStateServiceTestCase.assertTrue((String)("Index " + String.valueOf(index) + " expected but missing in indicesService"), (indexService != null ? 1 : 0) != 0);
                AbstractIndicesClusterStateServiceTestCase.assertThat(indexService.getIndexSettings().getIndexMetadata(), Matchers.equalTo((Object)indexMetadata));
                if (!this.enableRandomFailures || failedShard == null) {
                    AbstractIndicesClusterStateServiceTestCase.assertTrue((String)("Shard with id " + String.valueOf(shardRouting) + " expected but missing in indexService"), (shard != null ? 1 : 0) != 0);
                    AbstractIndicesClusterStateServiceTestCase.assertThat(shard.routingEntry(), Matchers.equalTo((Object)shardRouting));
                }
                if (!shard.routingEntry().primary() || !shard.routingEntry().active()) continue;
                IndexShardRoutingTable shardRoutingTable = state.routingTable().shardRoutingTable(shard.shardId());
                Set inSyncIds = state.metadata().index(shard.shardId().getIndex()).inSyncAllocationIds(shard.shardId().id());
                AbstractIndicesClusterStateServiceTestCase.assertThat(String.valueOf(shard.routingEntry()) + " isn't updated with in-sync aIDs", shard.inSyncAllocationIds, Matchers.equalTo((Object)inSyncIds));
                AbstractIndicesClusterStateServiceTestCase.assertThat(String.valueOf(shard.routingEntry()) + " isn't updated with routing table", shard.routingTable, Matchers.equalTo((Object)shardRoutingTable));
            }
        }
        Iterator iterator = indicesService.iterator();
        while (iterator.hasNext()) {
            IndicesClusterStateService.AllocatedIndex indexService = (IndicesClusterStateService.AllocatedIndex)iterator.next();
            index = indexService.getIndexSettings().getIndex();
            if (state.blocks().disableStatePersistence()) {
                AbstractIndicesClusterStateServiceTestCase.fail((String)("Index service " + String.valueOf(index) + " should be removed from indicesService due to disabled state persistence"));
            }
            AbstractIndicesClusterStateServiceTestCase.assertTrue((state.metadata().getIndexSafe(index) != null ? 1 : 0) != 0);
            boolean shardsFound = false;
            for (IndicesClusterStateService.Shard shard : indexService) {
                shardsFound = true;
                ShardRouting persistedShardRouting = shard.routingEntry();
                ShardRouting shardRouting = localRoutingNode.getByShardId(persistedShardRouting.shardId());
                if (shardRouting == null) {
                    AbstractIndicesClusterStateServiceTestCase.fail((String)("Shard with id " + String.valueOf(persistedShardRouting) + " locally exists but missing in routing table"));
                }
                if (shardRouting.equals((Object)persistedShardRouting)) continue;
                AbstractIndicesClusterStateServiceTestCase.fail((String)("Local shard " + String.valueOf(persistedShardRouting) + " has stale routing" + String.valueOf(shardRouting)));
            }
            if (shardsFound) continue;
            AbstractIndicesClusterStateServiceTestCase.assertFalse((boolean)failedShardsCache.keySet().stream().noneMatch(shardId -> shardId.getIndex().equals((Object)index)));
        }
    }

    public static void awaitIndexShardCloseAsyncTasks(IndicesClusterStateService indicesClusterStateService) {
        CountDownLatch latch = new CountDownLatch(1);
        indicesClusterStateService.onClusterStateShardsClosed(latch::countDown);
        AbstractIndicesClusterStateServiceTestCase.safeAwait(latch);
    }

    protected class MockIndicesService
    implements IndicesClusterStateService.AllocatedIndices<MockIndexShard, MockIndexService> {
        private volatile Map<String, MockIndexService> indices = Collections.emptyMap();

        protected MockIndicesService() {
        }

        public synchronized MockIndexService createIndex(IndexMetadata indexMetadata, List<IndexEventListener> buildInIndexListener, boolean writeDanglingIndices) throws IOException {
            MockIndexService indexService = new MockIndexService(new IndexSettings(indexMetadata, Settings.EMPTY));
            this.indices = Maps.copyMapWithAddedEntry(this.indices, (Object)indexMetadata.getIndexUUID(), (Object)indexService);
            return indexService;
        }

        public IndexMetadata verifyIndexIsDeleted(Index index, ClusterState state) {
            return null;
        }

        public void deleteUnassignedIndex(String reason, IndexMetadata metadata, ClusterState clusterState) {
        }

        public synchronized void removeIndex(Index index, IndexRemovalReason reason, String extraInfo, Executor shardCloseExecutor, ActionListener<Void> shardsClosedListener) {
            if (this.hasIndex(index)) {
                HashMap<String, MockIndexService> newIndices = new HashMap<String, MockIndexService>(this.indices);
                newIndices.remove(index.getUUID());
                this.indices = Collections.unmodifiableMap(newIndices);
            }
            shardsClosedListener.onResponse(null);
        }

        @Nullable
        public MockIndexService indexService(Index index) {
            return this.indices.get(index.getUUID());
        }

        public void createShard(ShardRouting shardRouting, PeerRecoveryTargetService recoveryTargetService, PeerRecoveryTargetService.RecoveryListener recoveryListener, RepositoriesService repositoriesService, Consumer<IndexShard.ShardFailure> onShardFailure, GlobalCheckpointSyncer globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, DiscoveryNode targetNode, DiscoveryNode sourceNode, long clusterStateVersion) throws IOException {
            AbstractIndicesClusterStateServiceTestCase.this.failRandomly();
            RecoveryState recoveryState = new RecoveryState(shardRouting, targetNode, sourceNode);
            MockIndexService indexService = this.indexService(recoveryState.getShardId().getIndex());
            MockIndexShard indexShard = indexService.createShard(shardRouting);
            indexShard.recoveryState = recoveryState;
        }

        public void processPendingDeletes(Index index, IndexSettings indexSettings, TimeValue timeValue) {
        }

        private boolean hasIndex(Index index) {
            return this.indices.containsKey(index.getUUID());
        }

        public Iterator<MockIndexService> iterator() {
            return this.indices.values().iterator();
        }
    }

    protected class MockIndexShard
    implements IndicesClusterStateService.Shard {
        private volatile ShardRouting shardRouting;
        private volatile RecoveryState recoveryState;
        private volatile Set<String> inSyncAllocationIds;
        private volatile IndexShardRoutingTable routingTable;
        private volatile long term;

        public MockIndexShard(ShardRouting shardRouting, long term) {
            this.shardRouting = shardRouting;
            this.term = term;
        }

        public ShardId shardId() {
            return this.shardRouting.shardId();
        }

        public RecoveryState recoveryState() {
            return this.recoveryState;
        }

        public void updateShardState(ShardRouting shardRouting, long newPrimaryTerm, BiConsumer<IndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> primaryReplicaSyncer, long applyingClusterStateVersion, Set<String> inSyncAllocationIds, IndexShardRoutingTable routingTable) throws IOException {
            AbstractIndicesClusterStateServiceTestCase.this.failRandomly();
            ESTestCase.assertThat(this.shardId(), Matchers.equalTo((Object)shardRouting.shardId()));
            Assert.assertTrue((String)("current: " + String.valueOf(this.shardRouting) + ", got: " + String.valueOf(shardRouting)), (boolean)this.shardRouting.isSameAllocation(shardRouting));
            if (this.shardRouting.active()) {
                Assert.assertTrue((String)("an active shard must stay active, current: " + String.valueOf(this.shardRouting) + ", got: " + String.valueOf(shardRouting)), (boolean)shardRouting.active());
            }
            if (this.shardRouting.primary()) {
                Assert.assertTrue((String)"a primary shard can't be demoted", (boolean)shardRouting.primary());
                if (this.shardRouting.initializing()) {
                    Assert.assertEquals((String)("primary term can not be updated on an initializing primary shard: " + String.valueOf(shardRouting)), (long)this.term, (long)newPrimaryTerm);
                }
            } else if (shardRouting.primary()) {
                Assert.assertTrue((String)("a replica can only be promoted when active. current: " + String.valueOf(this.shardRouting) + " new: " + String.valueOf(shardRouting)), (boolean)shardRouting.active());
            }
            this.shardRouting = shardRouting;
            if (shardRouting.primary()) {
                this.term = newPrimaryTerm;
                this.inSyncAllocationIds = inSyncAllocationIds;
                this.routingTable = routingTable;
            }
        }

        public ShardRouting routingEntry() {
            return this.shardRouting;
        }

        public IndexShardState state() {
            return null;
        }

        public long term() {
            return this.term;
        }

        public void updateTerm(long newTerm) {
            ESTestCase.assertThat("term can only be incremented: " + String.valueOf(this.shardRouting), newTerm, Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.term)));
            if (this.shardRouting.primary() && this.shardRouting.active()) {
                ESTestCase.assertThat("term can not be changed on an active primary shard: " + String.valueOf(this.shardRouting), newTerm, Matchers.equalTo((Object)this.term));
            }
            this.term = newTerm;
        }

        public ShardLongFieldRange getTimestampRange() {
            return ShardLongFieldRange.EMPTY;
        }

        public ShardLongFieldRange getEventIngestedRange() {
            return ShardLongFieldRange.EMPTY;
        }
    }

    protected class MockIndexService
    implements IndicesClusterStateService.AllocatedIndex<MockIndexShard> {
        private volatile Map<Integer, MockIndexShard> shards = Collections.emptyMap();
        private final IndexSettings indexSettings;

        public MockIndexService(IndexSettings indexSettings) {
            this.indexSettings = indexSettings;
        }

        public IndexSettings getIndexSettings() {
            return this.indexSettings;
        }

        public void updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) throws IOException {
            AbstractIndicesClusterStateServiceTestCase.this.failRandomly();
        }

        public void updateMetadata(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) {
            this.indexSettings.updateIndexMetadata(newIndexMetadata);
            for (MockIndexShard shard : this.shards.values()) {
                shard.updateTerm(newIndexMetadata.primaryTerm(shard.shardId().id()));
            }
        }

        public MockIndexShard getShardOrNull(int shardId) {
            return this.shards.get(shardId);
        }

        public synchronized MockIndexShard createShard(ShardRouting routing) throws IOException {
            AbstractIndicesClusterStateServiceTestCase.this.failRandomly();
            MockIndexShard shard = new MockIndexShard(routing, this.indexSettings.getIndexMetadata().primaryTerm(routing.shardId().id()));
            this.shards = Maps.copyMapWithAddedEntry(this.shards, (Object)routing.id(), (Object)shard);
            return shard;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void removeShard(int shardId, String reason, Executor closeExecutor, ActionListener<Void> closeListener) {
            try {
                if (!this.shards.containsKey(shardId)) {
                    return;
                }
                HashMap<Integer, MockIndexShard> newShards = new HashMap<Integer, MockIndexShard>(this.shards);
                MockIndexShard indexShard = newShards.remove(shardId);
                assert (indexShard != null);
                this.shards = Collections.unmodifiableMap(newShards);
            }
            finally {
                closeListener.onResponse(null);
            }
        }

        public Iterator<MockIndexShard> iterator() {
            return this.shards.values().iterator();
        }
    }
}

