/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.elasticsearch.bootstrap.TestScopeResolver;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;
import org.elasticsearch.entitlement.runtime.policy.entitlements.Entitlement;
import org.elasticsearch.test.ESTestCase;

public class TestPolicyManager
extends PolicyManager {
    boolean isActive;
    boolean isTriviallyAllowingTestCode;
    String[] entitledTestPackages;
    final Map<Class<?>, PolicyManager.ModuleEntitlements> classEntitlementsMap = new ConcurrentHashMap();
    final Collection<Path> classpath;
    final Collection<URI> testOnlyClasspath;
    private static final String[] TEST_FRAMEWORK_PACKAGE_PREFIXES = new String[]{"org.gradle", "org.jcodings", "com.google.common.jimfs", "com.carrotsearch.randomizedtesting", "com.sun.tools.javac", "org.apache.lucene.tests", "org.junit", "org.mockito", "net.bytebuddy", "org.bouncycastle.jsse.provider"};

    public TestPolicyManager(Policy serverPolicy, List<Entitlement> apmAgentEntitlements, Map<String, Policy> pluginPolicies, Function<Class<?>, PolicyManager.PolicyScope> scopeResolver, PathLookup pathLookup, Collection<Path> classpath, Collection<URI> testOnlyClasspath) {
        super(serverPolicy, apmAgentEntitlements, pluginPolicies, scopeResolver, name -> classpath, pathLookup);
        this.classpath = classpath;
        this.testOnlyClasspath = testOnlyClasspath;
        this.resetAfterTest();
    }

    public void setActive(boolean newValue) {
        this.isActive = newValue;
    }

    public void setTriviallyAllowingTestCode(boolean newValue) {
        this.isTriviallyAllowingTestCode = newValue;
    }

    public void setEntitledTestPackages(String ... entitledTestPackages) {
        if (entitledTestPackages == null || entitledTestPackages.length == 0) {
            this.entitledTestPackages = TEST_FRAMEWORK_PACKAGE_PREFIXES;
            return;
        }
        TestPolicyManager.assertNoRedundantPrefixes(TEST_FRAMEWORK_PACKAGE_PREFIXES, entitledTestPackages, false);
        if (entitledTestPackages.length > 1) {
            TestPolicyManager.assertNoRedundantPrefixes(entitledTestPackages, entitledTestPackages, true);
        }
        Object[] packages = (String[])ArrayUtils.concat((Object[])TEST_FRAMEWORK_PACKAGE_PREFIXES, (Object[])entitledTestPackages);
        Arrays.sort(packages);
        this.entitledTestPackages = packages;
    }

    public final void resetAfterTest() {
        this.isActive = false;
        this.isTriviallyAllowingTestCode = true;
        this.entitledTestPackages = TEST_FRAMEWORK_PACKAGE_PREFIXES;
        this.clearModuleEntitlementsCache();
    }

    public final void clearModuleEntitlementsCache() {
        assert (this.moduleEntitlementsMap.isEmpty()) : "We're not supposed to be using moduleEntitlementsMap in tests";
        this.classEntitlementsMap.clear();
    }

    protected boolean isTrustedSystemClass(Class<?> requestingClass) {
        if (TestScopeResolver.getExcludedSystemPackageScope(requestingClass) != null) {
            return false;
        }
        ClassLoader loader = requestingClass.getClassLoader();
        return loader == null || loader == ClassLoader.getPlatformClassLoader();
    }

    boolean isTriviallyAllowed(Class<?> requestingClass) {
        if (!this.isActive) {
            return true;
        }
        if (this.isEntitlementClass(requestingClass)) {
            return true;
        }
        if (this.isTestFrameworkClass(requestingClass)) {
            return true;
        }
        if ("org.elasticsearch.jdk".equals(requestingClass.getPackageName())) {
            return true;
        }
        if ("org.elasticsearch.nativeaccess".equals(requestingClass.getPackageName())) {
            return true;
        }
        if (requestingClass.getPackageName().startsWith("org.elasticsearch.plugins")) {
            return true;
        }
        if (this.isTriviallyAllowingTestCode && this.isTestCode(requestingClass)) {
            return true;
        }
        return super.isTriviallyAllowed(requestingClass);
    }

    protected Collection<Path> getComponentPathsFromClass(Class<?> requestingClass) {
        return this.classpath;
    }

    private boolean isEntitlementClass(Class<?> requestingClass) {
        return requestingClass.getPackageName().startsWith("org.elasticsearch.entitlement") && !requestingClass.getName().contains("Test");
    }

    private boolean isTestFrameworkClass(Class<?> requestingClass) {
        return TestPolicyManager.isTestFrameworkClass(this.entitledTestPackages, requestingClass.getPackageName());
    }

    static boolean isTestFrameworkClass(String[] sortedPrefixes, String packageName) {
        String candidate;
        int idx = Arrays.binarySearch(sortedPrefixes, packageName);
        if (idx >= 0) {
            return true;
        }
        return (idx = -idx - 2) >= 0 && idx < sortedPrefixes.length && packageName.startsWith(candidate = sortedPrefixes[idx]) && (packageName.length() == candidate.length() || packageName.charAt(candidate.length()) == '.');
    }

    private static boolean isNotPrefixMatch(String name, String prefix, boolean discardExactMatch) {
        assert (!prefix.endsWith(".")) : "Invalid package prefix ending with '.' [" + prefix + "]";
        if (name == prefix || name.startsWith(prefix)) {
            if (name.length() == prefix.length()) {
                return discardExactMatch;
            }
            return false == (name.length() > prefix.length() && name.charAt(prefix.length()) == '.');
        }
        return true;
    }

    static void assertNoRedundantPrefixes(String[] setA, String[] setB, boolean discardExactMatch) {
        for (String a : setA) {
            for (String b : setB) {
                assert (TestPolicyManager.isNotPrefixMatch(a, b, discardExactMatch) && TestPolicyManager.isNotPrefixMatch(b, a, discardExactMatch)) : "Redundant prefix entries: [" + a + ", " + b + "]";
            }
        }
    }

    private boolean isTestCode(Class<?> requestingClass) {
        URI needle;
        for (Class<?> candidate = Objects.requireNonNull(requestingClass); candidate != null; candidate = candidate.getDeclaringClass()) {
            if (!ESTestCase.class.isAssignableFrom(candidate)) continue;
            return true;
        }
        ProtectionDomain protectionDomain = requestingClass.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return false;
        }
        try {
            needle = codeSource.getLocation().toURI();
            if (needle.getScheme().equals("jrt")) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        boolean result = this.testOnlyClasspath.contains(needle);
        return result;
    }

    protected PolicyManager.ModuleEntitlements getEntitlements(Class<?> requestingClass) {
        return this.classEntitlementsMap.computeIfAbsent(requestingClass, arg_0 -> ((TestPolicyManager)this).computeEntitlements(arg_0));
    }

    static {
        Arrays.sort(TEST_FRAMEWORK_PACKAGE_PREFIXES);
    }
}

