/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.bootstrap;

import java.io.Closeable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.lucene.tests.mockfile.FilterPath;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.entitlement.bootstrap.TestEntitlementBootstrap;
import org.elasticsearch.entitlement.bootstrap.TestPathLookup;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.TestPolicyManager;
import org.elasticsearch.env.Environment;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.test.ESTestCase;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestEntitlementsRule
implements TestRule {
    private static final Logger logger = LogManager.getLogger(TestEntitlementsRule.class);
    private static final AtomicBoolean active = new AtomicBoolean(false);
    private final TestPolicyManager policyManager = TestEntitlementBootstrap.testPolicyManager();
    private final TestPathLookup pathLookup = TestEntitlementBootstrap.testPathLookup();

    public TestEntitlementsRule() {
        assert (this.policyManager == null == (this.pathLookup == null));
    }

    public Statement apply(final Statement base, Description description) {
        assert (description.isSuite()) : "must be used as ClassRule";
        final boolean withoutEntitlements = description.getAnnotation(ESTestCase.WithoutEntitlements.class) != null;
        final boolean withEntitlementsOnTestCode = description.getAnnotation(ESTestCase.WithEntitlementsOnTestCode.class) != null;
        final ESTestCase.EntitledTestPackages entitledPackages = (ESTestCase.EntitledTestPackages)description.getAnnotation(ESTestCase.EntitledTestPackages.class);
        if (this.policyManager != null) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    if (active.compareAndSet(false, true)) {
                        try {
                            TestEntitlementsRule.this.pathLookup.reset();
                            TestEntitlementsRule.this.policyManager.setActive(false == withoutEntitlements);
                            TestEntitlementsRule.this.policyManager.setTriviallyAllowingTestCode(false == withEntitlementsOnTestCode);
                            if (entitledPackages != null) {
                                assert (entitledPackages.value().length > 0) : "No test packages specified in @EntitledTestPackages";
                                TestEntitlementsRule.this.policyManager.setEntitledTestPackages(entitledPackages.value());
                            } else {
                                TestEntitlementsRule.this.policyManager.setEntitledTestPackages(new String[0]);
                            }
                            TestEntitlementsRule.this.policyManager.clearModuleEntitlementsCache();
                            base.evaluate();
                        }
                        finally {
                            TestEntitlementsRule.this.pathLookup.reset();
                            TestEntitlementsRule.this.policyManager.resetAfterTest();
                            active.set(false);
                        }
                    } else {
                        throw new AssertionError((Object)"TestPolicyManager doesn't support test isolation, test suits cannot be run in parallel");
                    }
                }
            };
        }
        if (withEntitlementsOnTestCode) {
            throw new AssertionError((Object)"Cannot use @WithEntitlementsOnTestCode on tests that are not configured to use entitlements for testing");
        }
        return base;
    }

    public Closeable addEntitledNodePaths(Settings settings, Path configPath) {
        if (this.policyManager == null) {
            return () -> {};
        }
        Path unwrappedConfigPath = configPath;
        while (unwrappedConfigPath instanceof FilterPath) {
            FilterPath fPath = (FilterPath)unwrappedConfigPath;
            unwrappedConfigPath = fPath.getDelegate();
        }
        EntitledNodePaths entitledNodePaths = new EntitledNodePaths(settings, unwrappedConfigPath, this::removeEntitledNodePaths);
        this.addEntitledNodePaths(entitledNodePaths);
        return entitledNodePaths;
    }

    public void revokeAllEntitledNodePaths() {
        if (this.policyManager != null) {
            this.pathLookup.reset();
            this.policyManager.clearModuleEntitlementsCache();
        }
    }

    private void addEntitledNodePaths(EntitledNodePaths entitledNodePaths) {
        logger.debug("Adding {}", new Object[]{entitledNodePaths});
        this.pathLookup.add(PathLookup.BaseDir.CONFIG, entitledNodePaths.configDir());
        this.pathLookup.add(PathLookup.BaseDir.DATA, entitledNodePaths.dataDirs());
        this.pathLookup.add(PathLookup.BaseDir.SHARED_DATA, entitledNodePaths.sharedDataDir());
        this.pathLookup.add(PathLookup.BaseDir.SHARED_REPO, entitledNodePaths.repoDirs());
        this.policyManager.clearModuleEntitlementsCache();
    }

    private void removeEntitledNodePaths(EntitledNodePaths entitledNodePaths) {
        logger.debug("Removing {}", new Object[]{entitledNodePaths});
        this.pathLookup.remove(PathLookup.BaseDir.CONFIG, entitledNodePaths.configDir());
        this.pathLookup.remove(PathLookup.BaseDir.DATA, entitledNodePaths.dataDirs());
        this.pathLookup.remove(PathLookup.BaseDir.SHARED_DATA, entitledNodePaths.sharedDataDir());
        this.pathLookup.remove(PathLookup.BaseDir.SHARED_REPO, entitledNodePaths.repoDirs());
        this.policyManager.clearModuleEntitlementsCache();
    }

    private record EntitledNodePaths(Settings settings, Path configPath, Consumer<EntitledNodePaths> onClose) implements Closeable
    {
        private Path homeDir() {
            return EntitledNodePaths.absolutePath((String)Environment.PATH_HOME_SETTING.get(this.settings));
        }

        private Path configDir() {
            return this.configPath != null ? this.configPath : this.homeDir().resolve("config");
        }

        private Path[] dataDirs() {
            Path[] pathArray;
            List dataDirs = (List)Environment.PATH_DATA_SETTING.get(this.settings);
            if (dataDirs.isEmpty()) {
                Path[] pathArray2 = new Path[1];
                pathArray = pathArray2;
                pathArray2[0] = this.homeDir().resolve("data");
            } else {
                pathArray = (Path[])dataDirs.stream().map(EntitledNodePaths::absolutePath).toArray(Path[]::new);
            }
            return pathArray;
        }

        private Path[] sharedDataDir() {
            Path[] pathArray;
            String sharedDataDir = (String)Environment.PATH_SHARED_DATA_SETTING.get(this.settings);
            if (Strings.hasText((String)sharedDataDir)) {
                Path[] pathArray2 = new Path[1];
                pathArray = pathArray2;
                pathArray2[0] = EntitledNodePaths.absolutePath(sharedDataDir);
            } else {
                pathArray = new Path[]{};
            }
            return pathArray;
        }

        private Path[] repoDirs() {
            return (Path[])((List)Environment.PATH_REPO_SETTING.get(this.settings)).stream().map(EntitledNodePaths::absolutePath).toArray(Path[]::new);
        }

        @SuppressForbidden(reason="must be resolved using the default file system, rather then the mocked test file system")
        private static Path absolutePath(String path) {
            return Paths.get(path, new String[0]).toAbsolutePath().normalize();
        }

        @Override
        public void close() {
        }

        @Override
        public String toString() {
            return Strings.format((String)"EntitledNodePaths[configDir=%s, dataDirs=%s, sharedDataDir=%s, repoDirs=%s]", (Object[])new Object[]{this.configDir(), this.dataDirs(), this.sharedDataDir(), this.repoDirs()});
        }
    }
}

