/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.datageneration.datasource.DefaultFieldDataGeneratorHandler;
import org.elasticsearch.datageneration.datasource.DefaultMappingParametersHandler;
import org.elasticsearch.datageneration.datasource.DefaultObjectGenerationHandler;
import org.elasticsearch.datageneration.datasource.DefaultPrimitiveTypesHandler;
import org.elasticsearch.datageneration.datasource.DefaultWrappersHandler;

public class DataSource {
    private List<DataSourceHandler> handlers = new ArrayList<DataSourceHandler>();

    public DataSource(Collection<DataSourceHandler> additionalHandlers) {
        this.handlers.addAll(additionalHandlers);
        this.handlers.add(new DefaultFieldDataGeneratorHandler());
        this.handlers.add(new DefaultPrimitiveTypesHandler());
        this.handlers.add(new DefaultWrappersHandler());
        this.handlers.add(new DefaultObjectGenerationHandler());
        this.handlers.add(new DefaultMappingParametersHandler());
    }

    public <T extends DataSourceResponse> T get(DataSourceRequest<T> request) {
        for (DataSourceHandler handler : this.handlers) {
            T response = request.accept(handler);
            if (response == null) continue;
            return response;
        }
        throw new IllegalStateException("Request is not supported by data source");
    }
}

