/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.bootstrap.TestBuildInfo;
import org.elasticsearch.bootstrap.TestBuildInfoLocation;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public final class TestScopeResolver {
    private static final Logger logger = LogManager.getLogger(TestScopeResolver.class);
    private final Map<String, PolicyManager.PolicyScope> scopeMap;
    private static final Map<String, PolicyManager.PolicyScope> excludedSystemPackageScopes = TestScopeResolver.computeExcludedSystemPackageScopes();

    public TestScopeResolver(Map<String, PolicyManager.PolicyScope> scopeMap) {
        this.scopeMap = scopeMap;
    }

    private static Map<String, PolicyManager.PolicyScope> computeExcludedSystemPackageScopes() {
        Set systemModuleNames = ModuleFinder.ofSystem().findAll().stream().map(ref -> ref.descriptor().name()).filter(PolicyManager.MODULES_EXCLUDED_FROM_SYSTEM_MODULES::contains).collect(Collectors.toSet());
        TreeMap<String, PolicyManager.PolicyScope> result = new TreeMap<String, PolicyManager.PolicyScope>();
        ModuleLayer.boot().modules().stream().filter(m -> systemModuleNames.contains(m.getName())).forEach(m -> {
            ModuleDescriptor desc = m.getDescriptor();
            if (desc != null) {
                desc.packages().forEach(pkg -> result.put((String)pkg, new PolicyManager.PolicyScope(PolicyManager.ComponentKind.SERVER, PolicyManager.ComponentKind.SERVER.componentName, m.getName())));
            }
        });
        return result;
    }

    @Nullable
    public static PolicyManager.PolicyScope getExcludedSystemPackageScope(Class<?> callerClass) {
        return excludedSystemPackageScopes.get(callerClass.getPackageName());
    }

    PolicyManager.PolicyScope getScope(Class<?> callerClass) {
        CodeSource callerCodeSource = callerClass.getProtectionDomain().getCodeSource();
        if (callerCodeSource == null) {
            return Objects.requireNonNull(TestScopeResolver.getExcludedSystemPackageScope(callerClass));
        }
        String location = callerCodeSource.getLocation().toString();
        PolicyManager.PolicyScope scope = this.scopeMap.get(location);
        if (scope == null && callerClass.getPackageName().startsWith("org.bouncycastle")) {
            scope = new PolicyManager.PolicyScope(PolicyManager.ComponentKind.PLUGIN, "security", "ALL-UNNAMED");
            logger.debug("Assuming bouncycastle is part of the security plugin");
        }
        if (scope == null) {
            logger.warn("Cannot identify a scope for class [{}], location [{}]", new Object[]{callerClass.getName(), location});
            return PolicyManager.PolicyScope.unknown((String)location);
        }
        return scope;
    }

    public static Function<Class<?>, PolicyManager.PolicyScope> createScopeResolver(TestBuildInfo serverBuildInfo, List<TestBuildInfo> pluginsBuildInfo, Set<String> modularPlugins) {
        TreeMap<String, PolicyManager.PolicyScope> scopeMap = new TreeMap<String, PolicyManager.PolicyScope>();
        for (TestBuildInfo pluginBuildInfo : pluginsBuildInfo) {
            boolean isModular = modularPlugins.contains(pluginBuildInfo.component());
            for (TestBuildInfoLocation location : pluginBuildInfo.locations()) {
                URL codeSource = TestScopeResolver.class.getClassLoader().getResource(location.representativeClass());
                if (codeSource == null) {
                    throw new IllegalArgumentException("Cannot locate class [" + location.representativeClass() + "]");
                }
                try {
                    String module = isModular ? location.module() : "ALL-UNNAMED";
                    scopeMap.put(TestScopeResolver.getCodeSource(codeSource, location.representativeClass()), PolicyManager.PolicyScope.plugin((String)pluginBuildInfo.component(), (String)module));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Cannot locate class [" + location.representativeClass() + "]", e);
                }
            }
        }
        for (TestBuildInfoLocation location : serverBuildInfo.locations()) {
            URL classUrl = TestScopeResolver.class.getClassLoader().getResource(location.representativeClass());
            if (classUrl == null) {
                logger.debug("Representative class is unavailable; proceeding without {}", new Object[]{location});
                continue;
            }
            try {
                scopeMap.put(TestScopeResolver.getCodeSource(classUrl, location.representativeClass()), PolicyManager.PolicyScope.server((String)location.module()));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Cannot locate class [" + location.representativeClass() + "]", e);
            }
        }
        TestScopeResolver testScopeResolver = new TestScopeResolver(scopeMap);
        return testScopeResolver::getScope;
    }

    private static String getCodeSource(URL classUrl, String className) throws MalformedURLException {
        if (TestScopeResolver.isJarUrl(classUrl)) {
            return TestScopeResolver.extractJarFileUrl(classUrl).toString();
        }
        String s = classUrl.toString();
        return s.substring(0, s.indexOf(className));
    }

    private static boolean isJarUrl(URL url) {
        return "jar".equals(url.getProtocol());
    }

    @SuppressForbidden(reason="need file spec in string form to extract the inner URL form the JAR URL")
    private static URL extractJarFileUrl(URL jarUrl) throws MalformedURLException {
        String spec = jarUrl.getFile();
        int separator = spec.indexOf("!/");
        if (separator == -1) {
            throw new MalformedURLException();
        }
        return new URL(spec.substring(0, separator));
    }
}

