/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.proto;

import shadow.org.elasticsearch.xpack.sql.proto.SqlVersion;
import shadow.org.elasticsearch.xpack.sql.proto.SqlVersions;

public class VersionCompatibility {
    public static final SqlVersion INTRODUCING_VERSION_COMPATIBILITY = SqlVersions.V_7_7_0;
    public static final SqlVersion INTRODUCING_DATE_NANOS = SqlVersions.V_7_12_0;
    public static final SqlVersion INTRODUCING_UNSIGNED_LONG = SqlVersions.V_8_2_0;
    public static final SqlVersion INTRODUCING_WARNING_HANDLING = SqlVersions.V_8_2_0;
    public static final SqlVersion INTRODUCING_VERSION_FIELD_TYPE = SqlVersions.V_8_4_0;
    public static final SqlVersion INTRODUCING_VERSIONING_INDEPENDENT_FEATURES = SqlVersions.V_8_16_0;

    public static boolean hasVersionCompatibility(SqlVersion version) {
        return version.onOrAfter(INTRODUCING_VERSION_COMPATIBILITY);
    }

    public static boolean hasVersioningIndependentFeatures(SqlVersion version) {
        return version.onOrAfter(INTRODUCING_VERSIONING_INDEPENDENT_FEATURES);
    }

    public static boolean isClientCompatible(SqlVersion server, SqlVersion client) {
        if (VersionCompatibility.hasVersioningIndependentFeatures(client)) {
            return true;
        }
        return VersionCompatibility.hasVersionCompatibility(client) && server.onOrAfter(client) && server.major - client.major <= 1;
    }

    public static boolean supportsDateNanos(SqlVersion version) {
        return version.onOrAfter(INTRODUCING_DATE_NANOS);
    }

    public static boolean supportsUnsignedLong(SqlVersion version) {
        return version.onOrAfter(INTRODUCING_UNSIGNED_LONG);
    }

    public static boolean supportsVersionType(SqlVersion version) {
        return version.onOrAfter(INTRODUCING_VERSION_FIELD_TYPE);
    }
}

