/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.transport.netty4.CopyBytesServerSocketChannel;
import org.elasticsearch.transport.netty4.CopyBytesSocketChannel;
import org.elasticsearch.transport.netty4.Netty4NioSocketChannel;
import org.elasticsearch.transport.netty4.TrashingByteBuf;

public class NettyAllocator {
    private static final Logger logger;
    private static final AtomicBoolean descriptionLogged;
    private static final long SUGGESTED_MAX_ALLOCATION_SIZE;
    private static final ByteBufAllocator ALLOCATOR;
    private static final Recycler<BytesRef> RECYCLER;
    private static final String DESCRIPTION;
    private static final String USE_UNPOOLED = "es.use_unpooled_allocator";
    private static final String USE_NETTY_DEFAULT = "es.unsafe.use_netty_default_allocator";
    private static final String USE_NETTY_DEFAULT_CHUNK = "es.unsafe.use_netty_default_chunk_and_page_size";

    public static void logAllocatorDescriptionIfNeeded() {
        if (descriptionLogged.compareAndSet(false, true)) {
            logger.info("creating NettyAllocator with the following configs: " + NettyAllocator.getAllocatorDescription());
        }
    }

    public static ByteBufAllocator getAllocator() {
        return ALLOCATOR;
    }

    public static Recycler<BytesRef> getRecycler() {
        return RECYCLER;
    }

    public static long suggestedMaxAllocationSize() {
        return SUGGESTED_MAX_ALLOCATION_SIZE;
    }

    public static String getAllocatorDescription() {
        return DESCRIPTION;
    }

    public static Class<? extends Channel> getChannelType() {
        if (ALLOCATOR instanceof NoDirectBuffers) {
            return CopyBytesSocketChannel.class;
        }
        return Netty4NioSocketChannel.class;
    }

    public static Class<? extends ServerChannel> getServerChannelType() {
        if (ALLOCATOR instanceof NoDirectBuffers) {
            return CopyBytesServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    private static boolean useUnpooled(long heapSizeInBytes, boolean g1gcEnabled, boolean g1gcRegionSizeIsKnown, long g1RegionSize) {
        if (NettyAllocator.userForcedUnpooled()) {
            return true;
        }
        if (NettyAllocator.userForcedPooled()) {
            return false;
        }
        if (heapSizeInBytes <= 0x40000000L) {
            return true;
        }
        if (!g1gcEnabled) {
            return false;
        }
        boolean g1gcRegionIsLessThan1MB = g1RegionSize < 0x100000L;
        return g1gcRegionSizeIsKnown && g1gcRegionIsLessThan1MB;
    }

    private static boolean userForcedUnpooled() {
        if (System.getProperty(USE_UNPOOLED) != null) {
            return Booleans.parseBoolean((String)System.getProperty(USE_UNPOOLED));
        }
        return false;
    }

    private static boolean userForcedPooled() {
        if (System.getProperty(USE_UNPOOLED) != null) {
            return !Booleans.parseBoolean((String)System.getProperty(USE_UNPOOLED));
        }
        return false;
    }

    private static boolean useDefaultChunkAndPageSize() {
        if (System.getProperty(USE_NETTY_DEFAULT_CHUNK) != null) {
            return Booleans.parseBoolean((String)System.getProperty(USE_NETTY_DEFAULT_CHUNK));
        }
        return false;
    }

    static {
        ByteBufAllocator allocator;
        logger = LogManager.getLogger(NettyAllocator.class);
        descriptionLogged = new AtomicBoolean(false);
        if (Booleans.parseBoolean((String)System.getProperty(USE_NETTY_DEFAULT), (boolean)false)) {
            allocator = ByteBufAllocator.DEFAULT;
            SUGGESTED_MAX_ALLOCATION_SIZE = 0x100000L;
            DESCRIPTION = "[name=netty_default, suggested_max_allocation_size=" + String.valueOf(ByteSizeValue.ofBytes((long)SUGGESTED_MAX_ALLOCATION_SIZE)) + ", factors={es.unsafe.use_netty_default_allocator=true}]";
        } else {
            UnpooledByteBufAllocator delegate;
            long heapSizeInBytes = JvmInfo.jvmInfo().getMem().getHeapMax().getBytes();
            boolean g1gcEnabled = Boolean.parseBoolean(JvmInfo.jvmInfo().useG1GC());
            long g1gcRegionSizeInBytes = JvmInfo.jvmInfo().getG1RegionSize();
            boolean g1gcRegionSizeIsKnown = g1gcRegionSizeInBytes != -1L;
            ByteSizeValue heapSize = ByteSizeValue.ofBytes((long)heapSizeInBytes);
            ByteSizeValue g1gcRegionSize = ByteSizeValue.ofBytes((long)g1gcRegionSizeInBytes);
            if (NettyAllocator.useUnpooled(heapSizeInBytes, g1gcEnabled, g1gcRegionSizeIsKnown, g1gcRegionSizeInBytes)) {
                delegate = UnpooledByteBufAllocator.DEFAULT;
                SUGGESTED_MAX_ALLOCATION_SIZE = g1gcEnabled && g1gcRegionSizeIsKnown ? Math.max(g1gcRegionSizeInBytes >> 2, 262144L) : 0x100000L;
                DESCRIPTION = "[name=unpooled, suggested_max_allocation_size=" + String.valueOf(ByteSizeValue.ofBytes((long)SUGGESTED_MAX_ALLOCATION_SIZE)) + ", factors={es.unsafe.use_unpooled_allocator=" + System.getProperty(USE_UNPOOLED) + ", g1gc_enabled=" + g1gcEnabled + ", g1gc_region_size=" + String.valueOf(g1gcRegionSize) + ", heap_size=" + String.valueOf(heapSize) + "}]";
            } else {
                int maxOrder;
                int pageSize;
                int nHeapArena = PooledByteBufAllocator.defaultNumHeapArena();
                if (NettyAllocator.useDefaultChunkAndPageSize()) {
                    pageSize = PooledByteBufAllocator.defaultPageSize();
                    maxOrder = PooledByteBufAllocator.defaultMaxOrder();
                } else {
                    pageSize = 8192;
                    maxOrder = !g1gcEnabled || !g1gcRegionSizeIsKnown || g1gcRegionSizeInBytes >= 0x400000L ? 7 : (g1gcRegionSizeInBytes >= 0x200000L ? 6 : 5);
                }
                int smallCacheSize = PooledByteBufAllocator.defaultSmallCacheSize();
                int normalCacheSize = PooledByteBufAllocator.defaultNormalCacheSize();
                boolean useCacheForAllThreads = PooledByteBufAllocator.defaultUseCacheForAllThreads();
                delegate = new PooledByteBufAllocator(false, nHeapArena, 0, pageSize, maxOrder, smallCacheSize, normalCacheSize, useCacheForAllThreads);
                int chunkSizeInBytes = pageSize << maxOrder;
                ByteSizeValue chunkSize = ByteSizeValue.ofBytes((long)chunkSizeInBytes);
                SUGGESTED_MAX_ALLOCATION_SIZE = chunkSizeInBytes;
                DESCRIPTION = "[name=elasticsearch_configured, chunk_size=" + String.valueOf(chunkSize) + ", suggested_max_allocation_size=" + String.valueOf(ByteSizeValue.ofBytes((long)SUGGESTED_MAX_ALLOCATION_SIZE)) + ", factors={es.unsafe.use_netty_default_chunk_and_page_size=" + NettyAllocator.useDefaultChunkAndPageSize() + ", g1gc_enabled=" + g1gcEnabled + ", g1gc_region_size=" + String.valueOf(g1gcRegionSize) + "}]";
            }
            allocator = new NoDirectBuffers((ByteBufAllocator)delegate);
        }
        ALLOCATOR = Assertions.ENABLED ? new TrashingByteBufAllocator(allocator) : allocator;
        RECYCLER = new Recycler<BytesRef>(){

            public Recycler.V<BytesRef> obtain() {
                final ByteBuf byteBuf = ALLOCATOR.heapBuffer(16384, 16384);
                assert (byteBuf.hasArray());
                final BytesRef bytesRef = new BytesRef(byteBuf.array(), byteBuf.arrayOffset(), byteBuf.capacity());
                return new Recycler.V<BytesRef>(){

                    public BytesRef v() {
                        return bytesRef;
                    }

                    public boolean isRecycled() {
                        return true;
                    }

                    public void close() {
                        byteBuf.release();
                    }
                };
            }

            public int pageSize() {
                return 16384;
            }
        };
    }

    public static class NoDirectBuffers
    implements ByteBufAllocator {
        private final ByteBufAllocator delegate;

        private NoDirectBuffers(ByteBufAllocator delegate) {
            this.delegate = delegate;
        }

        public ByteBuf buffer() {
            return this.heapBuffer();
        }

        public ByteBuf buffer(int initialCapacity) {
            return this.heapBuffer(initialCapacity);
        }

        public ByteBuf buffer(int initialCapacity, int maxCapacity) {
            return this.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf ioBuffer() {
            return this.heapBuffer();
        }

        public ByteBuf ioBuffer(int initialCapacity) {
            return this.heapBuffer(initialCapacity);
        }

        public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
            return this.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf heapBuffer() {
            return this.delegate.heapBuffer();
        }

        public ByteBuf heapBuffer(int initialCapacity) {
            return this.delegate.heapBuffer(initialCapacity);
        }

        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            return this.delegate.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf directBuffer() {
            throw new UnsupportedOperationException("Direct buffers not supported");
        }

        public ByteBuf directBuffer(int initialCapacity) {
            throw new UnsupportedOperationException("Direct buffers not supported");
        }

        public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException("Direct buffers not supported");
        }

        public CompositeByteBuf compositeBuffer() {
            return this.compositeHeapBuffer();
        }

        public CompositeByteBuf compositeBuffer(int maxNumComponents) {
            return this.compositeHeapBuffer(maxNumComponents);
        }

        public CompositeByteBuf compositeHeapBuffer() {
            return this.delegate.compositeHeapBuffer();
        }

        public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
            return this.delegate.compositeHeapBuffer(maxNumComponents);
        }

        public CompositeByteBuf compositeDirectBuffer() {
            throw new UnsupportedOperationException("Direct buffers not supported.");
        }

        public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException("Direct buffers not supported.");
        }

        public boolean isDirectBufferPooled() {
            assert (!this.delegate.isDirectBufferPooled());
            return false;
        }

        public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
            return this.delegate.calculateNewCapacity(minNewCapacity, maxCapacity);
        }

        public ByteBufAllocator getDelegate() {
            return this.delegate;
        }
    }

    static class TrashingByteBufAllocator
    extends NoDirectBuffers {
        static int DEFAULT_MAX_COMPONENTS = 16;

        static void trashBuffer(ByteBuf buf) {
            for (ByteBuffer nioBuf : buf.nioBuffers()) {
                if (!nioBuf.hasArray()) continue;
                int from = nioBuf.arrayOffset() + nioBuf.position();
                int to = from + nioBuf.remaining();
                Arrays.fill(nioBuf.array(), from, to, (byte)0);
            }
        }

        TrashingByteBufAllocator(ByteBufAllocator delegate) {
            super(delegate);
        }

        @Override
        public ByteBuf heapBuffer() {
            return new TrashingByteBuf(super.heapBuffer());
        }

        @Override
        public ByteBuf heapBuffer(int initialCapacity) {
            return new TrashingByteBuf(super.heapBuffer(initialCapacity));
        }

        @Override
        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            return new TrashingByteBuf(super.heapBuffer(initialCapacity, maxCapacity));
        }

        @Override
        public CompositeByteBuf compositeHeapBuffer() {
            return new TrashingCompositeByteBuf(this, false, DEFAULT_MAX_COMPONENTS);
        }

        @Override
        public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
            return new TrashingCompositeByteBuf(this, false, maxNumComponents);
        }
    }

    static class TrashingCompositeByteBuf
    extends CompositeByteBuf {
        TrashingCompositeByteBuf(ByteBufAllocator alloc, boolean direct, int maxNumComponents) {
            super(alloc, direct, maxNumComponents);
        }

        protected void deallocate() {
            TrashingByteBufAllocator.trashBuffer((ByteBuf)this);
            super.deallocate();
        }
    }
}

