/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.index.search.QueryParserHelper;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;

public final class FieldNameTranslators {
    public static final String FLATTENED_METADATA_INDEX_FIELD_NAME = "metadata_flattened";
    public static final FieldNameTranslators API_KEY_FIELD_NAME_TRANSLATORS = new FieldNameTranslators(List.of(new SimpleFieldNameTranslator("creator.principal", "username"), new SimpleFieldNameTranslator("creator.realm", "realm_name"), new SimpleFieldNameTranslator("name", "name"), new SimpleFieldNameTranslator("runtime_key_type", "type"), new SimpleFieldNameTranslator("creation_time", "creation"), new SimpleFieldNameTranslator("expiration_time", "expiration"), new SimpleFieldNameTranslator("api_key_invalidated", "invalidated"), new SimpleFieldNameTranslator("invalidation_time", "invalidation"), new FlattenedFieldNameTranslator("metadata_flattened", "metadata")));
    public static final FieldNameTranslators USER_FIELD_NAME_TRANSLATORS = new FieldNameTranslators(List.of(FieldNameTranslators.idemFieldNameTranslator("username"), FieldNameTranslators.idemFieldNameTranslator("roles"), FieldNameTranslators.idemFieldNameTranslator("enabled"), FieldNameTranslators.idemFieldNameTranslator("full_name", false), FieldNameTranslators.idemFieldNameTranslator("email", false)));
    public static final FieldNameTranslators ROLE_FIELD_NAME_TRANSLATORS = new FieldNameTranslators(List.of(new SimpleFieldNameTranslator("runtime_role_name", "name"), FieldNameTranslators.idemFieldNameTranslator("description"), FieldNameTranslators.idemFieldNameTranslator("applications.application"), FieldNameTranslators.idemFieldNameTranslator("applications.resources"), FieldNameTranslators.idemFieldNameTranslator("applications.privileges"), new FlattenedFieldNameTranslator("metadata_flattened", "metadata")));
    private final List<FieldNameTranslator> fieldNameTranslators;

    private FieldNameTranslators(List<FieldNameTranslator> fieldNameTranslators) {
        this.fieldNameTranslators = fieldNameTranslators;
    }

    public QueryBuilder translateQueryBuilderFields(QueryBuilder queryBuilder, @Nullable Consumer<String> visitor) {
        Consumer<String> fieldNameVisitor;
        Objects.requireNonNull(queryBuilder, "unsupported \"null\" query builder for field name translation");
        Consumer<String> consumer = fieldNameVisitor = visitor != null ? visitor : ignored -> {};
        if (queryBuilder instanceof BoolQueryBuilder) {
            BoolQueryBuilder query = (BoolQueryBuilder)queryBuilder;
            BoolQueryBuilder newQuery = (BoolQueryBuilder)((BoolQueryBuilder)QueryBuilders.boolQuery().minimumShouldMatch(query.minimumShouldMatch()).adjustPureNegative(query.adjustPureNegative()).boost(query.boost())).queryName(query.queryName());
            query.must().stream().map(q -> this.translateQueryBuilderFields((QueryBuilder)q, fieldNameVisitor)).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).must(arg_0));
            query.should().stream().map(q -> this.translateQueryBuilderFields((QueryBuilder)q, fieldNameVisitor)).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).should(arg_0));
            query.mustNot().stream().map(q -> this.translateQueryBuilderFields((QueryBuilder)q, fieldNameVisitor)).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).mustNot(arg_0));
            query.filter().stream().map(q -> this.translateQueryBuilderFields((QueryBuilder)q, fieldNameVisitor)).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).filter(arg_0));
            return newQuery;
        }
        if (queryBuilder instanceof MatchAllQueryBuilder) {
            MatchAllQueryBuilder query = (MatchAllQueryBuilder)queryBuilder;
            return ((MatchAllQueryBuilder)QueryBuilders.matchAllQuery().boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof IdsQueryBuilder) {
            IdsQueryBuilder query = (IdsQueryBuilder)queryBuilder;
            return ((IdsQueryBuilder)QueryBuilders.idsQuery().addIds(query.ids().toArray(new String[0])).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof TermQueryBuilder) {
            TermQueryBuilder query = (TermQueryBuilder)queryBuilder;
            String translatedFieldName = this.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            return ((TermQueryBuilder)QueryBuilders.termQuery((String)translatedFieldName, (Object)query.value()).caseInsensitive(query.caseInsensitive()).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof ExistsQueryBuilder) {
            ExistsQueryBuilder query = (ExistsQueryBuilder)queryBuilder;
            String translatedFieldName = this.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            return ((ExistsQueryBuilder)QueryBuilders.existsQuery((String)translatedFieldName).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof TermsQueryBuilder) {
            TermsQueryBuilder query = (TermsQueryBuilder)queryBuilder;
            if (query.termsLookup() != null) {
                throw new IllegalArgumentException("terms query with terms lookup is not currently supported in this context");
            }
            String translatedFieldName = this.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            return ((TermsQueryBuilder)QueryBuilders.termsQuery((String)translatedFieldName, (Collection)query.getValues()).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof PrefixQueryBuilder) {
            PrefixQueryBuilder query = (PrefixQueryBuilder)queryBuilder;
            String translatedFieldName = this.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            return ((PrefixQueryBuilder)QueryBuilders.prefixQuery((String)translatedFieldName, (String)query.value()).caseInsensitive(query.caseInsensitive()).rewrite(query.rewrite()).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof WildcardQueryBuilder) {
            WildcardQueryBuilder query = (WildcardQueryBuilder)queryBuilder;
            String translatedFieldName = this.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            return ((WildcardQueryBuilder)QueryBuilders.wildcardQuery((String)translatedFieldName, (String)query.value()).caseInsensitive(query.caseInsensitive()).rewrite(query.rewrite()).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof MatchQueryBuilder) {
            MatchQueryBuilder query = (MatchQueryBuilder)queryBuilder;
            String translatedFieldName = this.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)translatedFieldName, (Object)query.value());
            if (query.operator() != null) {
                matchQueryBuilder.operator(query.operator());
            }
            if (query.analyzer() != null) {
                matchQueryBuilder.analyzer(query.analyzer());
            }
            if (query.fuzziness() != null) {
                matchQueryBuilder.fuzziness(query.fuzziness());
            }
            if (query.minimumShouldMatch() != null) {
                matchQueryBuilder.minimumShouldMatch(query.minimumShouldMatch());
            }
            if (query.fuzzyRewrite() != null) {
                matchQueryBuilder.fuzzyRewrite(query.fuzzyRewrite());
            }
            if (query.zeroTermsQuery() != null) {
                matchQueryBuilder.zeroTermsQuery(query.zeroTermsQuery());
            }
            ((MatchQueryBuilder)matchQueryBuilder.prefixLength(query.prefixLength()).maxExpansions(query.maxExpansions()).fuzzyTranspositions(query.fuzzyTranspositions()).lenient(query.lenient()).autoGenerateSynonymsPhraseQuery(query.autoGenerateSynonymsPhraseQuery()).boost(query.boost())).queryName(query.queryName());
            return matchQueryBuilder;
        }
        if (queryBuilder instanceof RangeQueryBuilder) {
            RangeQueryBuilder query = (RangeQueryBuilder)queryBuilder;
            if (query.relation() != null) {
                throw new IllegalArgumentException("range query with relation is not currently supported in this context");
            }
            String translatedFieldName = this.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            RangeQueryBuilder newQuery = QueryBuilders.rangeQuery((String)translatedFieldName);
            if (query.format() != null) {
                newQuery.format(query.format());
            }
            if (query.timeZone() != null) {
                newQuery.timeZone(query.timeZone());
            }
            if (query.from() != null) {
                newQuery.from(query.from()).includeLower(query.includeLower());
            }
            if (query.to() != null) {
                newQuery.to(query.to()).includeUpper(query.includeUpper());
            }
            return ((RangeQueryBuilder)newQuery.boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof SimpleQueryStringBuilder) {
            SimpleQueryStringBuilder query = (SimpleQueryStringBuilder)queryBuilder;
            SimpleQueryStringBuilder simpleQueryStringBuilder = QueryBuilders.simpleQueryStringQuery((String)query.value());
            HashMap<String, Float> queryFields = new HashMap<String, Float>(query.fields());
            if (queryFields.isEmpty()) {
                queryFields.put("*", Float.valueOf(1.0f));
            }
            if (QueryParserHelper.hasAllFieldsWildcard(queryFields.keySet())) {
                simpleQueryStringBuilder.lenient(true);
            } else {
                simpleQueryStringBuilder.lenient(query.lenient());
            }
            for (Map.Entry requestedFieldNameOrPattern : queryFields.entrySet()) {
                for (String translatedField : this.translatePattern((String)requestedFieldNameOrPattern.getKey())) {
                    simpleQueryStringBuilder.fields().compute(translatedField, (k, v) -> Float.valueOf(v == null ? ((Float)requestedFieldNameOrPattern.getValue()).floatValue() : v.floatValue() * ((Float)requestedFieldNameOrPattern.getValue()).floatValue()));
                    fieldNameVisitor.accept(translatedField);
                }
            }
            if (simpleQueryStringBuilder.fields().isEmpty()) {
                return ((MatchNoneQueryBuilder)new MatchNoneQueryBuilder().boost(simpleQueryStringBuilder.boost())).queryName(simpleQueryStringBuilder.queryName());
            }
            return ((SimpleQueryStringBuilder)simpleQueryStringBuilder.analyzer(query.analyzer()).defaultOperator(query.defaultOperator()).minimumShouldMatch(query.minimumShouldMatch()).flags(query.flags()).type(query.type()).quoteFieldSuffix(query.quoteFieldSuffix()).analyzeWildcard(query.analyzeWildcard()).autoGenerateSynonymsPhraseQuery(query.autoGenerateSynonymsPhraseQuery()).fuzzyTranspositions(query.fuzzyTranspositions()).fuzzyMaxExpansions(query.fuzzyMaxExpansions()).fuzzyPrefixLength(query.fuzzyPrefixLength()).boost(query.boost())).queryName(query.queryName());
        }
        throw new IllegalArgumentException("Query type [" + queryBuilder.getName() + "] is not currently supported in this context");
    }

    public void translateFieldSortBuilders(List<FieldSortBuilder> fieldSortBuilders, SearchSourceBuilder searchSourceBuilder, @Nullable Consumer<String> visitor) {
        Consumer<String> fieldNameVisitor = visitor != null ? visitor : ignored -> {};
        fieldSortBuilders.forEach(fieldSortBuilder -> {
            if (fieldSortBuilder.getNestedSort() != null) {
                throw new IllegalArgumentException("nested sorting is not currently supported in this context");
            }
            if ("_doc".equals(fieldSortBuilder.getFieldName())) {
                searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
            } else {
                String translatedFieldName = this.translate(fieldSortBuilder.getFieldName(), true);
                fieldNameVisitor.accept(translatedFieldName);
                if (translatedFieldName.equals(fieldSortBuilder.getFieldName())) {
                    searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
                } else {
                    FieldSortBuilder translatedFieldSortBuilder = ((FieldSortBuilder)new FieldSortBuilder(translatedFieldName).order(fieldSortBuilder.order())).missing(fieldSortBuilder.missing()).unmappedType(fieldSortBuilder.unmappedType()).setFormat(fieldSortBuilder.getFormat());
                    if (fieldSortBuilder.sortMode() != null) {
                        translatedFieldSortBuilder.sortMode(fieldSortBuilder.sortMode());
                    }
                    if (fieldSortBuilder.getNestedSort() != null) {
                        translatedFieldSortBuilder.setNestedSort(fieldSortBuilder.getNestedSort());
                    }
                    if (fieldSortBuilder.getNumericType() != null) {
                        translatedFieldSortBuilder.setNumericType(fieldSortBuilder.getNumericType());
                    }
                    searchSourceBuilder.sort((SortBuilder)translatedFieldSortBuilder);
                }
            }
        });
    }

    public String translate(String queryFieldName) {
        return this.translate(queryFieldName, false);
    }

    private String translate(String queryFieldName, boolean inSortContext) {
        if (Regex.isSimpleMatchPattern((String)queryFieldName)) {
            throw new IllegalArgumentException("Field name pattern [" + queryFieldName + "] is not allowed for querying or aggregation");
        }
        for (FieldNameTranslator translator : this.fieldNameTranslators) {
            if (!translator.isQueryFieldSupported(queryFieldName)) continue;
            if (inSortContext && !translator.isSortSupported()) {
                throw new IllegalArgumentException(Strings.format((String)"sorting is not supported for field [%s]", (Object[])new Object[]{queryFieldName}));
            }
            return translator.translate(queryFieldName);
        }
        throw new IllegalArgumentException("Field [" + queryFieldName + "] is not allowed for querying or aggregation");
    }

    public Set<String> translatePattern(String fieldNameOrPattern) {
        HashSet<String> indexFieldNames = new HashSet<String>();
        for (FieldNameTranslator translator : this.fieldNameTranslators) {
            if (!translator.isQueryFieldSupported(fieldNameOrPattern)) continue;
            indexFieldNames.add(translator.translate(fieldNameOrPattern));
        }
        return indexFieldNames;
    }

    public boolean isQueryFieldSupported(String fieldName) {
        return this.fieldNameTranslators.stream().anyMatch(t -> t.isQueryFieldSupported(fieldName));
    }

    public boolean isIndexFieldSupported(String fieldName) {
        return this.fieldNameTranslators.stream().anyMatch(t -> t.isIndexFieldSupported(fieldName));
    }

    private static SimpleFieldNameTranslator idemFieldNameTranslator(String fieldName) {
        return new SimpleFieldNameTranslator(fieldName, fieldName);
    }

    private static SimpleFieldNameTranslator idemFieldNameTranslator(String fieldName, boolean isSortSupported) {
        return new SimpleFieldNameTranslator(fieldName, fieldName, isSortSupported);
    }

    private static interface FieldNameTranslator {
        public String translate(String var1);

        public boolean isQueryFieldSupported(String var1);

        public boolean isIndexFieldSupported(String var1);

        public boolean isSortSupported();
    }

    private static class SimpleFieldNameTranslator
    implements FieldNameTranslator {
        private final String indexFieldName;
        private final String queryFieldName;
        private final boolean isSortSupported;

        SimpleFieldNameTranslator(String indexFieldName, String queryFieldName, boolean isSortSupported) {
            this.indexFieldName = indexFieldName;
            this.queryFieldName = queryFieldName;
            this.isSortSupported = isSortSupported;
        }

        SimpleFieldNameTranslator(String indexFieldName, String queryFieldName) {
            this(indexFieldName, queryFieldName, true);
        }

        @Override
        public boolean isQueryFieldSupported(String fieldNameOrPattern) {
            if (Regex.isSimpleMatchPattern((String)fieldNameOrPattern)) {
                return Regex.simpleMatch((String)fieldNameOrPattern, (String)this.queryFieldName);
            }
            return this.queryFieldName.equals(fieldNameOrPattern);
        }

        @Override
        public boolean isIndexFieldSupported(String fieldName) {
            return fieldName.equals(this.indexFieldName);
        }

        @Override
        public String translate(String fieldNameOrPattern) {
            return this.indexFieldName;
        }

        @Override
        public boolean isSortSupported() {
            return this.isSortSupported;
        }
    }

    private static class FlattenedFieldNameTranslator
    implements FieldNameTranslator {
        private final String indexFieldName;
        private final String queryFieldName;

        FlattenedFieldNameTranslator(String indexFieldName, String queryFieldName) {
            this.indexFieldName = indexFieldName;
            this.queryFieldName = queryFieldName;
        }

        @Override
        public boolean isQueryFieldSupported(String fieldNameOrPattern) {
            if (Regex.isSimpleMatchPattern((String)fieldNameOrPattern)) {
                return Regex.simpleMatch((String)fieldNameOrPattern, (String)this.queryFieldName);
            }
            return fieldNameOrPattern.equals(this.queryFieldName) || fieldNameOrPattern.startsWith(this.queryFieldName + ".");
        }

        @Override
        public boolean isIndexFieldSupported(String fieldName) {
            return fieldName.equals(this.indexFieldName) || fieldName.startsWith(this.indexFieldName + ".");
        }

        @Override
        public String translate(String fieldNameOrPattern) {
            if (Regex.isSimpleMatchPattern((String)fieldNameOrPattern) || fieldNameOrPattern.equals(this.queryFieldName)) {
                return this.indexFieldName;
            }
            assert (fieldNameOrPattern.startsWith(this.queryFieldName + "."));
            return this.indexFieldName + fieldNameOrPattern.substring(this.queryFieldName.length());
        }

        @Override
        public boolean isSortSupported() {
            return true;
        }
    }
}

