/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.saml;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.saml.SamlPrepareAuthenticationAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlPrepareAuthenticationRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlPrepareAuthenticationResponse;
import org.elasticsearch.xpack.security.rest.action.saml.SamlBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestSamlPrepareAuthenticationAction
extends SamlBaseRestHandler {
    static final ObjectParser<SamlPrepareAuthenticationRequest, Void> PARSER = new ObjectParser("saml_prepare_authn", SamlPrepareAuthenticationRequest::new);

    public RestSamlPrepareAuthenticationAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/saml/prepare").replaces(RestRequest.Method.POST, "/_xpack/security/saml/prepare", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_saml_prepare_authentication_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            SamlPrepareAuthenticationRequest authenticationRequest = (SamlPrepareAuthenticationRequest)PARSER.parse(parser, null);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)SamlPrepareAuthenticationAction.INSTANCE, (ActionRequest)authenticationRequest, (ActionListener)new RestBuilderListener<SamlPrepareAuthenticationResponse>(channel){

                public RestResponse buildResponse(SamlPrepareAuthenticationResponse response, XContentBuilder builder) throws Exception {
                    builder.startObject();
                    builder.field("realm", response.getRealmName());
                    builder.field("id", response.getRequestId());
                    builder.field("redirect", response.getRedirectUrl());
                    builder.endObject();
                    return new RestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareString(SamlPrepareAuthenticationRequest::setAssertionConsumerServiceURL, new ParseField("acs", new String[0]));
        PARSER.declareString(SamlPrepareAuthenticationRequest::setRealmName, new ParseField("realm", new String[0]));
        PARSER.declareString(SamlPrepareAuthenticationRequest::setRelayState, new ParseField("relay_state", new String[0]));
    }
}

