/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.rolemapping;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequestBuilder;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingResponse;
import org.elasticsearch.xpack.security.rest.action.rolemapping.NativeRoleMappingBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestPutRoleMappingAction
extends NativeRoleMappingBaseRestHandler {
    public RestPutRoleMappingAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/role_mapping/{name}").replaces(RestRequest.Method.POST, "/_xpack/security/role_mapping/{name}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_security/role_mapping/{name}").replaces(RestRequest.Method.PUT, "/_xpack/security/role_mapping/{name}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_put_role_mappings_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutRoleMappingRequestBuilder requestBuilder;
        String name = request.param("name");
        String refresh = request.param("refresh");
        try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)request.requiredContent(), (XContentType)request.getXContentType());){
            requestBuilder = (PutRoleMappingRequestBuilder)new PutRoleMappingRequestBuilder((ElasticsearchClient)client).source(name, parser).setRefreshPolicy(refresh);
        }
        return channel -> requestBuilder.execute((ActionListener)new RestBuilderListener<PutRoleMappingResponse>(channel){

            public RestResponse buildResponse(PutRoleMappingResponse response, XContentBuilder builder) throws Exception {
                return new RestResponse(RestStatus.OK, builder.startObject().field("role_mapping", (ToXContent)response).endObject());
            }
        });
    }
}

