/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.time.Clock;
import java.time.Instant;
import java.util.Date;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.security.authc.jwt.JwtFieldValidator;

public class JwtDateClaimValidator
implements JwtFieldValidator {
    private final Clock clock;
    private final String claimName;
    private final long allowedClockSkewSeconds;
    private final Relationship relationship;
    private final boolean allowNull;

    public JwtDateClaimValidator(Clock clock, String claimName, TimeValue allowedClockSkew, Relationship relationship, boolean allowNull) {
        this.clock = clock;
        this.claimName = claimName;
        this.allowedClockSkewSeconds = allowedClockSkew.seconds();
        this.relationship = relationship;
        this.allowNull = allowNull;
    }

    @Override
    public void validate(JWSHeader jwsHeader, JWTClaimsSet jwtClaimsSet) {
        Date claimValue;
        try {
            claimValue = jwtClaimsSet.getDateClaim(this.claimName);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("cannot parse date claim [" + this.claimName + "]", e);
        }
        if (claimValue == null) {
            if (this.allowNull) {
                return;
            }
            throw new IllegalArgumentException("missing required date claim [" + this.claimName + "]");
        }
        Instant claimInstant = claimValue.toInstant();
        Instant now = this.clock.instant();
        switch (this.relationship) {
            case BEFORE_NOW: {
                if (claimInstant.isBefore(now.plusSeconds(this.allowedClockSkewSeconds))) break;
                throw new IllegalArgumentException(Strings.format((String)"date claim [%s] value [%s] must be before now [%s]", (Object[])new Object[]{this.claimName, claimInstant.toEpochMilli(), now.toEpochMilli()}));
            }
            case AFTER_NOW: {
                if (claimInstant.isAfter(now.minusSeconds(this.allowedClockSkewSeconds))) break;
                throw new IllegalArgumentException(Strings.format((String)"date claim [%s] value [%s] must be after now [%s]", (Object[])new Object[]{this.claimName, claimInstant.toEpochMilli(), now.toEpochMilli()}));
            }
            default: {
                assert (false) : "unknown date claim relationship " + String.valueOf((Object)this.relationship);
                throw new IllegalStateException("unknown date claim relationship");
            }
        }
    }

    public static enum Relationship {
        BEFORE_NOW,
        AFTER_NOW;

    }
}

