/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleResponse;
import org.elasticsearch.xpack.security.authz.ReservedRoleNameChecker;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportDeleteRoleAction
extends TransportAction<DeleteRoleRequest, DeleteRoleResponse> {
    private final NativeRolesStore rolesStore;
    private final ReservedRoleNameChecker reservedRoleNameChecker;

    @Inject
    public TransportDeleteRoleAction(ActionFilters actionFilters, NativeRolesStore rolesStore, TransportService transportService, ReservedRoleNameChecker reservedRoleNameChecker) {
        super("cluster:admin/xpack/security/role/delete", actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.rolesStore = rolesStore;
        this.reservedRoleNameChecker = reservedRoleNameChecker;
    }

    protected void doExecute(Task task, DeleteRoleRequest request, ActionListener<DeleteRoleResponse> listener) {
        if (this.reservedRoleNameChecker.isReserved(request.name())) {
            listener.onFailure((Exception)new IllegalArgumentException("role [" + request.name() + "] is reserved and cannot be deleted"));
            return;
        }
        try {
            this.rolesStore.deleteRole(request, (ActionListener<Boolean>)listener.safeMap(DeleteRoleResponse::new));
        }
        catch (Exception e) {
            this.logger.error(() -> "failed to delete role [" + request.name() + "]", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

