/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.transport.TransportRequest;

public class SecurityActionMapper {
    static final String CLUSTER_PERMISSION_SCROLL_CLEAR_ALL_NAME = "cluster:admin/indices/scroll/clear_all";
    static final String CLUSTER_PERMISSION_ANALYZE = "cluster:admin/analyze";
    static final String CLUSTER_PERMISSION_PAINLESS_EXECUTE = "cluster:admin/scripts/painless/execute";

    public static String action(String action, TransportRequest request) {
        switch (action) {
            case "indices:data/read/scroll/clear": {
                assert (request instanceof ClearScrollRequest);
                boolean isClearAllScrollRequest = ((ClearScrollRequest)request).scrollIds().contains("_all");
                if (!isClearAllScrollRequest) break;
                return CLUSTER_PERMISSION_SCROLL_CLEAR_ALL_NAME;
            }
            case "indices:admin/analyze": 
            case "indices:admin/analyze[s]": {
                assert (request instanceof AnalyzeAction.Request);
                String[] indices = ((AnalyzeAction.Request)request).indices();
                if (indices != null && (indices.length != 1 || indices[0] != null)) break;
                return CLUSTER_PERMISSION_ANALYZE;
            }
            case "cluster:admin/scripts/painless/execute": 
            case "cluster:admin/scripts/painless/execute[s]": {
                assert (request instanceof SingleShardRequest);
                String index = ((SingleShardRequest)request).index();
                if (index == null) break;
                return action.replace("cluster:admin", "indices:data/read");
            }
        }
        return action;
    }
}

