/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.UntypedArray;
import com.microsoft.kiota.serialization.UntypedBoolean;
import com.microsoft.kiota.serialization.UntypedDouble;
import com.microsoft.kiota.serialization.UntypedNode;
import com.microsoft.kiota.serialization.UntypedNull;
import com.microsoft.kiota.serialization.UntypedObject;
import com.microsoft.kiota.serialization.UntypedString;
import com.microsoft.kiota.serialization.ValuedEnumParser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class JsonParseNode
implements ParseNode {
    private final JsonElement currentNode;
    private Consumer<Parsable> onBeforeAssignFieldValues;
    private Consumer<Parsable> onAfterAssignFieldValues;

    public JsonParseNode(@Nonnull JsonElement node) {
        this.currentNode = Objects.requireNonNull(node, "parameter node cannot be null");
    }

    @Override
    @Nullable
    public ParseNode getChildNode(@Nonnull String identifier) {
        Objects.requireNonNull(identifier, "identifier parameter is required");
        if (this.currentNode.isJsonObject()) {
            JsonObject object = this.currentNode.getAsJsonObject();
            JsonElement childNodeElement = object.get(identifier);
            if (childNodeElement == null) {
                return null;
            }
            JsonParseNode result = new JsonParseNode(childNodeElement);
            result.setOnBeforeAssignFieldValues(this.onBeforeAssignFieldValues);
            result.setOnAfterAssignFieldValues(this.onAfterAssignFieldValues);
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public String getStringValue() {
        return this.currentNode.isJsonPrimitive() ? this.currentNode.getAsString() : null;
    }

    @Override
    @Nullable
    public Boolean getBooleanValue() {
        return this.currentNode.isJsonPrimitive() ? Boolean.valueOf(this.currentNode.getAsBoolean()) : null;
    }

    @Override
    @Nullable
    public Byte getByteValue() {
        return this.currentNode.isJsonPrimitive() ? Byte.valueOf(this.currentNode.getAsByte()) : null;
    }

    @Override
    @Nullable
    public Short getShortValue() {
        return this.currentNode.isJsonPrimitive() ? Short.valueOf(this.currentNode.getAsShort()) : null;
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimalValue() {
        return this.currentNode.isJsonPrimitive() ? this.currentNode.getAsBigDecimal() : null;
    }

    @Override
    @Nullable
    public Integer getIntegerValue() {
        return this.currentNode.isJsonPrimitive() ? Integer.valueOf(this.currentNode.getAsInt()) : null;
    }

    @Override
    @Nullable
    public Float getFloatValue() {
        return this.currentNode.isJsonPrimitive() ? Float.valueOf(this.currentNode.getAsFloat()) : null;
    }

    @Override
    @Nullable
    public Double getDoubleValue() {
        return this.currentNode.isJsonPrimitive() ? Double.valueOf(this.currentNode.getAsDouble()) : null;
    }

    @Override
    @Nullable
    public Long getLongValue() {
        return this.currentNode.isJsonPrimitive() ? Long.valueOf(this.currentNode.getAsLong()) : null;
    }

    @Override
    @Nullable
    public UUID getUUIDValue() {
        String stringValue = this.currentNode.getAsString();
        if (stringValue == null) {
            return null;
        }
        return UUID.fromString(stringValue);
    }

    @Override
    @Nullable
    public OffsetDateTime getOffsetDateTimeValue() {
        String stringValue = this.currentNode.getAsString();
        if (stringValue == null) {
            return null;
        }
        try {
            return OffsetDateTime.parse(stringValue);
        }
        catch (DateTimeParseException ex) {
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(stringValue);
                return localDateTime.atOffset(ZoneOffset.UTC);
            }
            catch (DateTimeParseException ex2) {
                throw ex;
            }
        }
    }

    @Override
    @Nullable
    public LocalDate getLocalDateValue() {
        String stringValue = this.currentNode.getAsString();
        if (stringValue == null) {
            return null;
        }
        return LocalDate.parse(stringValue);
    }

    @Override
    @Nullable
    public LocalTime getLocalTimeValue() {
        String stringValue = this.currentNode.getAsString();
        if (stringValue == null) {
            return null;
        }
        return LocalTime.parse(stringValue);
    }

    @Override
    @Nullable
    public PeriodAndDuration getPeriodAndDurationValue() {
        String stringValue = this.currentNode.getAsString();
        if (stringValue == null) {
            return null;
        }
        return PeriodAndDuration.parse(stringValue);
    }

    @Nullable
    private <T> T getPrimitiveValue(@Nonnull Class<T> targetClass, @Nonnull JsonParseNode itemNode) {
        if (targetClass == Boolean.class) {
            return (T)itemNode.getBooleanValue();
        }
        if (targetClass == Short.class) {
            return (T)itemNode.getShortValue();
        }
        if (targetClass == Byte.class) {
            return (T)itemNode.getByteValue();
        }
        if (targetClass == BigDecimal.class) {
            return (T)itemNode.getBigDecimalValue();
        }
        if (targetClass == String.class) {
            return (T)itemNode.getStringValue();
        }
        if (targetClass == Integer.class) {
            return (T)itemNode.getIntegerValue();
        }
        if (targetClass == Float.class) {
            return (T)itemNode.getFloatValue();
        }
        if (targetClass == Long.class) {
            return (T)itemNode.getLongValue();
        }
        if (targetClass == UUID.class) {
            return (T)itemNode.getUUIDValue();
        }
        if (targetClass == OffsetDateTime.class) {
            return (T)itemNode.getOffsetDateTimeValue();
        }
        if (targetClass == LocalDate.class) {
            return (T)itemNode.getLocalDateValue();
        }
        if (targetClass == LocalTime.class) {
            return (T)itemNode.getLocalTimeValue();
        }
        if (targetClass == PeriodAndDuration.class) {
            return (T)itemNode.getPeriodAndDurationValue();
        }
        throw new RuntimeException("unknown type to deserialize " + targetClass.getName());
    }

    private <T> List<T> iterateOnArray(JsonElement jsonElement, Function<JsonParseNode, T> fn) {
        JsonArray array = jsonElement.getAsJsonArray();
        Iterator sourceIterator = array.iterator();
        ArrayList<T> result = new ArrayList<T>();
        while (sourceIterator.hasNext()) {
            JsonElement item = (JsonElement)sourceIterator.next();
            JsonParseNode itemNode = new JsonParseNode(item);
            itemNode.setOnBeforeAssignFieldValues(this.getOnBeforeAssignFieldValues());
            itemNode.setOnAfterAssignFieldValues(this.getOnAfterAssignFieldValues());
            result.add(fn.apply(itemNode));
        }
        return result;
    }

    @Override
    @Nullable
    public <T> List<T> getCollectionOfPrimitiveValues(@Nonnull Class<T> targetClass) {
        Objects.requireNonNull(targetClass, "parameter targetClass cannot be null");
        if (this.currentNode.isJsonNull()) {
            return null;
        }
        if (this.currentNode.isJsonArray()) {
            return this.iterateOnArray(this.currentNode, itemNode -> this.getPrimitiveValue(targetClass, (JsonParseNode)itemNode));
        }
        throw new RuntimeException("invalid state expected to have an array node");
    }

    @Override
    @Nullable
    public <T extends Parsable> List<T> getCollectionOfObjectValues(@Nonnull ParsableFactory<T> factory) {
        Objects.requireNonNull(factory, "parameter factory cannot be null");
        if (this.currentNode.isJsonNull()) {
            return null;
        }
        if (this.currentNode.isJsonArray()) {
            return this.iterateOnArray(this.currentNode, itemNode -> itemNode.getObjectValue(factory));
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends Enum<T>> List<T> getCollectionOfEnumValues(@Nonnull ValuedEnumParser<T> enumParser) {
        Objects.requireNonNull(enumParser, "parameter enumParser cannot be null");
        if (this.currentNode.isJsonNull()) {
            return null;
        }
        if (this.currentNode.isJsonArray()) {
            return this.iterateOnArray(this.currentNode, itemNode -> itemNode.getEnumValue(enumParser));
        }
        throw new RuntimeException("invalid state expected to have an array node");
    }

    @Override
    @Nonnull
    public <T extends Parsable> T getObjectValue(@Nonnull ParsableFactory<T> factory) {
        Objects.requireNonNull(factory, "parameter factory cannot be null");
        T item = factory.create(this);
        if (item.getClass() == UntypedNode.class) {
            return (T)this.getUntypedValue();
        }
        this.assignFieldValues(item, item.getFieldDeserializers());
        return item;
    }

    @Nonnull
    private UntypedNode getUntypedValue() {
        return this.getUntypedValue(this.currentNode);
    }

    @Nonnull
    private UntypedNode getUntypedValue(JsonElement element) {
        if (element.isJsonNull()) {
            return new UntypedNull();
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return new UntypedBoolean(primitive.getAsBoolean());
            }
            if (primitive.isString()) {
                return new UntypedString(primitive.getAsString());
            }
            if (primitive.isNumber()) {
                return new UntypedDouble(primitive.getAsDouble());
            }
            throw new RuntimeException("Could not get the value during deserialization, unknown primitive type");
        }
        if (element.isJsonObject()) {
            HashMap<String, UntypedNode> propertiesMap = new HashMap<String, UntypedNode>();
            for (Map.Entry fieldEntry : element.getAsJsonObject().entrySet()) {
                String fieldKey = (String)fieldEntry.getKey();
                JsonElement fieldValue = (JsonElement)fieldEntry.getValue();
                JsonParseNode childNode = new JsonParseNode(fieldValue);
                childNode.setOnBeforeAssignFieldValues(this.getOnBeforeAssignFieldValues());
                childNode.setOnAfterAssignFieldValues(this.getOnAfterAssignFieldValues());
                propertiesMap.put(fieldKey, childNode.getUntypedValue());
            }
            return new UntypedObject(propertiesMap);
        }
        if (element.isJsonArray()) {
            return new UntypedArray(this.iterateOnArray(element, JsonParseNode::getUntypedValue));
        }
        throw new RuntimeException("Could not get the value during deserialization, unknown json value type");
    }

    @Override
    @Nullable
    public <T extends Enum<T>> T getEnumValue(@Nonnull ValuedEnumParser<T> enumParser) {
        String rawValue = this.getStringValue();
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        return enumParser.forValue(rawValue);
    }

    @Override
    @Nullable
    public <T extends Enum<T>> EnumSet<T> getEnumSetValue(@Nonnull ValuedEnumParser<T> enumParser) {
        String[] rawValues;
        String rawValue = this.getStringValue();
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (String rawValueItem : rawValues = rawValue.split(",")) {
            T value = enumParser.forValue(rawValueItem);
            if (value == null) continue;
            result.add(value);
        }
        return EnumSet.copyOf(result);
    }

    private <T extends Parsable> void assignFieldValues(T item, Map<String, Consumer<ParseNode>> fieldDeserializers) {
        if (this.currentNode.isJsonObject()) {
            if (this.onBeforeAssignFieldValues != null) {
                this.onBeforeAssignFieldValues.accept(item);
            }
            Map<String, Object> itemAdditionalData = null;
            if (item instanceof AdditionalDataHolder) {
                itemAdditionalData = ((AdditionalDataHolder)((Object)item)).getAdditionalData();
            }
            for (Map.Entry fieldEntry : this.currentNode.getAsJsonObject().entrySet()) {
                String fieldKey = (String)fieldEntry.getKey();
                Consumer<ParseNode> fieldDeserializer = fieldDeserializers.get(fieldKey);
                JsonElement fieldValue = (JsonElement)fieldEntry.getValue();
                if (fieldValue.isJsonNull()) continue;
                if (fieldDeserializer != null) {
                    JsonParseNode itemNode = new JsonParseNode(fieldValue);
                    itemNode.setOnBeforeAssignFieldValues(this.onBeforeAssignFieldValues);
                    itemNode.setOnAfterAssignFieldValues(this.onAfterAssignFieldValues);
                    fieldDeserializer.accept(itemNode);
                    continue;
                }
                if (itemAdditionalData == null) continue;
                itemAdditionalData.put(fieldKey, this.tryGetAnything(fieldValue));
            }
            if (this.onAfterAssignFieldValues != null) {
                this.onAfterAssignFieldValues.accept(item);
            }
        }
    }

    private Object tryGetAnything(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isNumber()) {
                return primitive.getAsDouble();
            }
            throw new RuntimeException("Could not get the value during deserialization, unknown primitive type");
        }
        if (element.isJsonObject() || element.isJsonArray()) {
            return this.getUntypedValue(element);
        }
        throw new RuntimeException("Could not get the value during deserialization, unknown primitive type");
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnBeforeAssignFieldValues() {
        return this.onBeforeAssignFieldValues;
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnAfterAssignFieldValues() {
        return this.onAfterAssignFieldValues;
    }

    @Override
    public void setOnBeforeAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onBeforeAssignFieldValues = value;
    }

    @Override
    public void setOnAfterAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onAfterAssignFieldValues = value;
    }

    @Override
    @Nullable
    public byte[] getByteArrayValue() {
        String base64 = this.getStringValue();
        if (base64 == null || base64.isEmpty()) {
            return null;
        }
        return Base64.getDecoder().decode(base64);
    }
}

