/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.imds.internal;

import java.net.URI;
import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.util.SystemUserAgent;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;

@SdkInternalApi
public class RequestMarshaller {
    public static final String TOKEN_RESOURCE_PATH = "/latest/api/token";
    public static final String TOKEN_HEADER = "x-aws-ec2-metadata-token";
    public static final String EC2_METADATA_TOKEN_TTL_HEADER = "x-aws-ec2-metadata-token-ttl-seconds";
    public static final String USER_AGENT = "user_agent";
    public static final String ACCEPT = "Accept";
    public static final String CONNECTION = "connection";
    private final URI basePath;
    private final URI tokenPath;

    public RequestMarshaller(URI basePath) {
        this.basePath = basePath;
        this.tokenPath = URI.create(basePath + TOKEN_RESOURCE_PATH);
    }

    public SdkHttpFullRequest createTokenRequest(Duration tokenTtl) {
        return this.defaulttHttpBuilder().method(SdkHttpMethod.PUT).uri(this.tokenPath).putHeader(EC2_METADATA_TOKEN_TTL_HEADER, String.valueOf(tokenTtl.getSeconds())).build();
    }

    public SdkHttpFullRequest createDataRequest(String path, String token, Duration tokenTtl) {
        URI resourcePath = URI.create(this.basePath + path);
        return this.defaulttHttpBuilder().method(SdkHttpMethod.GET).uri(resourcePath).putHeader(EC2_METADATA_TOKEN_TTL_HEADER, String.valueOf(tokenTtl.getSeconds())).putHeader(TOKEN_HEADER, token).build();
    }

    private SdkHttpFullRequest.Builder defaulttHttpBuilder() {
        return SdkHttpFullRequest.builder().putHeader(USER_AGENT, SystemUserAgent.getOrCreate().userAgentString()).putHeader(ACCEPT, "*/*").putHeader(CONNECTION, "keep-alive");
    }
}

