/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import org.elasticsearch.hadoop.util.BytesArray;

class UnicodeUtil {
    public static final int UNI_SUR_HIGH_START = 55296;
    public static final int UNI_SUR_HIGH_END = 56319;
    public static final int UNI_SUR_LOW_START = 56320;
    public static final int UNI_SUR_LOW_END = 57343;
    public static final int UNI_REPLACEMENT_CHAR = 65533;
    private static final long HALF_SHIFT = 10L;
    private static final int SURROGATE_OFFSET = -56613888;

    private UnicodeUtil() {
    }

    static void UTF16toUTF8(CharSequence s, int offset, int length, BytesArray result) {
        int end = offset + length;
        result.size = 0;
        byte[] out = result.bytes;
        int maxLen = length * 4;
        if (out.length < maxLen) {
            out = result.bytes = new byte[maxLen];
        }
        int upto = 0;
        for (int i = offset; i < end; ++i) {
            int utf32;
            char code = s.charAt(i);
            if (code < '\u0080') {
                out[upto++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto++] = (byte)(0xC0 | code >> 6);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto++] = (byte)(0xE0 | code >> 12);
                out[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= 56320 && utf32 <= 57343) {
                utf32 = (code << 10) + utf32 + -56613888;
                ++i;
                out[upto++] = (byte)(0xF0 | utf32 >> 18);
                out[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto++] = -17;
            out[upto++] = -65;
            out[upto++] = -67;
        }
        result.size = upto;
    }
}

