# inspired from https://github.com/Supervisor/supervisor/issues/712
import sys
import os
import time
import signal

from supervisor.childutils import listener

def main(args):
    while True:
        headers, body = listener.wait(sys.stdin, sys.stdout)
        try:
            if headers["eventname"] != "PROCESS_STATE_EXITED":
                listener.ok(sys.stdout)
                continue

            body = dict([pair.split(":") for pair in body.split(" ")])
            if body['processname'] != args[-1].strip():
                listener.ok(sys.stdout)
                continue

            pid_file = args[-2]
            with open(pid_file) as f:
                supervisord_pid = int(f.read().strip())
            os.kill(supervisord_pid, signal.SIGTERM)
            time.sleep(5)
            os.kill(supervisord_pid, signal.SIGKILL)
            # we're pretty much dead here
            return
        except Exception as e:
            listener.fail(sys.stdout)
            raise


if __name__ == "__main__":
    main(sys.argv[1:])
