# frozen_string_literal: true
class Views::SharedTogo::ErrorBody < ::Views::Base
  needs(:view_title)
  needs(:product_icon => 'shared/products/icon-elastic.svg')
  needs(:product_version => AppConfig.product_version)
  needs(:documentation_url => nil)

  def content(&block)
    body(:class => 'enterprise-search-home enterprise-search-home--error') do
      widget Views::Stui::Components::Icons
      widget Views::SharedTogo::HomeHeader
      div(:class => 'euiPage') do
        div(:class => 'euiPageBody') do
          div(:class => 'euiPageContent euiPageContent--verticalCenter euiPageContent--horizontalCenter') do
            section(:class => 'euiPanel error-container') do
              div(:class => 'error-container__content', &block)
            end
          end
        end
      end
    end
  end
end
