# frozen_string_literal: true

class Views::LocoMoco::Dashboard::SearchExperiences::Preview < ::Views::Base
  needs(:engine)
  needs(:config_params)
  needs(:app_config)
  needs(:search_token)

  def content
    doctype!
    html(:lang => 'en') do
      head do
        common_meta_tags

        stylesheet_packs_with_chunks_tag('eui')
        stylesheet_link_tag('as/reference-ui.css')
        stylesheet_link_tag('as/vendor/reference-ui.css')

        title('App Search Search UI')
      end
      body do
        div(:class => 'host-banner') do
          span
          span(:class => 'host-banner__title') do
            rawtext 'Search experience for &apos;'
            strong do
              text engine.name
            end
            rawtext '&apos;'
          end
          download_button
        end
        div(:class => 'app-container', :id => 'root') do
        end
        # rubocop:disable Rails/OutputSafety
        javascript <<-JAVASCRIPT
          window.appConfig = #{app_config.to_json.html_safe};
        JAVASCRIPT
        # rubocop:enable Rails/OutputSafety
        javascript_include_tag 'reference-ui'
      end
    end
  end

  private

  def download_button
    form_tag(download_loco_moco_engine_search_experience_path(engine, config_params), :method => :post) do
      hidden_field_tag :searchKey, search_token.authentication_token, :id => nil
      button(:type => 'submit', :class => 'euiButton euiButton--primary euiButton--fill') do
        span(:class => 'euiButtonContent euiButton__content') do
          span(:class => 'euiButton__text') do
            text 'Download ZIP Package'
          end
        end
      end
    end
  end
end
