import sys
import psutil
import os
from supervisor.supervisord import main


# cgroup v1 file
docker_memlimit = "/sys/fs/cgroup/memory/memory.limit_in_bytes"

# cgroup v2 file
docker_memlimit_v2 = "/sys/fs/cgroup/memory.max"


def parse_limit(file):
    with open(file) as f:
        value = f.read()
    value = value.strip()
    if value == 'max':
        print("Detected dev/test env with 'unlimited' memory. Hardcoding memory limit to 4GB")
        return 4 * 1024 * 1024  # just for local dev/test envs
    return int(value)


if os.path.exists(docker_memlimit):
    print(
        f"cgroup version 1 detected, reading {docker_memlimit} to find the memory limit"
    )
    system_memory = parse_limit(docker_memlimit)
elif os.path.exists(docker_memlimit_v2):
    print(
        f"cgroup version 2 detected, reading {docker_memlimit} to find the memory limit"
    )
    system_memory = parse_limit(docker_memlimit_v2)
else:
    print(
        "No cgroup detected, Using /proc/meminfo via psutil to get the available physical memory"
    )
    system_memory = psutil.virtual_memory().total


# converting the value in MiB
system_memory = system_memory / 1024 / 1024

connector_max_ram = int(system_memory * 0.4)
print("Calculated connector max RAM is: " + str(connector_max_ram) + "mb")
os.environ["CONNECTOR_MAX_RSS"] = str(connector_max_ram)
sys.argv += ["-c", "/usr/share/enterprise-search/supervisord.conf"]

print("Starting supervisord, see /app/logs/supervisor.log for further output")

# redirect stdout and stderr to devnull
devnull = open(os.devnull, "w")
old_stdout = sys.stdout
old_stderr = sys.stderr
sys.stdout = sys.stderr = devnull

try:
    main()
except Exception:
    # on any error, we set back the stdout/sderr so we can surface the error
    sys.stdout = old_stdout
    sys.stderr = old_stderr

    raise
