#!/bin/bash
set -ex

# running as root
if [ "$EUID" -ne 0 ]
  then echo "Please run as root"
  exit
fi

# install Python 3.10
echo "Installing Python 3.10"
apk update && apk add --no-cache --update-cache python-3.10 python-3.10-dev py3.10-pip py3.10-setuptools

# install virtualenv
echo "Installing virtualenv in /usr/share/enterprise-search"
python -m venv /usr/share/enterprise-search

# update pip
PIP=/usr/share/enterprise-search/bin/pip
$PIP install --upgrade pip

echo "Installing superlance to monitor service memory"
$PIP install supervisor superlance psutil

# update requests to avoid warnings
$PIP install requests==2.27.1 pyyaml
$PIP install -U --ignore-installed wrapt

# remove build tools
# note - these might be needed for the connectors installation when we get there...
apk del python-3.10-dev
