import sys
import os
import contextlib
import yaml
import subprocess
import datetime


version = sys.argv[-2]
version = version.split(".")
major = version[0]
minor = version[1]
lang = sys.argv[-1]


def repo_version(filename):
    with open(filename) as f:
        return f.read().strip().split(".")


@contextlib.contextmanager
def git_clone(repo, version_file):
    cur = os.getcwd()
    try:
        os.system(f"git clone  https://github.com/elastic/{repo}")
        os.chdir(repo)
        with open(version_file) as f:
            main_version = f.read().strip().split(".")

        main_version_major = main_version[0]
        main_version_minor = main_version[1]

        if main_version_major == major and main_version_minor == minor:
            print(f"main branch matched {major}.{minor}")
        else:
            # need to go to the branch
            return_code = os.system(f"git checkout {major}.{minor}")
            if return_code != 0 and major == '8':
                # for brief windows until 8.last FF, we will want the "8.x" branch, rather than a specific minor branch
                return_code = os.system(f"git checkout 8.x")

                if return_code != 0:
                    # We shouldn't ever get here 🤞
                    raise Exception(f"Could not check out the right connector branch for {version}")


        # language specific ops
        yield ".".join(version)
    finally:
        os.chdir(cur)
        os.system(f"rm -rf {repo}")


def install_python():
    version_file = os.path.join("connectors", "VERSION")
    python = '/usr/share/enterprise-search/bin/python'

    with git_clone("connectors-python", version_file) as version:
        if os.uname().machine == "x86_64":
            req_file = os.path.join("requirements", "x86_64.txt")
        else:
            req_file = os.path.join("requirements", "aarch64.txt")

        os.system(f"{python} -m pip install -r {req_file}")

        # XXX we should apply the same logic than Ruby, so we get a continuous version
        # see https://github.com/elastic/enterprise-search-team/issues/3427
        # for now we do it here by:
        # - adding the timestamp to the VERSION file
        # - writing in the prod config file the version, revision and repo fields
        prod_config_file = "/usr/share/enterprise-search/python-connectors.yml"
        with open(prod_config_file) as f:
            prod_config = yaml.safe_load(f)

        prod_config["version"] = version

        for field, cmd in (
            ("revision", "git rev-parse HEAD"),
            ("repository", "git config --get remote.origin.url"),
        ):
            prod_config[field] = (
                subprocess.check_output(cmd, shell=True).decode().strip()
            )

        print(f"Updated prod config at {prod_config_file}")
        with open(prod_config_file, "w") as f:
            yaml.dump(prod_config, f)

        os.system(f"{python} -m pip install .")


install_python()
