#!/bin/bash
set -ex

# running as root
if [ "$EUID" -ne 0 ]
  then echo "Please run as root"
  exit
fi

echo "Installing filebeat and metricbeat..."
mkdir -p /opt/filebeat /opt/metricbeat
tar xf /tmp/install/filebeat.tar.gz -C /opt/filebeat --strip-components=1
tar xf /tmp/install/metricbeat.tar.gz -C /opt/metricbeat --strip-components=1

# installs Python 3.10
echo "Installing Python 3.10"
apk update && apk add --no-cache --update-cache python-3.10 python-3.10-dev py3.10-pip py3.10-setuptools

# installs virtualenv
echo "Installing virtualenv in /usr/share/enterprise-search"
python -m venv /usr/share/enterprise-search

PIP=/usr/share/enterprise-search/bin/pip
PYTHON=/usr/share/enterprise-search/bin/python
BINARIES=/usr/share/enterprise-search/bin
$PIP install --upgrade pip

echo "Installing superlance to monitor service memory"
$PIP install supervisor superlance psutil

# update requests to avoid warnings
$PIP install requests==2.27.1 pyyaml
$PIP install -U --ignore-installed wrapt

echo "Installing Python service..."
$PYTHON /tmp/install/install_connectors.py 8.19.7 python

echo "Verifying installation"
$BINARIES/elastic-ingest --action list -c /usr/share/enterprise-search/python-connectors.yml

# remove build tools
apk del python-3.10-dev
