#!/bin/bash
set -ex

# running as root
if [ "$EUID" -ne 0 ]
  then echo "Please run as root"
  exit
fi

echo "Installing filebeat and metricbeat..."
mkdir -p /opt/filebeat /opt/metricbeat
tar xf /tmp/install/filebeat.tar.gz -C /opt/filebeat --strip-components=1
tar xf /tmp/install/metricbeat.tar.gz -C /opt/metricbeat --strip-components=1

# Python base should already be installed via the base image
# ensure we install Python 3.10 virtualenv though
apt update

# MJH - do not run the upgrade here as we should be set with the latest stable
# apt upgrade -y --no-install-recommends

apt-get install python3.10-venv python3.10-dev software-properties-common -y

# and create the virtualenv
echo "Installing virtualenv in /usr/share/enterprise-search"
python3.10 -m venv /usr/share/enterprise-search

PIP=/usr/share/enterprise-search/bin/pip
PYTHON=/usr/share/enterprise-search/bin/python
BINARIES=/usr/share/enterprise-search/bin
$PIP install --upgrade pip


echo "Installing superlance to monitor service memory"
$PIP install supervisor superlance psutil

# update requests to avoid warnings
$PIP install requests==2.27.1 pyyaml
$PIP install -U --ignore-installed wrapt

echo "Installing Python service..."
$PYTHON /tmp/install/install_connectors.py 8.19.7 python

echo "Verifying installation"
$BINARIES/elastic-ingest --action list -c /usr/share/enterprise-search/python-connectors.yml

# remove build tools
apt-get purge -y --auto-remove software-properties-common python3.10-dev
