# frozen_string_literal: true

module Actastic
  module ActasticRecord
    # This Struct is responsible for storing seq_no and primary_term used for document
    # versioning. Both of them have to be set in API calls that allow version checks.
    DocumentVersion = Struct.new(:primary_term, :seq_no) do
      self::ATTRIBUTES = [:__primary_term___, :__seq_no__].freeze

      def new_record?
        primary_term.nil? && seq_no.nil?
      end

      def save_options
        {
          :if_seq_no => seq_no,
          :if_primary_term => primary_term
        }
      end

      def self.new_from_attributtes(attributes)
        new(attributes[:__primary_term___], attributes[:__seq_no__])
      end

      def self.new_from_es_doc(doc)
        new(doc['_primary_term'], doc['_seq_no'])
      end

      def self.attributes_from_es_doc(doc)
        {
          :__primary_term___ => doc['_primary_term'],
          :__seq_no__ => doc['_seq_no']
        }
      end
    end
  end
end
