/*
 * Decompiled with CFR 0.152.
 */
package fishwife;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Fishwife::IOUtil"})
public class IOUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"write_file"}, meta=true, required=2, argTypes={RubyObject.class, OutputStream.class})
    public static IRubyObject writeFile(ThreadContext tc, IRubyObject klazz, IRubyObject file, IRubyObject ostr) {
        IRubyObject iRubyObject;
        block7: {
            FileInputStream in = null;
            try {
                int len;
                String filePath = file.convertToString().asJavaString();
                in = new FileInputStream(filePath);
                OutputStream out = (OutputStream)ostr.toJava(OutputStream.class);
                byte[] buff = new byte[8192];
                while ((len = in.read(buff)) > 0) {
                    out.write(buff, 0, len);
                }
                iRubyObject = tc.getRuntime().getNil();
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException x) {
                    throw tc.runtime.newIOErrorFromException(x);
                }
            }
            in.close();
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"write"}, meta=true, required=2, argTypes={RubyObject.class, OutputStream.class})
    public static IRubyObject write(ThreadContext tc, IRubyObject klazz, IRubyObject data, IRubyObject out) {
        OutputStream ostream = (OutputStream)out.toJava(OutputStream.class);
        IOUtil.writeToOutputStream(data.convertToString(), ostream);
        return tc.getRuntime().getNil();
    }

    @JRubyMethod(name={"write_body"}, meta=true, required=2, argTypes={RubyObject.class, OutputStream.class})
    public static IRubyObject writeBody(ThreadContext tc, IRubyObject klazz, IRubyObject body, IRubyObject out) {
        OutputStream ostream = (OutputStream)out.toJava(OutputStream.class);
        Helpers.invoke((ThreadContext)tc, (IRubyObject)body, (String)"each", (Block)CallBlock.newCallClosure((IRubyObject)klazz, (RubyModule)tc.getRuntime().getEnumerable(), (Signature)Signature.ONE_ARGUMENT, (BlockCallback)new AppendBlockCallback(tc.getRuntime(), ostream), (ThreadContext)tc));
        return tc.getRuntime().getNil();
    }

    private static void writeToOutputStream(RubyString str, OutputStream out) {
        ByteList blist = str.getByteList();
        try {
            out.write(blist.unsafeBytes(), blist.begin(), blist.length());
        }
        catch (IOException x) {
            throw str.getRuntime().newIOErrorFromException(x);
        }
    }

    @JRubyMethod(name={"read_input_stream"}, meta=true, required=2, argTypes={Integer.class, InputStream.class})
    public static IRubyObject readInputStream(ThreadContext tc, IRubyObject klazz, IRubyObject blen, IRubyObject istr, Block block) {
        Ruby runtime = tc.getRuntime();
        try {
            int len;
            int max_len = (Integer)blen.toJava(Integer.class);
            InputStream in = (InputStream)istr.toJava(InputStream.class);
            byte[] buff = new byte[max_len > 0 ? max_len : 128];
            while ((len = in.read(buff)) > 0) {
                block.call(tc, IOUtil.toRubyString(runtime, buff, 0, len));
                if (max_len != 0) continue;
                buff = new byte[16384];
                max_len = -1;
            }
            return runtime.getNil();
        }
        catch (IOException x) {
            throw tc.runtime.newIOErrorFromException(x);
        }
    }

    public static IRubyObject toRubyString(Ruby runtime, byte[] buff, int offset, int length) {
        return new RubyString(runtime, runtime.getString(), new ByteList(buff, offset, length, (Encoding)ASCIIEncoding.INSTANCE, false));
    }

    public static final class AppendBlockCallback
    implements BlockCallback {
        private final Ruby _runtime;
        private final OutputStream _out;

        public AppendBlockCallback(Ruby runtime, OutputStream out) {
            this._runtime = runtime;
            this._out = out;
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] args, Block blk) {
            IOUtil.writeToOutputStream(args[0].convertToString(), this._out);
            return this._runtime.getNil();
        }
    }
}

